/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.ContentHashesSupport;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.HashIdForwardIndexAccessor;
import com.intellij.util.indexing.HashedInputData;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.ByteSequenceDataExternalizer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SnapshotInputMappings<Key, Value, Input>
implements UpdatableSnapshotInputMappingIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(SnapshotInputMappings.class);
    private static final boolean doReadSavedPersistentData = SystemProperties.getBooleanProperty((String)"idea.read.saved.persistent.index", (boolean)true);
    private final ID<Key, Value> myIndexId;
    private final InputMapExternalizer<Key, Value> myMapExternalizer;
    private final DataIndexer<Key, Value, Input> myIndexer;
    private final PersistentMapBasedForwardIndex myContents;
    private volatile PersistentHashMap<Integer, String> myIndexingTrace;
    private final HashIdForwardIndexAccessor<Key, Value, Input> myHashIdForwardIndexAccessor;
    private final boolean myIsPsiBackedIndex;
    private static final Key<Integer> ourSavedContentHashIdKey = Key.create((String)"saved.content.hash.id");
    private static final Key<Integer> ourSavedUncommittedHashIdKey = Key.create((String)"saved.uncommitted.hash.id");

    SnapshotInputMappings(IndexExtension<Key, Value, Input> indexExtension) throws IOException {
        this.myIndexId = (ID)indexExtension.getName();
        this.myIsPsiBackedIndex = FileBasedIndexImpl.isPsiDependentIndex(indexExtension);
        this.myMapExternalizer = new InputMapExternalizer<Key, Value>(indexExtension);
        this.myIndexer = indexExtension.getIndexer();
        this.myContents = this.createContentsIndex();
        this.myHashIdForwardIndexAccessor = new HashIdForwardIndexAccessor(this);
        this.myIndexingTrace = DebugAssertions.EXTRA_SANITY_CHECKS ? this.createIndexingTrace() : null;
    }

    HashIdForwardIndexAccessor<Key, Value, Input> getForwardIndexAccessor() {
        return this.myHashIdForwardIndexAccessor;
    }

    File getInputIndexStorageFile() {
        return new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "fileIdToHashId");
    }

    @Override
    @NotNull
    public Map<Key, Value> readData(int hashId) throws IOException {
        ByteArraySequence byteSequence = this.readContents(hashId);
        if (byteSequence != null) {
            Map map2 = (Map)AbstractForwardIndexAccessor.deserializeFromByteSeq((ByteArraySequence)byteSequence, this.myMapExternalizer);
            if (map2 == null) {
                SnapshotInputMappings.$$$reportNull$$$0(0);
            }
            return map2;
        }
        Map map3 = Collections.emptyMap();
        if (map3 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(1);
        }
        return map3;
    }

    @Override
    @Nullable
    public InputData<Key, Value> readData(@NotNull Input content2) throws IOException {
        ByteArraySequence bytes;
        if (content2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(2);
        }
        Map data = null;
        int hashId = 0;
        if (doReadSavedPersistentData && (this.myContents == null || !this.myContents.isBusyReading() || DebugAssertions.EXTRA_SANITY_CHECKS) && (bytes = this.readContents(hashId = this.getHashId(content2))) != null) {
            Map contentData;
            boolean sameValueForSavedIndexedResultAndCurrentOne;
            data = (Map)AbstractForwardIndexAccessor.deserializeFromByteSeq((ByteArraySequence)bytes, this.myMapExternalizer);
            if (DebugAssertions.EXTRA_SANITY_CHECKS && !(sameValueForSavedIndexedResultAndCurrentOne = (contentData = this.myIndexer.map(content2)).equals(data))) {
                DebugAssertions.error((String)"Unexpected difference in indexing of %s by index %s\ndiff %s\nprevious indexed info %s", (Object[])new Object[]{this.getContentDebugData(content2), this.myIndexId, this.buildDiff(data, contentData), this.myIndexingTrace.get((Object)hashId)});
            }
        }
        return data == null ? null : new HashedInputData(data, hashId);
    }

    @Override
    public InputData<Key, Value> putData(@Nullable Input content2, @NotNull InputData<Key, Value> data) throws IOException {
        InputData result2;
        int hashId;
        if (data == null) {
            SnapshotInputMappings.$$$reportNull$$$0(3);
        }
        if (data instanceof HashedInputData) {
            hashId = ((HashedInputData)data).getHashId();
            result2 = data;
        } else {
            hashId = this.getHashId(content2);
            result2 = hashId == 0 ? InputData.empty() : new HashedInputData(data.getKeyValues(), hashId);
        }
        boolean saved = this.savePersistentData(data.getKeyValues(), hashId);
        if (DebugAssertions.EXTRA_SANITY_CHECKS && saved) {
            try {
                this.myIndexingTrace.put((Object)hashId, (Object)(this.getContentDebugData(content2) + "," + ExceptionUtil.getThrowableText((Throwable)new Throwable())));
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
        return result2;
    }

    @NotNull
    private String getContentDebugData(Input input) {
        FileContentImpl content2 = (FileContentImpl)((Object)input);
        String string = "[" + content2.getFile().getPath() + ";" + content2.getFileType().getName() + ";" + content2.getCharset() + "]";
        if (string == null) {
            SnapshotInputMappings.$$$reportNull$$$0(4);
        }
        return string;
    }

    private int getHashId(@Nullable Input content2) throws IOException {
        return content2 == null ? 0 : this.getHashOfContent((FileContent)content2);
    }

    @Override
    public void flush() {
        if (this.myContents != null) {
            this.myContents.force();
        }
        if (this.myIndexingTrace != null) {
            this.myIndexingTrace.force();
        }
    }

    @Override
    public void clear() throws IOException {
        block10: {
            try {
                if (this.myIndexingTrace == null) break block10;
                File baseFile = this.myIndexingTrace.getBaseFile();
                try {
                    this.myIndexingTrace.close();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                PersistentHashMap.deleteFilesStartingWith((File)baseFile);
                this.myIndexingTrace = this.createIndexingTrace();
            }
            finally {
                if (this.myContents != null) {
                    try {
                        this.myContents.clear();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        Stream.of(this.myContents, this.myIndexingTrace).filter(Objects::nonNull).forEach(index -> {
            try {
                index.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private PersistentMapBasedForwardIndex createContentsIndex() throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled && !SharedIndicesData.DO_CHECKS) {
            return null;
        }
        File saved = new File(IndexInfrastructure.getPersistentIndexRootDir(this.myIndexId), "values");
        try {
            return new PersistentMapBasedForwardIndex(saved);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)saved);
            throw ex;
        }
    }

    private PersistentHashMap<Integer, String> createIndexingTrace() throws IOException {
        File mapFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "indextrace");
        try {
            return new PersistentHashMap(mapFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<String>(){

                public void save(@NotNull DataOutput out, String value) throws IOException {
                    if (out == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    out.write((byte[])CompressionUtil.compressStringRawBytes((CharSequence)value));
                }

                public String read(@NotNull DataInput in) throws IOException {
                    if (in == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    byte[] b = new byte[((InputStream)((Object)in)).available()];
                    in.readFully(b);
                    return (String)CompressionUtil.uncompressStringRawBytes((Object)b);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "out";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "in";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/util/indexing/SnapshotInputMappings$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "save";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "read";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, 4096);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)mapFile);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArraySequence readContents(Integer hashId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentMapBasedForwardIndex persistentMapBasedForwardIndex = this.myContents;
                synchronized (persistentMapBasedForwardIndex) {
                    ByteArraySequence contentBytes = (ByteArraySequence)SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
                    ByteArraySequence contentBytesFromContents = this.myContents.get(hashId);
                    if (contentBytes == null && contentBytesFromContents != null || !Comparing.equal((Object)contentBytesFromContents, (Object)contentBytes)) {
                        SharedIndicesData.associateContentData(hashId, this.myIndexId, contentBytesFromContents, ByteSequenceDataExternalizer.INSTANCE);
                        if (contentBytes != null) {
                            LOG.error("Unexpected indexing diff with hash id " + this.myIndexId + "," + hashId);
                        }
                        contentBytes = contentBytesFromContents;
                    }
                    return contentBytes;
                }
            }
            return (ByteArraySequence)SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
        }
        return this.myContents.get(hashId);
    }

    private Integer getHashOfContent(FileContent content2) throws IOException {
        Integer previouslyCalculatedContentHashId;
        FileType fileType = content2.getFileType();
        if (this.myIsPsiBackedIndex && content2 instanceof FileContentImpl) {
            PsiDocumentManager psiDocumentManager;
            Document document;
            Integer previouslyCalculatedUncommittedHashId = (Integer)content2.getUserData(ourSavedUncommittedHashIdKey);
            if (previouslyCalculatedUncommittedHashId == null && (document = FileDocumentManager.getInstance().getCachedDocument(content2.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)content2.getProject())).isUncommited(document)) {
                PsiFile file2 = psiDocumentManager.getCachedPsiFile(document);
                Charset charset = ((FileContentImpl)content2).getCharset();
                if (file2 != null) {
                    previouslyCalculatedUncommittedHashId = ContentHashesSupport.calcContentHashIdWithFileType(file2.getText().getBytes(charset), charset, fileType);
                    content2.putUserData(ourSavedUncommittedHashIdKey, (Object)previouslyCalculatedUncommittedHashId);
                }
            }
            if (previouslyCalculatedUncommittedHashId != null) {
                return previouslyCalculatedUncommittedHashId;
            }
        }
        if ((previouslyCalculatedContentHashId = (Integer)content2.getUserData(ourSavedContentHashIdKey)) == null) {
            byte[] hash;
            byte[] byArray = hash = content2 instanceof FileContentImpl ? ((FileContentImpl)content2).getHash() : null;
            if (hash == null) {
                if (fileType.isBinary()) {
                    previouslyCalculatedContentHashId = ContentHashesSupport.calcContentHashId(content2.getContent(), fileType);
                } else {
                    Charset charset = content2 instanceof FileContentImpl ? ((FileContentImpl)content2).getCharset() : null;
                    previouslyCalculatedContentHashId = ContentHashesSupport.calcContentHashIdWithFileType(content2.getContent(), charset, fileType);
                }
            } else {
                previouslyCalculatedContentHashId = ContentHashesSupport.enumerateHash(hash);
            }
            content2.putUserData(ourSavedContentHashIdKey, (Object)previouslyCalculatedContentHashId);
        }
        return previouslyCalculatedContentHashId;
    }

    private StringBuilder buildDiff(Map<Key, Value> data, Map<Key, Value> contentData) {
        Value value;
        StringBuilder moreInfo = new StringBuilder();
        if (contentData.size() != data.size()) {
            moreInfo.append("Indexer has different number of elements, previously ").append(data.size()).append(" after ").append(contentData.size()).append("\n");
        } else {
            moreInfo.append("total ").append(contentData.size()).append(" entries\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : contentData.entrySet()) {
            if (!data.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("Previous data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value = data.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value)) continue;
            moreInfo.append("Previous data has different value for key:").append(keyValueEntry.getKey()).append(", new value ").append(keyValueEntry.getValue()).append(", oldValue:").append(value).append("\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : data.entrySet()) {
            if (!contentData.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("New data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value = contentData.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value)) continue;
            moreInfo.append("New data has different value for key:").append(keyValueEntry.getKey()).append(" new value ").append(value).append(", oldValue:").append(keyValueEntry.getValue()).append("\n");
        }
        return moreInfo;
    }

    private boolean savePersistentData(Map<Key, Value> data, int id) {
        try {
            if (this.myContents != null && this.myContents.isBusyReading() && this.myContents.containsMapping(id)) {
                return false;
            }
            this.saveContents(id, AbstractForwardIndexAccessor.serializeToByteSeq(data, this.myMapExternalizer, (int)data.size()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContents(int id, ByteArraySequence byteSequence) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentMapBasedForwardIndex persistentMapBasedForwardIndex = this.myContents;
                synchronized (persistentMapBasedForwardIndex) {
                    this.myContents.put(Integer.valueOf(id), byteSequence);
                    SharedIndicesData.associateContentData(id, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
                }
            } else {
                SharedIndicesData.associateContentData(id, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
            }
        } else {
            this.myContents.put(Integer.valueOf(id), byteSequence);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/SnapshotInputMappings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "readData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/SnapshotInputMappings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDebugData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

