/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentManagerImpl
implements ContentManager,
PropertyChangeListener,
Disposable.Parent {
    private static final Logger LOG = Logger.getInstance(ContentManagerImpl.class);
    private ContentUI myUI;
    private final List<Content> myContents;
    private final EventDispatcher<ContentManagerListener> myDispatcher;
    private final List<Content> mySelection;
    private final boolean myCanCloseContents;
    private MyNonOpaquePanel myComponent;
    private final Set<Content> myContentWithChangedComponent;
    private boolean myDisposed;
    private final Project myProject;
    private final List<DataProvider> dataProviders;
    private final ArrayList<Content> mySelectionHistory;

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project) {
        if (contentUI == null) {
            ContentManagerImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ContentManagerImpl.$$$reportNull$$$0(1);
        }
        this.myContents = new ArrayList<Content>();
        this.myDispatcher = EventDispatcher.create(ContentManagerListener.class);
        this.mySelection = new ArrayList<Content>();
        this.myContentWithChangedComponent = new HashSet<Content>();
        this.dataProviders = new SmartList();
        this.mySelectionHistory = new ArrayList();
        this.myProject = project;
        this.myCanCloseContents = canCloseContents;
        this.myUI = contentUI;
        this.myUI.setManager((ContentManager)this);
        Disposer.register((Disposable)((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager(), (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)contentUI);
    }

    public boolean canCloseContents() {
        return this.myCanCloseContents;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyNonOpaquePanel();
            NonOpaquePanel contentComponent = new NonOpaquePanel();
            contentComponent.setContent(this.myUI.getComponent());
            this.myComponent.add((Component)contentComponent, "Center");
        }
        MyNonOpaquePanel myNonOpaquePanel = this.myComponent;
        if (myNonOpaquePanel == null) {
            ContentManagerImpl.$$$reportNull$$$0(2);
        }
        return myNonOpaquePanel;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        Content selected2;
        if (requestor == null) {
            ContentManagerImpl.$$$reportNull$$$0(3);
        }
        if ((selected2 = this.getSelectedContent()) == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(4);
            }
            return actionCallback;
        }
        BusyObject busyObject = selected2.getBusyObject();
        ActionCallback actionCallback = busyObject != null ? busyObject.getReady(requestor) : ActionCallback.DONE;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(5);
        }
        return actionCallback;
    }

    public void addContent(@NotNull Content content2, int order) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(6);
        }
        this.doAddContent(content2, order);
    }

    public void addContent(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(7);
        }
        this.doAddContent(content2, -1);
    }

    private void doAddContent(@NotNull Content content2, int index) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContents.contains(content2)) {
            this.myContents.remove(content2);
            this.myContents.add(index == -1 ? this.myContents.size() : index, content2);
            return;
        }
        ((ContentImpl)content2).setManager(this);
        int insertIndex = index == -1 ? this.myContents.size() : index;
        this.myContents.add(insertIndex, content2);
        content2.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireContentAdded(content2, insertIndex);
        if (this.myUI.isToSelectAddedContent() || this.mySelection.isEmpty() && !this.myUI.canBeEmptySelection()) {
            if (this.myUI.isSingleSelection()) {
                this.setSelectedContent(content2);
            } else {
                this.addSelectedContent(content2);
            }
        }
        Disposer.register((Disposable)this, (Disposable)content2);
    }

    public boolean removeContent(@NotNull Content content2, boolean dispose2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(9);
        }
        boolean wasFocused = content2.getComponent() != null && UIUtil.isFocusAncestor((Component)content2.getComponent());
        return this.removeContent(content2, dispose2, wasFocused, false).isDone();
    }

    @NotNull
    public ActionCallback removeContent(@NotNull Content content2, boolean dispose2, boolean requestFocus, boolean forcedFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(10);
        }
        ActionCallback result2 = new ActionCallback();
        this.doRemoveContent(content2, dispose2).doWhenDone(() -> {
            if (requestFocus) {
                Content current = this.getSelectedContent();
                if (current != null) {
                    this.setSelectedContent(current, true, true, !forcedFocus).notify(result2);
                } else {
                    result2.setDone();
                }
            } else {
                result2.setDone();
            }
        });
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(11);
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ActionCallback doRemoveContent(@NotNull Content content2, boolean dispose2) {
        block28: {
            block27: {
                int newSize;
                int indexToSelect;
                int indexToBeRemoved;
                block26: {
                    int selectedIndex;
                    block25: {
                        if (content2 == null) {
                            ContentManagerImpl.$$$reportNull$$$0(12);
                        }
                        ApplicationManager.getApplication().assertIsDispatchThread();
                        indexToBeRemoved = this.getIndexOfContent(content2);
                        if (indexToBeRemoved == -1) {
                            ActionCallback actionCallback = ActionCallback.REJECTED;
                            if (actionCallback == null) {
                                ContentManagerImpl.$$$reportNull$$$0(13);
                            }
                            return actionCallback;
                        }
                        Content selection = this.mySelection.isEmpty() ? null : this.mySelection.get(this.mySelection.size() - 1);
                        int n = selectedIndex = selection != null ? this.myContents.indexOf(selection) : -1;
                        if (!this.fireContentRemoveQuery(content2, indexToBeRemoved)) {
                            ActionCallback actionCallback = ActionCallback.REJECTED;
                            ActionCallback actionCallback2 = actionCallback;
                            if (actionCallback2 == null) {
                                ContentManagerImpl.$$$reportNull$$$0(14);
                            }
                            return actionCallback2;
                        }
                        if (!content2.isValid()) {
                            ActionCallback actionCallback = ActionCallback.REJECTED;
                            ActionCallback actionCallback3 = actionCallback;
                            if (actionCallback3 == null) {
                                ContentManagerImpl.$$$reportNull$$$0(15);
                            }
                            return actionCallback3;
                        }
                        boolean wasSelected = this.isSelected(content2);
                        if (wasSelected) {
                            this.removeFromSelection(content2);
                        }
                        indexToSelect = -1;
                        if (!wasSelected) break block25;
                        int i = indexToBeRemoved - 1;
                        if (i >= 0) {
                            indexToSelect = i;
                            break block26;
                        } else if (this.getContentCount() > 1) {
                            indexToSelect = 0;
                        }
                        break block26;
                    }
                    if (selectedIndex > indexToBeRemoved) {
                        indexToSelect = selectedIndex - 1;
                    }
                }
                this.mySelectionHistory.remove(content2);
                this.myContents.remove(content2);
                content2.removePropertyChangeListener((PropertyChangeListener)this);
                this.fireContentRemoved(content2, indexToBeRemoved);
                ((ContentImpl)content2).setManager(null);
                if (dispose2) {
                    Disposer.dispose((Disposable)content2);
                }
                if ((newSize = this.myContents.size()) <= 0) break block27;
                if (indexToSelect > -1) {
                    Content toSelect2;
                    Content content3 = toSelect2 = !this.mySelectionHistory.isEmpty() ? this.mySelectionHistory.get(0) : this.myContents.get(indexToSelect);
                    if (!this.isSelected(toSelect2)) {
                        if (this.myUI.isSingleSelection()) {
                            ActionCallback result2 = new ActionCallback();
                            this.setSelectedContentCB(toSelect2).notify(result2);
                            ActionCallback actionCallback = result2;
                            ActionCallback actionCallback4 = actionCallback;
                            if (actionCallback4 == null) {
                                ContentManagerImpl.$$$reportNull$$$0(16);
                            }
                            return actionCallback4;
                        }
                        this.addSelectedContent(toSelect2);
                    }
                }
                break block28;
            }
            this.mySelection.clear();
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        ActionCallback actionCallback5 = actionCallback;
        if (actionCallback5 == null) {
            ContentManagerImpl.$$$reportNull$$$0(17);
        }
        return actionCallback5;
        finally {
            if (ApplicationManager.getApplication().isDispatchThread() && !this.myDisposed) {
                this.myUI.getComponent().updateUI();
            }
        }
    }

    public void removeAllContents(boolean dispose2) {
        Content[] contents;
        for (Content content2 : contents = this.getContents()) {
            this.removeContent(content2, dispose2);
        }
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    @NotNull
    public Content[] getContents() {
        Content[] contentArray = this.myContents.toArray(new Content[0]);
        if (contentArray == null) {
            ContentManagerImpl.$$$reportNull$$$0(18);
        }
        return contentArray;
    }

    public Content findContent(String displayName) {
        for (Content content2 : this.myContents) {
            if (!content2.getDisplayName().equals(displayName)) continue;
            return content2;
        }
        return null;
    }

    public Content getContent(int index) {
        return index >= 0 && index < this.myContents.size() ? this.myContents.get(index) : null;
    }

    public Content getContent(@NotNull JComponent component) {
        Content[] contents;
        if (component == null) {
            ContentManagerImpl.$$$reportNull$$$0(19);
        }
        for (Content content2 : contents = this.getContents()) {
            if (!Comparing.equal((Object)component, (Object)content2.getComponent())) continue;
            return content2;
        }
        return null;
    }

    public int getIndexOfContent(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(20);
        }
        return this.myContents.indexOf(content2);
    }

    @NotNull
    public String getCloseActionName() {
        String string = this.myUI.getCloseActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = this.myUI.getCloseAllButThisActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = this.myUI.getPreviousContentActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = this.myUI.getNextContentActionName();
        if (string == null) {
            ContentManagerImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public List<AnAction> getAdditionalPopupActions(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(25);
        }
        List<AnAction> list2 = Collections.emptyList();
        if (list2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(26);
        }
        return list2;
    }

    public boolean canCloseAllContents() {
        if (!this.canCloseContents()) {
            return false;
        }
        for (Content content2 : this.myContents) {
            if (!content2.isCloseable()) continue;
            return true;
        }
        return false;
    }

    public void addSelectedContent(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(27);
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content2, false)) {
            return;
        }
        if (this.getIndexOfContent(content2) == -1) {
            throw new IllegalArgumentException("content not found: " + content2);
        }
        if (!this.isSelected(content2)) {
            this.mySelection.add(content2);
            this.fireSelectionChanged(content2, ContentManagerEvent.ContentOperation.add);
        }
    }

    private boolean checkSelectionChangeShouldBeProcessed(Content content2, boolean implicit) {
        if (!this.myUI.canChangeSelectionTo(content2, implicit)) {
            return false;
        }
        boolean result2 = !this.isSelected(content2) || this.myContentWithChangedComponent.contains(content2);
        this.myContentWithChangedComponent.remove(content2);
        return result2;
    }

    public void removeFromSelection(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(28);
        }
        if (!this.isSelected(content2)) {
            return;
        }
        this.mySelection.remove(content2);
        this.fireSelectionChanged(content2, ContentManagerEvent.ContentOperation.remove);
    }

    public boolean isSelected(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(29);
        }
        return this.mySelection.contains(content2);
    }

    @NotNull
    public Content[] getSelectedContents() {
        Content[] contentArray = this.mySelection.toArray(new Content[0]);
        if (contentArray == null) {
            ContentManagerImpl.$$$reportNull$$$0(30);
        }
        return contentArray;
    }

    @Nullable
    public Content getSelectedContent() {
        return this.mySelection.isEmpty() ? null : this.mySelection.get(0);
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(31);
        }
        this.setSelectedContentCB(content2, requestFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(32);
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content2, requestFocus, true);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(33);
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus, boolean forcedFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(34);
        }
        this.setSelectedContentCB(content2, requestFocus, forcedFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus, boolean forcedFocus) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(35);
        }
        ActionCallback actionCallback = this.setSelectedContent(content2, requestFocus, forcedFocus, false);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(36);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback setSelectedContent(final @NotNull Content content2, final boolean requestFocus, final boolean forcedFocus, boolean implicit) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(37);
        }
        this.mySelectionHistory.remove(content2);
        this.mySelectionHistory.add(0, content2);
        if (this.isSelected(content2) && requestFocus) {
            ActionCallback actionCallback = this.requestFocus(content2, forcedFocus);
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(38);
            }
            return actionCallback;
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content2, implicit)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(39);
            }
            return actionCallback;
        }
        if (!this.myContents.contains(content2)) {
            throw new IllegalArgumentException("Cannot find content:" + content2.getDisplayName());
        }
        boolean focused = this.isSelectionHoldsFocus();
        final Content[] old = this.getSelectedContents();
        ActiveRunnable selection = new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                if (ContentManagerImpl.this.myDisposed || ContentManagerImpl.this.getIndexOfContent(content2) == -1) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return actionCallback;
                }
                for (Content each : old) {
                    ContentManagerImpl.this.removeFromSelection(each);
                }
                ContentManagerImpl.this.addSelectedContent(content2);
                if (requestFocus) {
                    ContentManagerImpl.this.requestFocus(content2, forcedFocus);
                }
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actionCallback;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$1", "run"));
            }
        };
        ActionCallback result2 = new ActionCallback();
        boolean enabledFocus = this.getFocusManager().isFocusTransferEnabled();
        if ((focused || requestFocus) && enabledFocus) {
            ActionCallback actionCallback = this.getFocusManager().requestFocus((Component)this.getComponent(), true).doWhenProcessed(() -> selection.run().notify(result2));
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(40);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = selection.run().notify(result2);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(41);
        }
        return actionCallback;
    }

    private boolean isSelectionHoldsFocus() {
        Content[] selection;
        boolean focused = false;
        for (Content each : selection = this.getSelectedContents()) {
            if (!UIUtil.isFocusAncestor((Component)each.getComponent())) continue;
            focused = true;
            break;
        }
        return focused;
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(42);
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content2, false);
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(43);
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content2) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(44);
        }
        this.setSelectedContentCB(content2);
    }

    public ActionCallback selectPreviousContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = selectedContent == null ? -1 : this.getIndexOfContent(selectedContent);
        index = (index - 1 + contentCount) % contentCount;
        Content content2 = this.getContent(index);
        if (content2 == null) {
            return null;
        }
        return this.setSelectedContentCB(content2, true);
    }

    public ActionCallback selectNextContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = selectedContent == null ? -1 : this.getIndexOfContent(selectedContent);
        index = (index + 1) % contentCount;
        Content content2 = this.getContent(index);
        if (content2 == null) {
            return null;
        }
        return this.setSelectedContentCB(content2, true);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            ContentManagerImpl.$$$reportNull$$$0(45);
        }
        this.myDispatcher.getListeners().add(0, l);
    }

    public void removeContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            ContentManagerImpl.$$$reportNull$$$0(46);
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireContentAdded(@NotNull Content content2, int newIndex) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(47);
        }
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, newIndex, ContentManagerEvent.ContentOperation.add);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
    }

    private void fireContentRemoved(@NotNull Content content2, int oldIndex) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(48);
        }
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, oldIndex, ContentManagerEvent.ContentOperation.remove);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
    }

    private void fireSelectionChanged(@NotNull Content content2, ContentManagerEvent.ContentOperation operation) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(49);
        }
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, this.getIndexOfContent(content2), operation);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
    }

    private boolean fireContentRemoveQuery(@NotNull Content content2, int oldIndex) {
        if (content2 == null) {
            ContentManagerImpl.$$$reportNull$$$0(50);
        }
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content2, oldIndex, ContentManagerEvent.ContentOperation.undefined);
        for (ContentManagerListener listener2 : this.myDispatcher.getListeners()) {
            listener2.contentRemoveQuery(event);
            if (!event.isConsumed()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ActionCallback requestFocus(Content content2, boolean forced) {
        Content toSelect2;
        Content content3 = toSelect2 = content2 == null ? this.getSelectedContent() : content2;
        if (toSelect2 == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ContentManagerImpl.$$$reportNull$$$0(51);
            }
            return actionCallback;
        }
        assert (this.myContents.contains(toSelect2));
        JComponent preferredFocusableComponent = toSelect2.getPreferredFocusableComponent();
        ActionCallback actionCallback = preferredFocusableComponent != null ? this.getFocusManager().requestFocusInProject((Component)preferredFocusableComponent, this.myProject) : ActionCallback.REJECTED;
        if (actionCallback == null) {
            ContentManagerImpl.$$$reportNull$$$0(52);
        }
        return actionCallback;
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            ContentManagerImpl.$$$reportNull$$$0(53);
        }
        this.dataProviders.add(provider);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            ContentManagerImpl.$$$reportNull$$$0(54);
        }
        if ("component".equals(event.getPropertyName())) {
            this.myContentWithChangedComponent.add((Content)event.getSource());
        }
    }

    @NotNull
    public ContentFactory getFactory() {
        ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
        if (contentFactory == null) {
            ContentManagerImpl.$$$reportNull$$$0(55);
        }
        return contentFactory;
    }

    public void beforeTreeDispose() {
        if (this.myDisposed) {
            return;
        }
        this.myUI.beforeDispose();
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myContents.clear();
        this.mySelection.clear();
        this.myContentWithChangedComponent.clear();
        this.myUI = null;
        this.myDispatcher.getListeners().clear();
        this.dataProviders.clear();
        this.myComponent = null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isSingleSelection() {
        return this.myUI.isSingleSelection();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 51: 
            case 52: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 51: 
            case 52: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentUI";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 51: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/content/impl/ContentManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 20: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/content/impl/ContentManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeContent";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doRemoveContent";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseActionName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseAllButThisActionName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousContentActionName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextContentActionName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPopupActions";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedContents";
                break;
            }
            case 33: 
            case 36: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "setSelectedContentCB";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "setSelectedContent";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 51: 
            case 52: 
            case 55: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doAddContent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveContent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfContent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPopupActions";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addSelectedContent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeFromSelection";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 31: 
            case 34: 
            case 37: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContent";
                break;
            }
            case 32: 
            case 35: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContentCB";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addContentManagerListener";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeContentManagerListener";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "fireContentAdded";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "fireContentRemoved";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "fireSelectionChanged";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fireContentRemoveQuery";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addDataProvider";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 51: 
            case 52: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyNonOpaquePanel
    extends NonOpaquePanel
    implements DataProvider {
        MyNonOpaquePanel() {
            super((LayoutManager)new BorderLayout());
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyNonOpaquePanel.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.CONTENT_MANAGER.is(dataId) || PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && ContentManagerImpl.this.getContentCount() > 1) {
                return ContentManagerImpl.this;
            }
            for (DataProvider dataProvider : ContentManagerImpl.this.dataProviders) {
                Object data = dataProvider.getData(dataId);
                if (data == null) continue;
                return data;
            }
            if (ContentManagerImpl.this.myUI instanceof DataProvider) {
                return ((DataProvider)ContentManagerImpl.this.myUI).getData(dataId);
            }
            DataProvider provider = DataManager.getDataProvider((JComponent)((Object)this));
            return provider == null ? null : provider.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ui/content/impl/ContentManagerImpl$MyNonOpaquePanel", "getData"));
        }
    }
}

