/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ProgressSlide;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.ProgressSlideAndImage;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class Splash
extends Window {
    private static final float JBUI_INIT_SCALE = JBUIScale.scale((float)1.0f);
    private final ApplicationInfoEx myInfo;
    private final int myWidth;
    private final int myHeight;
    private final int myProgressHeight;
    private final int myProgressY;
    private double myProgress;
    private int myProgressLastPosition;
    private final Icon myProgressTail;
    private final List<ProgressSlideAndImage> myProgressSlideImages;
    private final Image myImage;
    private final NotNullLazyValue<Font> myFont;

    public Splash(@NotNull ApplicationInfoEx info) {
        if (info == null) {
            Splash.$$$reportNull$$$0(0);
        }
        super((Frame)null);
        this.myProgressLastPosition = 0;
        this.myProgressSlideImages = new ArrayList<ProgressSlideAndImage>();
        this.myFont = Splash.createFont();
        this.myInfo = info;
        this.myProgressHeight = Splash.uiScale(info.getProgressHeight());
        this.myProgressY = Splash.uiScale(info.getProgressY());
        this.myProgressTail = info.getProgressTailIcon();
        this.setFocusableWindowState(false);
        this.myImage = Splash.loadImage(info.getSplashImageUrl());
        this.myWidth = this.myImage.getWidth(null);
        this.myHeight = this.myImage.getHeight(null);
        Dimension size = new Dimension(this.myWidth, this.myHeight);
        this.setAutoRequestFocus(false);
        this.setSize(size);
        this.setLocationInTheCenterOfScreen();
        this.initImages();
        this.setVisible(true);
        this.paint(this.getGraphics());
        this.toFront();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @NotNull
    private static Image loadImage(@NotNull String path) {
        Image result2;
        if (path == null) {
            Splash.$$$reportNull$$$0(1);
        }
        if ((result2 = ImageLoader.loadFromUrl((String)path, Splash.class, (int)1, null, (ScaleContext)ScaleContext.create())) == null) {
            throw new IllegalStateException("Cannot find image: " + path);
        }
        Image image = result2;
        if (image == null) {
            Splash.$$$reportNull$$$0(2);
        }
        return image;
    }

    @NotNull
    public static NotNullLazyValue<Font> createFont() {
        NotNullLazyValue notNullLazyValue = NotNullLazyValue.createValue(() -> {
            Font font;
            if (SystemInfo.isMacOSElCapitan) {
                font = Splash.createFont(".SF NS Text");
            } else {
                Font font2 = font = SystemInfo.isMacOSYosemite ? Splash.createFont("HelveticaNeue-Regular") : null;
            }
            if (font == null || UIUtil.isDialogFont((Font)font)) {
                font = Splash.createFont("Arial");
            }
            return font;
        });
        if (notNullLazyValue == null) {
            Splash.$$$reportNull$$$0(3);
        }
        return notNullLazyValue;
    }

    @Override
    public void paint(Graphics g) {
        StartupUiUtil.drawImage((Graphics)g, (Image)this.myImage, (int)0, (int)0, null);
        this.paintProgress(g);
    }

    private void initImages() {
        List<ProgressSlide> progressSlides = this.myInfo.getProgressSlides();
        if (progressSlides.isEmpty()) {
            return;
        }
        for (ProgressSlide progressSlide : progressSlides) {
            this.myProgressSlideImages.add(new ProgressSlideAndImage(progressSlide, Splash.loadImage(progressSlide.getUrl())));
        }
        this.myProgressSlideImages.sort(Comparator.comparing(t -> Float.valueOf(t.slide.getProgressRation())));
    }

    private void setLocationInTheCenterOfScreen() {
        Rectangle bounds2 = this.getGraphicsConfiguration().getBounds();
        if (SystemInfo.isWindows) {
            JBInsets.removeFrom((Rectangle)bounds2, (Insets)ScreenUtil.getScreenInsets((GraphicsConfiguration)this.getGraphicsConfiguration()));
        }
        this.setLocation(StartupUiUtil.getCenterPoint((Rectangle)bounds2, (Dimension)this.getSize()));
    }

    public void showProgress(double progress) {
        if (this.myInfo.getProgressColor() == null) {
            return;
        }
        if (progress - this.myProgress > 0.01 || progress > 0.99) {
            this.myProgress = progress;
            this.paintProgress(this.getGraphics());
        }
    }

    private void paintProgress(@NotNull Graphics g) {
        Color color;
        boolean hasSlides;
        if (g == null) {
            Splash.$$$reportNull$$$0(4);
        }
        boolean bl = hasSlides = !this.myProgressSlideImages.isEmpty();
        if (hasSlides) {
            this.paintSlides(g);
        }
        if ((color = this.myInfo.getProgressColor()) == null) {
            return;
        }
        int progressWidth = (int)((double)this.myWidth * this.myProgress);
        int currentWidth = progressWidth - this.myProgressLastPosition;
        if (currentWidth == 0) {
            return;
        }
        g.setColor(color);
        int y = hasSlides ? this.myHeight - this.myProgressHeight : this.myProgressY;
        g.fillRect(this.myProgressLastPosition, y, currentWidth, this.myProgressHeight);
        if (this.myProgressTail != null) {
            float onePixel = JBUI_INIT_SCALE;
            this.myProgressTail.paintIcon(this, g, (int)((float)currentWidth - (float)this.myProgressTail.getIconWidth() / onePixel / 2.0f * onePixel), (int)((float)this.myProgressY - (float)(this.myProgressTail.getIconHeight() - this.myProgressHeight) / onePixel / 2.0f * onePixel));
        }
        this.myProgressLastPosition = progressWidth;
    }

    private void paintSlides(@NotNull Graphics g) {
        if (g == null) {
            Splash.$$$reportNull$$$0(5);
        }
        for (ProgressSlideAndImage progressSlide : this.myProgressSlideImages) {
            if (!((double)progressSlide.slide.getProgressRation() <= this.myProgress) || progressSlide.isDrawn) continue;
            StartupUiUtil.drawImage((Graphics)g, (Image)progressSlide.image, (int)0, (int)0, null);
            progressSlide.isDrawn = true;
        }
    }

    public void paintLicenseeInfo() {
        Splash.showLicenseeInfo(this.getGraphics(), 0, 0, this.myHeight, this.myInfo, this.myFont);
    }

    public static boolean showLicenseeInfo(@NotNull Graphics g, int x, int y, int height, @NotNull ApplicationInfoEx info, @NotNull NotNullLazyValue<? extends Font> font) {
        if (g == null) {
            Splash.$$$reportNull$$$0(6);
        }
        if (info == null) {
            Splash.$$$reportNull$$$0(7);
        }
        if (font == null) {
            Splash.$$$reportNull$$$0(8);
        }
        if (!info.showLicenseeInfo()) {
            return false;
        }
        LicensingFacade provider = LicensingFacade.getInstance();
        if (provider == null) {
            return true;
        }
        String licensedToMessage = provider.getLicensedToMessage();
        List<String> licenseRestrictionsMessages = provider.getLicenseRestrictionsMessages();
        if (licensedToMessage == null && licenseRestrictionsMessages.isEmpty()) {
            return true;
        }
        UIUtil.applyRenderingHints((Graphics)g);
        g.setFont((Font)font.getValue());
        g.setColor(info.getSplashTextColor());
        int offsetX = Math.max(Splash.uiScale(15), Splash.uiScale(info.getLicenseOffsetX()));
        int offsetYUnscaled = info.getLicenseOffsetY();
        if (licensedToMessage != null) {
            g.drawString(licensedToMessage, x + offsetX, y + height - Splash.uiScale(offsetYUnscaled));
        }
        if (!licenseRestrictionsMessages.isEmpty()) {
            g.drawString(licenseRestrictionsMessages.get(0), x + offsetX, y + height - Splash.uiScale(offsetYUnscaled - 16));
        }
        return true;
    }

    @NotNull
    private static Font createFont(String name) {
        Font font = new Font(name, 0, Splash.uiScale(12));
        if (font == null) {
            Splash.$$$reportNull$$$0(9);
        }
        return font;
    }

    private static int uiScale(int i) {
        return (int)((float)i * JBUI_INIT_SCALE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/Splash";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/Splash";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadImage";
                break;
            }
            case 3: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "paintProgress";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "paintSlides";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showLicenseeInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

