/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.header;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeaderMenuBar;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.FrameHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.titleLabel.CustomDecorationPath;
import com.intellij.ui.awt.RelativeRectangle;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0015H\u0014J\b\u0010\u001a\u001a\u00020\u0015H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/MainFrameHeader;", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/FrameHeader;", "frame", "Ljavax/swing/JFrame;", "(Ljavax/swing/JFrame;)V", "changeListener", "Ljavax/swing/event/ChangeListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "mainMenuUpdater", "Lcom/intellij/ide/ui/UISettingsListener;", "menuHolder", "Ljavax/swing/JComponent;", "myIdeMenu", "Lcom/intellij/openapi/wm/impl/IdeMenuBar;", "mySelectedEditorFilePath", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/titleLabel/CustomDecorationPath;", "getHitTestSpots", "Ljava/util/ArrayList;", "Lcom/intellij/ui/awt/RelativeRectangle;", "installListeners", "", "setProject", "project", "Lcom/intellij/openapi/project/Project;", "uninstallListeners", "updateActive", "intellij.platform.ide.impl"})
public final class MainFrameHeader
extends FrameHeader {
    private final CustomDecorationPath mySelectedEditorFilePath;
    private final IdeMenuBar myIdeMenu;
    private final JComponent menuHolder;
    private ChangeListener changeListener;
    private final UISettingsListener mainMenuUpdater;
    private Disposable disposable;

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.mySelectedEditorFilePath.setProject(project);
    }

    @Override
    protected void updateActive() {
        super.updateActive();
        this.mySelectedEditorFilePath.setActive(this.getMyActive());
    }

    @Override
    protected void installListeners() {
        this.myIdeMenu.getSelectionModel().addChangeListener(this.changeListener);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable disp = disposable;
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)disp);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect(disp).subscribe(UISettingsListener.TOPIC, (Object)this.mainMenuUpdater);
        this.mainMenuUpdater.uiSettingsChanged(UISettings.Companion.getInstance());
        this.disposable = disp;
        super.installListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.myIdeMenu.getSelectionModel().removeChangeListener(this.changeListener);
        Disposable disposable = this.disposable;
        if (disposable != null) {
            Disposable disposable2 = disposable;
            boolean bl = false;
            boolean bl2 = false;
            Disposable it = disposable2;
            boolean bl3 = false;
            if (!Disposer.isDisposed((Disposable)it)) {
                Disposer.dispose((Disposable)it);
            }
            this.disposable = null;
        }
        super.uninstallListeners();
    }

    @Override
    @NotNull
    public ArrayList<RelativeRectangle> getHitTestSpots() {
        List hitTestSpots = super.getHitTestSpots();
        if (this.menuHolder.isVisible()) {
            Rectangle menuRect = new Rectangle(this.menuHolder.getSize());
            int state = this.getFrame().getExtendedState();
            if (state != 4 && state != 6) {
                int topGap = Math.round(menuRect.height / 3);
                menuRect.y += topGap;
                menuRect.height -= topGap;
            }
            ((ArrayList)hitTestSpots).add(new RelativeRectangle((Component)this.menuHolder, menuRect));
        }
        ((ArrayList)hitTestSpots).addAll((Collection)this.mySelectedEditorFilePath.getListenerBounds());
        return hitTestSpots;
    }

    public MainFrameHeader(@NotNull JFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        super(frame);
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, fillx, ins 0, gap 0, top, hidemode 2", CustomHeader.Companion.getH_GAP() + "[pref!][][grow][pref!]"));
        this.add(this.getProductIcon());
        this.myIdeMenu = new CustomHeaderMenuBar();
        this.changeListener = new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent it) {
                this.updateCustomDecorationHitTestSpots();
            }
        };
        this.mySelectedEditorFilePath = new CustomDecorationPath(frame, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateCustomDecorationHitTestSpots();
            }
        }));
        this.menuHolder = new JPanel((LayoutManager)new MigLayout("filly, ins 0, novisualpadding, hidemode 2", CustomHeader.Companion.getH_GAP() + "[pref!]" + (CustomHeader.Companion.getGAP_AFTER_MENU() - CustomHeader.Companion.getH_GAP())));
        ((JPanel)this.menuHolder).setOpaque(false);
        this.menuHolder.add((Component)this.myIdeMenu, "wmin 0, wmax pref, top, growy");
        this.add((Component)this.menuHolder, "wmin 0, top, growy, pushx");
        this.add((Component)this.mySelectedEditorFilePath.getView(), "left, growx, gapafter " + CustomHeader.Companion.getH_GAP() + ", gapbottom 1, gapbefore " + CustomHeader.Companion.getH_GAP());
        this.add((Component)this.getButtonPanes().getView(), "top, wmin pref");
        this.setCustomFrameTopBorder((Function0<Boolean>)((Function0)new Function0<Boolean>(){

            public final boolean invoke() {
                return this.getMyState() != 4 && this.getMyState() != 6;
            }
        }), (Function0<Boolean>)((Function0)4.INSTANCE));
        this.mainMenuUpdater = new UISettingsListener(){

            public final void uiSettingsChanged(UISettings it) {
                ((JPanel)menuHolder).setVisible(UISettings.Companion.getInstance().getShowMainMenu());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        this.updateCustomDecorationHitTestSpots();
                    }
                });
            }
        };
        ((JPanel)this.menuHolder).setVisible(UISettings.Companion.getInstance().getShowMainMenu());
    }
}

