/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class DetachExternalProjectAction
extends ExternalSystemNodeAction<ProjectData> {
    public DetachExternalProjectAction() {
        super(ProjectData.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.detach.external.project.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(AllIcons.General.Remove);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        if (((Object)((Object)this)).getClass() != DetachExternalProjectAction.class) {
            return;
        }
        ProjectSystemId systemId = this.getSystemId(e);
        String systemIdName = systemId != null ? systemId.getReadableName() : "External";
        Presentation presentation = e.getPresentation();
        presentation.setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{systemIdName}));
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(1);
        }
        if (!super.isEnabled(e)) {
            return false;
        }
        return e.getData(ExternalSystemDataKeys.SELECTED_PROJECT_NODE) != null;
    }

    @Override
    public void perform(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull ProjectData projectData, @NotNull AnActionEvent e) {
        if (project == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(2);
        }
        if (projectSystemId == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(3);
        }
        if (projectData == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(5);
        }
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{projectSystemId.getReadableName()}));
        ProjectNode projectNode = (ProjectNode)e.getData(ExternalSystemDataKeys.SELECTED_PROJECT_NODE);
        assert (projectNode != null);
        ExternalSystemApiUtil.getLocalSettings((Project)project, (ProjectSystemId)projectSystemId).forgetExternalProjects(Collections.singleton(projectData.getLinkedExternalProjectPath()));
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectSystemId).unlinkExternalProject(projectData.getLinkedExternalProjectPath());
        ExternalProjectsManagerImpl.getInstance(project).forgetExternalProjectData(projectSystemId, projectData.getLinkedExternalProjectPath());
        ArrayList<Module> orphanModules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectSystemId, (Module)module)) continue;
            String path = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
            if (!projectData.getLinkedExternalProjectPath().equals(path)) continue;
            orphanModules.add(module);
        }
        if (!orphanModules.isEmpty()) {
            projectNode.getGroup().remove(projectNode);
            ProjectDataManagerImpl.getInstance().removeData(ProjectKeys.MODULE, orphanModules, Collections.emptyList(), projectData, project, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/DetachExternalProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

