/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.application.Topics;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.FrameStateListener;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence;
import com.intellij.internal.statistic.service.fus.collectors.LegacyFUSProjectUsageTrigger;
import com.intellij.internal.statistic.updater.StatisticsNotificationManager;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class StatisticsJobsScheduler
implements ApplicationInitializedListener {
    private static final int SEND_STATISTICS_INITIAL_DELAY_IN_MILLIS = 300000;
    private static final int CHECK_STATISTICS_PROVIDERS_DELAY_IN_MIN = 20;
    public static final int LOG_APPLICATION_STATES_INITIAL_DELAY_IN_MIN = 15;
    public static final int LOG_APPLICATION_STATES_DELAY_IN_MIN = 1440;
    public static final int LOG_PROJECTS_STATES_INITIAL_DELAY_IN_MIN = 30;
    public static final int LOG_PROJECTS_STATES_DELAY_IN_MIN = 720;
    private static final Map<Project, Future> myPersistStatisticsSessionsMap = Collections.synchronizedMap(new HashMap());

    public void componentsInitialized() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (StatisticsUploadAssistant.isShouldShowNotification()) {
            final Disposable disposable = Disposer.newDisposable();
            Topics.subscribe((Topic)FrameStateListener.TOPIC, (Disposable)disposable, (Object)new FrameStateListener(){

                public void onFrameActivated() {
                    if (StatisticsJobsScheduler.isEmpty(((WindowManagerEx)WindowManager.getInstance()).getMostRecentFocusedWindow())) {
                        StatisticsService statisticsService = StatisticsUploadAssistant.getEventLogStatisticsService("FUS");
                        ApplicationManager.getApplication().invokeLater(() -> StatisticsNotificationManager.showNotification(statisticsService));
                        Disposer.dispose((Disposable)disposable);
                    }
                }
            });
        }
        StatisticsJobsScheduler.runEventLogStatisticsService();
        StatisticsJobsScheduler.runStatesLogging();
        StatisticsJobsScheduler.runLegacyDataCleanupService();
        StatisticsJobsScheduler.runSensitiveDataValidatorUpdater();
    }

    private static void runSensitiveDataValidatorUpdater() {
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            List<StatisticsEventLoggerProvider> providers = StatisticsEventLoggerKt.getEventLogProviders();
            for (StatisticsEventLoggerProvider provider : providers) {
                if (!provider.isRecordEnabled()) continue;
                SensitiveDataValidator.getInstance(provider.getRecorderId()).update();
            }
        }, 3L, 180L, TimeUnit.MINUTES);
    }

    private static void runEventLogStatisticsService() {
        JobScheduler.getScheduler().schedule(() -> {
            List<StatisticsEventLoggerProvider> providers = StatisticsEventLoggerKt.getEventLogProviders();
            for (StatisticsEventLoggerProvider provider : providers) {
                if (!provider.isSendEnabled()) continue;
                StatisticsService statisticsService = StatisticsUploadAssistant.getEventLogStatisticsService(provider.getRecorderId());
                StatisticsJobsScheduler.runStatisticsServiceWithDelay(statisticsService, provider.getSendFrequencyMs());
            }
        }, 20L, TimeUnit.MINUTES);
    }

    private static void runStatesLogging() {
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logApplicationStates(), 15L, 1440L, TimeUnit.MINUTES);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                ScheduledFuture<?> future2 = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logProjectStates(project), 30L, 720L, TimeUnit.MINUTES);
                myPersistStatisticsSessionsMap.put(project, future2);
                LegacyFUSProjectUsageTrigger.cleanup(project);
            }

            public void projectClosed(@NotNull Project project) {
                Future future2;
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((future2 = (Future)myPersistStatisticsSessionsMap.remove(project)) != null) {
                    future2.cancel(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/internal/statistic/updater/StatisticsJobsScheduler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void runLegacyDataCleanupService() {
        JobScheduler.getScheduler().schedule(() -> FUStatisticsPersistence.clearLegacyStates(), 1L, TimeUnit.MINUTES);
    }

    private static void runStatisticsServiceWithDelay(@NotNull StatisticsService statisticsService, long delayInMs) {
        if (statisticsService == null) {
            StatisticsJobsScheduler.$$$reportNull$$$0(0);
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(statisticsService::send, 300000L, delayInMs, TimeUnit.MILLISECONDS);
    }

    public StatisticsJobsScheduler() {
        NotificationsConfigurationImpl.remove("SendUsagesStatistics");
    }

    private static boolean isEmpty(Window window) {
        BalloonLayout layout;
        if (window instanceof IdeFrameImpl && (layout = ((IdeFrameImpl)window).getBalloonLayout()) instanceof BalloonLayoutImpl) {
            return ((BalloonLayoutImpl)layout).isEmpty();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statisticsService", "com/intellij/internal/statistic/updater/StatisticsJobsScheduler", "runStatisticsServiceWithDelay"));
    }
}

