/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.BundledKeymapProvider;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsCollectorImpl
extends ActionsCollector {
    private static final String GROUP = "actions";
    public static final String DEFAULT_ID = "third.party";
    private final Set<String> myXmlActionIds;
    private final Map<AnAction, String> myOtherActions;
    private static final Set<String> ourCustomActionWhitelist = ContainerUtil.newHashSet((Object[])new String[]{"tooltip.actions.execute", "tooltip.actions.show.all", "tooltip.actions.show.description.gear", "tooltip.actions.show.description.shortcut", "tooltip.actions.show.description.morelink", "regexp.help", "ShowUsagesPopup.showSettings", "Ics.action.MergeSettings.text", "Ics.action.MergeSettings.text", "Ics.action.ResetToMySettings.text", "Reload Classes", "Progress Paused", "Progress Resumed", "DialogCancelAction", "DialogOkAction", "DoubleShortcut"});

    public static boolean isCustomAllowedAction(@NotNull String actionId) {
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(0);
        }
        return DEFAULT_ID.equals(actionId) || ourCustomActionWhitelist.contains(actionId);
    }

    public ActionsCollectorImpl(@NotNull DefaultKeymap defaultKeymap) {
        if (defaultKeymap == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(1);
        }
        this.myXmlActionIds = new HashSet<String>();
        this.myOtherActions = ContainerUtil.createWeakMap();
        for (Keymap keymap : defaultKeymap.getKeymaps()) {
            Class<BundledKeymapProvider> providerClass;
            if (!(keymap instanceof DefaultKeymapImpl) || !PluginInfoDetectorKt.getPluginInfo(providerClass = ((DefaultKeymapImpl)keymap).getProviderClass()).isDevelopedByJetBrains()) continue;
            this.myXmlActionIds.addAll(keymap.getActionIdList());
        }
    }

    public void record(@Nullable String actionId, @Nullable InputEvent event, @NotNull Class context) {
        if (context == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(2);
        }
        String recorded = StringUtil.isNotEmpty((String)actionId) && ourCustomActionWhitelist.contains(actionId) ? actionId : DEFAULT_ID;
        FeatureUsageData data = new FeatureUsageData();
        if (event instanceof KeyEvent) {
            data.addInputEvent((KeyEvent)event);
        } else if (event instanceof MouseEvent) {
            data.addInputEvent((MouseEvent)event);
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP, recorded, data);
    }

    public void record(@Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Language lang) {
        ActionsCollectorImpl.record(GROUP, project, action2, event, data -> {
            if (lang != null) {
                data.addCurrentFile(lang);
            }
        });
    }

    public static void record(@NotNull String groupId, @Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Consumer<FeatureUsageData> configurator) {
        if (groupId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action2.getClass());
        FeatureUsageData data = new FeatureUsageData().addProject(project).addPluginInfo(info);
        if (event != null) {
            data.addInputEvent(event).addPlace(event.getPlace()).addData("context_menu", event.isFromContextMenu());
        }
        if (configurator != null) {
            configurator.accept(data);
        }
        String actionClassName = info.isSafeToReport() ? action2.getClass().getName() : DEFAULT_ID;
        String actionId = ((ActionsCollectorImpl)ActionsCollectorImpl.getInstance()).getActionId(info, action2);
        if (action2 instanceof ActionWithDelegate) {
            Object delegate = ((ActionWithDelegate)action2).getDelegate();
            PluginInfo delegateInfo = PluginInfoDetectorKt.getPluginInfo(delegate.getClass());
            actionId = delegateInfo.isSafeToReport() ? delegate.getClass().getName() : DEFAULT_ID;
            data.addData("class", actionId);
            data.addData("parent", actionClassName);
        } else {
            data.addData("class", actionClassName);
        }
        FUCounterUsageLogger.getInstance().logEvent(groupId, actionId, data);
    }

    @NotNull
    private String getActionId(@NotNull PluginInfo pluginInfo, @NotNull AnAction action2) {
        if (pluginInfo == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(5);
        }
        if (!pluginInfo.isSafeToReport()) {
            if (DEFAULT_ID == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(6);
            }
            return DEFAULT_ID;
        }
        String actionId = ActionManager.getInstance().getId(action2);
        if (actionId != null && !this.canReportActionId(actionId)) {
            String string = action2.getClass().getName();
            if (string == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (actionId == null) {
            actionId = this.myOtherActions.get(action2);
        }
        String string = actionId != null ? actionId : action2.getClass().getName();
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    private boolean canReportActionId(@NotNull String actionId) {
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(9);
        }
        return this.myXmlActionIds.contains(actionId);
    }

    public void onActionConfiguredByActionId(@NotNull AnAction action2, @NotNull String actionId) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(10);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(11);
        }
        if (this.canReportActionId(actionId)) {
            this.myOtherActions.put(action2, actionId);
        }
    }

    public void onActionLoadedFromXml(@NotNull AnAction action2, @NotNull String actionId, @Nullable PluginId pluginId) {
        PluginInfo pluginInfo;
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(12);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(13);
        }
        if ((pluginInfo = PluginInfoDetectorKt.getPluginInfoById(pluginId)).isSafeToReport()) {
            this.myXmlActionIds.add(actionId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultKeymap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCustomAllowedAction";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canReportActionId";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onActionConfiguredByActionId";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onActionLoadedFromXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

