/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.config;

import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.ProviderWithSettings;
import com.intellij.lang.Language;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/hints/config/SettingsWrapper;", "T", "", "providerWithSettings", "Lcom/intellij/codeInsight/hints/ProviderWithSettings;", "config", "Lcom/intellij/codeInsight/hints/InlayHintsSettings;", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/codeInsight/hints/ProviderWithSettings;Lcom/intellij/codeInsight/hints/InlayHintsSettings;Lcom/intellij/lang/Language;)V", "getConfig", "()Lcom/intellij/codeInsight/hints/InlayHintsSettings;", "getLanguage", "()Lcom/intellij/lang/Language;", "getProviderWithSettings", "()Lcom/intellij/codeInsight/hints/ProviderWithSettings;", "apply", "", "isModified", "", "intellij.platform.lang.impl"})
public final class SettingsWrapper<T> {
    @NotNull
    private final ProviderWithSettings<T> providerWithSettings;
    @NotNull
    private final InlayHintsSettings config;
    @NotNull
    private final Language language;

    public final boolean isModified() {
        T inSettings = this.providerWithSettings.getSettings();
        T stored = InlayHintsUtilsKt.getActualSettings(this.providerWithSettings.getProvider(), this.config, this.language);
        return Intrinsics.areEqual(inSettings, stored) ^ true;
    }

    public final void apply() {
        InlayHintsProvider<T> provider = this.providerWithSettings.getProvider();
        T settingsCopy = InlayHintsUtilsKt.copySettings(this.providerWithSettings.getSettings(), provider);
        this.config.storeSettings(provider.getKey(), this.language, settingsCopy);
    }

    @NotNull
    public final ProviderWithSettings<T> getProviderWithSettings() {
        return this.providerWithSettings;
    }

    @NotNull
    public final InlayHintsSettings getConfig() {
        return this.config;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    public SettingsWrapper(@NotNull ProviderWithSettings<T> providerWithSettings, @NotNull InlayHintsSettings config2, @NotNull Language language) {
        Intrinsics.checkParameterIsNotNull(providerWithSettings, (String)"providerWithSettings");
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        this.providerWithSettings = providerWithSettings;
        this.config = config2;
        this.language = language;
    }
}

