/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.PriorityQuestionAction;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.hint.ScrollAwareHint;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.ide.IdeTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.BitUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HintManagerImpl
extends HintManager {
    private static final Logger LOG = Logger.getInstance(HintManager.class);
    private final MyEditorManagerListener myEditorManagerListener;
    private final EditorMouseListener myEditorMouseListener;
    private final DocumentListener myEditorDocumentListener;
    private final VisibleAreaListener myVisibleAreaListener;
    private final CaretListener myCaretMoveListener;
    private final SelectionListener mySelectionListener;
    private LightweightHint myQuestionHint;
    private QuestionAction myQuestionAction;
    private final List<HintInfo> myHintsStack;
    private Editor myLastEditor;
    private final Alarm myHideAlarm;
    private boolean myRequestFocusForNextHint;

    private static int getPriority(QuestionAction action2) {
        return action2 instanceof PriorityQuestionAction ? ((PriorityQuestionAction)action2).getPriority() : 0;
    }

    public boolean canShowQuestionAction(QuestionAction action2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myQuestionAction == null || HintManagerImpl.getPriority(this.myQuestionAction) <= HintManagerImpl.getPriority(action2);
    }

    public static HintManagerImpl getInstanceImpl() {
        return (HintManagerImpl)((Object)ServiceManager.getService(HintManager.class));
    }

    public HintManagerImpl(@NotNull ProjectManager projectManager) {
        if (projectManager == null) {
            HintManagerImpl.$$$reportNull$$$0(0);
        }
        this.myHintsStack = new ArrayList<HintInfo>();
        this.myHideAlarm = new Alarm();
        this.myEditorManagerListener = new MyEditorManagerListener();
        this.myCaretMoveListener = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                HintManagerImpl.this.hideHints(1026, false, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/HintManagerImpl$1", "caretPositionChanged"));
            }
        };
        this.mySelectionListener = new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                HintManagerImpl.this.hideHints(1024, false, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/HintManagerImpl$2", "selectionChanged"));
            }
        };
        MyProjectManagerListener projectManagerListener2 = new MyProjectManagerListener();
        for (Project project : projectManager.getOpenProjects()) {
            projectManagerListener2.projectOpened(project);
        }
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(ProjectManager.TOPIC, (Object)projectManagerListener2);
        busConnection.subscribe(AnActionListener.TOPIC, (Object)new MyAnActionListener());
        this.myEditorMouseListener = new EditorMouseListener(){

            public void mousePressed(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                HintManagerImpl.this.hideAllHints();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/HintManagerImpl$3", "mousePressed"));
            }
        };
        this.myVisibleAreaListener = e -> {
            this.updateScrollableHints(e);
            if (e.getOldRectangle() == null || e.getOldRectangle().x != e.getNewRectangle().x || e.getOldRectangle().y != e.getNewRectangle().y) {
                this.hideHints(32, false, false);
            }
        };
        this.myEditorDocumentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                HintInfo[] infos;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                LOG.assertTrue(SwingUtilities.isEventDispatchThread());
                if (event.getOldLength() == 0 && event.getNewLength() == 0) {
                    return;
                }
                for (HintInfo info : infos = HintManagerImpl.this.getHintsStackArray()) {
                    if (!BitUtil.isSet((int)info.flags, (int)8)) continue;
                    if (info.hint.isVisible()) {
                        info.hint.hide();
                    }
                    HintManagerImpl.this.myHintsStack.remove(info);
                }
                if (HintManagerImpl.this.myHintsStack.isEmpty()) {
                    HintManagerImpl.this.updateLastEditor(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/HintManagerImpl$4", "documentChanged"));
            }
        };
    }

    public boolean isHint(Window component) {
        return this.myHintsStack.contains(component);
    }

    public void setRequestFocusForNextHint(boolean requestFocus) {
        this.myRequestFocusForNextHint = requestFocus;
    }

    @NotNull
    private HintInfo[] getHintsStackArray() {
        HintInfo[] hintInfoArray = this.myHintsStack.toArray(new HintInfo[0]);
        if (hintInfoArray == null) {
            HintManagerImpl.$$$reportNull$$$0(1);
        }
        return hintInfoArray;
    }

    public boolean performCurrentQuestionAction() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myQuestionAction != null && this.myQuestionHint != null) {
            if (this.myQuestionHint.isVisible()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("performing an action:" + this.myQuestionAction);
                }
                if (this.myQuestionAction.execute() && this.myQuestionHint != null) {
                    this.myQuestionHint.hide();
                }
                return true;
            }
            this.myQuestionAction = null;
            this.myQuestionHint = null;
        }
        return false;
    }

    private void updateScrollableHints(VisibleAreaEvent e) {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (HintInfo info : this.getHintsStackArray()) {
            if (info.hint == null || !BitUtil.isSet((int)info.flags, (int)128)) continue;
            HintManagerImpl.updateScrollableHintPosition(e, info.hint, BitUtil.isSet((int)info.flags, (int)64));
        }
    }

    public boolean hasShownHintsThatWillHideByOtherHint(boolean willShowTooltip) {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (HintInfo hintInfo : this.getHintsStackArray()) {
            if (hintInfo.hint.isVisible() && BitUtil.isSet((int)hintInfo.flags, (int)16)) {
                return true;
            }
            if (!willShowTooltip || !hintInfo.hint.isAwtTooltip()) continue;
            return true;
        }
        return false;
    }

    private static void updateScrollableHintPosition(VisibleAreaEvent e, LightweightHint hint, boolean hideIfOutOfEditor) {
        boolean okToUpdateBounds;
        if (hint.getComponent() instanceof ScrollAwareHint) {
            ((ScrollAwareHint)((Object)hint.getComponent())).editorScrolled();
        }
        if (!hint.isVisible()) {
            return;
        }
        Editor editor = e.getEditor();
        if (!editor.getComponent().isShowing() || editor.isOneLineMode()) {
            return;
        }
        Rectangle newRectangle = e.getOldRectangle();
        Rectangle oldRectangle = e.getNewRectangle();
        Point location = hint.getLocationOn(editor.getContentComponent());
        Dimension size = hint.getSize();
        int xOffset = location.x - oldRectangle.x;
        int yOffset = location.y - oldRectangle.y;
        location = new Point(newRectangle.x + xOffset, newRectangle.y + yOffset);
        Rectangle newBounds = new Rectangle(location.x, location.y, size.width, size.height);
        Rectangle newBoundsForIntersectionCheck = new Rectangle(location.x - 1, location.y - 1, size.width + 2, size.height + 2);
        boolean bl = okToUpdateBounds = hideIfOutOfEditor ? oldRectangle.contains(newBounds) : oldRectangle.intersects(newBoundsForIntersectionCheck);
        if (okToUpdateBounds || hint.vetoesHiding()) {
            hint.setLocation(new RelativePoint((Component)editor.getContentComponent(), location));
        } else {
            hint.hide();
        }
    }

    public void showEditorHint(LightweightHint hint, Editor editor, @HintManager.PositionFlags short constraint, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        editor.getScrollingModel().runActionOnScrollingFinished(() -> {
            LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
            Point p = HintManagerImpl.getHintPosition(hint, editor, pos, constraint);
            this.showEditorHint(hint, editor, p, flags, timeout, reviveOnEditorChange, HintManagerImpl.createHintHint(editor, p, hint, constraint));
        });
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(3);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(4);
        }
        this.showEditorHint(hint, editor, p, flags, timeout, reviveOnEditorChange, (short)1);
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, @HintManager.PositionFlags short position) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(6);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(7);
        }
        HintHint hintHint = HintManagerImpl.createHintHint(editor, p, hint, position).setShowImmediately(true);
        this.showEditorHint(hint, editor, p, flags, timeout, reviveOnEditorChange, hintHint);
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, HintHint hintInfo) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(9);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        this.myHideAlarm.cancelAllRequests();
        this.hideHints(16, false, false);
        if (editor != this.myLastEditor) {
            this.hideAllHints();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
            return;
        }
        if (!ApplicationManager.getApplication().isActive()) {
            return;
        }
        this.updateLastEditor(editor);
        HintManagerImpl.getPublisher().hintShown(editor.getProject(), hint, flags);
        JComponent component = hint.getComponent();
        if (this.myRequestFocusForNextHint) {
            hintInfo.setRequestFocus(true);
            this.myRequestFocusForNextHint = false;
        }
        HintManagerImpl.doShowInGivenLocation(hint, editor, p, hintInfo, true);
        ListenerUtil.addMouseListener(component, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        ListenerUtil.addFocusListener(component, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        if (BitUtil.isSet((int)flags, (int)256)) {
            ListenerUtil.addMouseMotionListener(component, new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    HintManagerImpl.this.hideHints(256, true, false);
                }
            });
        }
        this.myHintsStack.add(new HintInfo(hint, flags, reviveOnEditorChange));
        if (timeout > 0) {
            Timer timer2 = UIUtil.createNamedTimer((String)"Hint timeout", (int)timeout, event -> hint.hide());
            timer2.setRepeats(false);
            timer2.start();
        }
    }

    public void showHint(@NotNull JComponent component, @NotNull RelativePoint p, int flags, int timeout) {
        if (component == null) {
            HintManagerImpl.$$$reportNull$$$0(11);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        this.myHideAlarm.cancelAllRequests();
        this.hideHints(16, false, false);
        final JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(component, null).setRequestFocus(false).setResizable(false).setMovable(false).createPopup();
        popup2.show(p);
        ListenerUtil.addMouseListener(component, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        ListenerUtil.addFocusListener(component, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        HintInfo info = new HintInfo(new LightweightHint(component){

            @Override
            public void hide() {
                popup2.cancel();
            }
        }, flags, false);
        this.myHintsStack.add(info);
        if (timeout > 0) {
            Timer timer2 = UIUtil.createNamedTimer((String)"Popup timeout", (int)timeout, event -> Disposer.dispose((Disposable)popup2));
            timer2.setRepeats(false);
            timer2.start();
        }
    }

    private static void doShowInGivenLocation(LightweightHint hint, Editor editor, Point p, HintHint hintInfo, boolean updateSize) {
        Dimension size;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor);
        Dimension dimension = size = updateSize ? hint.getComponent().getPreferredSize() : hint.getComponent().getSize();
        if (hint.isRealPopup()) {
            Point editorCorner = editor.getComponent().getLocation();
            SwingUtilities.convertPointToScreen(editorCorner, externalComponent);
            Point point = new Point(p);
            SwingUtilities.convertPointToScreen(point, externalComponent);
            Rectangle editorScreen = ScreenUtil.getScreenRectangle((int)point.x, (int)point.y);
            SwingUtilities.convertPointToScreen(p, externalComponent);
            Rectangle rectangle = new Rectangle(p, size);
            ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)editorScreen, null);
            p = rectangle.getLocation();
            SwingUtilities.convertPointFromScreen(p, externalComponent);
        } else if (externalComponent.getWidth() < p.x + size.width && !hintInfo.isAwtTooltip()) {
            p.x = Math.max(0, externalComponent.getWidth() - size.width);
        }
        if (hint.isVisible()) {
            if (updateSize) {
                hint.pack();
            }
            hint.updatePosition(hintInfo.getPreferredPosition());
            hint.updateLocation(p.x, p.y);
        } else {
            hint.show(externalComponent, p.x, p.y, editor.getContentComponent(), hintInfo);
        }
    }

    public static void updateLocation(LightweightHint hint, Editor editor, Point p) {
        HintManagerImpl.doShowInGivenLocation(hint, editor, p, HintManagerImpl.createHintHint(editor, p, hint, (short)2), false);
    }

    public static void adjustEditorHintPosition(LightweightHint hint, Editor editor, Point p, @HintManager.PositionFlags short constraint) {
        HintManagerImpl.doShowInGivenLocation(hint, editor, p, HintManagerImpl.createHintHint(editor, p, hint, constraint), true);
    }

    public void hideAllHints() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (HintInfo info : this.getHintsStackArray()) {
            if (info.hint.vetoesHiding()) continue;
            info.hint.hide();
        }
        this.cleanup();
    }

    public void cleanup() {
        this.myHintsStack.clear();
        this.updateLastEditor(null);
    }

    public Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(14);
        }
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        DataContext dataContext = ((EditorEx)editor).getDataContext();
        Rectangle dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(dataContext);
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        if (dominantArea != null) {
            return HintManagerImpl.getHintPositionRelativeTo(hint, editor, constraint, dominantArea, pos);
        }
        JRootPane rootPane = editor.getComponent().getRootPane();
        if (rootPane != null) {
            JLayeredPane lp = rootPane.getLayeredPane();
            for (HintInfo info : this.getHintsStackArray()) {
                if (!info.hint.isSelectingHint()) continue;
                IdeTooltip tooltip = info.hint.getCurrentIdeTooltip();
                if (tooltip != null) {
                    Point p = tooltip.getShowingPoint().getPoint((Component)lp);
                    if (info.hint != hint) {
                        switch (constraint) {
                            case 1: {
                                if (tooltip.getPreferredPosition() != Balloon.Position.below) break;
                                p.y -= tooltip.getPositionChangeY();
                                break;
                            }
                            case 2: 
                            case 5: {
                                if (tooltip.getPreferredPosition() != Balloon.Position.above) break;
                                p.y += tooltip.getPositionChangeY();
                                break;
                            }
                            case 4: {
                                if (tooltip.getPreferredPosition() != Balloon.Position.atLeft) break;
                                p.x += tooltip.getPositionChangeX();
                                break;
                            }
                            case 3: {
                                if (tooltip.getPreferredPosition() != Balloon.Position.atRight) break;
                                p.x -= tooltip.getPositionChangeX();
                            }
                        }
                    }
                    return p;
                }
                Rectangle rectangle = info.hint.getBounds();
                JComponent c2 = info.hint.getComponent();
                rectangle = SwingUtilities.convertRectangle(c2.getParent(), rectangle, lp);
                return HintManagerImpl.getHintPositionRelativeTo(hint, editor, constraint, rectangle, pos);
            }
        }
        return HintManagerImpl.getHintPosition(hint, editor, pos, constraint);
    }

    private static Point getHintPositionRelativeTo(@NotNull LightweightHint hint, @NotNull Editor editor, @HintManager.PositionFlags short constraint, @NotNull Rectangle lookupBounds, LogicalPosition pos) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(16);
        }
        if (lookupBounds == null) {
            HintManagerImpl.$$$reportNull$$$0(17);
        }
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor);
        IdeTooltip ideTooltip = hint.getCurrentIdeTooltip();
        if (ideTooltip != null) {
            Point point = ideTooltip.getPoint();
            return SwingUtilities.convertPoint(ideTooltip.getComponent(), point, externalComponent);
        }
        Dimension hintSize = hint.getComponent().getPreferredSize();
        int layeredPaneHeight = externalComponent.getHeight();
        switch (constraint) {
            case 3: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x - hintSize.width, y);
            }
            case 4: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x + lookupBounds.width, y);
            }
            case 1: {
                Point posAboveCaret = HintManagerImpl.getHintPosition(hint, editor, pos, (short)1);
                return new Point(lookupBounds.x, Math.min(posAboveCaret.y, lookupBounds.y - hintSize.height));
            }
            case 2: {
                Point posUnderCaret = HintManagerImpl.getHintPosition(hint, editor, pos, (short)2);
                return new Point(lookupBounds.x, Math.max(posUnderCaret.y, lookupBounds.y + lookupBounds.height));
            }
        }
        LOG.error("");
        return null;
    }

    public static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull LogicalPosition pos, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(19);
        }
        if (pos == null) {
            HintManagerImpl.$$$reportNull$$$0(20);
        }
        VisualPosition visualPos = editor.logicalToVisualPosition(pos);
        return HintManagerImpl.getHintPosition(hint, editor, visualPos, visualPos, constraint);
    }

    public static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull VisualPosition pos, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(22);
        }
        if (pos == null) {
            HintManagerImpl.$$$reportNull$$$0(23);
        }
        return HintManagerImpl.getHintPosition(hint, editor, pos, pos, constraint);
    }

    private static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull VisualPosition pos1, @NotNull VisualPosition pos2, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(24);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(25);
        }
        if (pos1 == null) {
            HintManagerImpl.$$$reportNull$$$0(26);
        }
        if (pos2 == null) {
            HintManagerImpl.$$$reportNull$$$0(27);
        }
        return HintManagerImpl.getHintPosition(hint, editor, pos1, pos2, constraint, Registry.is((String)"editor.balloonHints"));
    }

    private static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull VisualPosition pos1, @NotNull VisualPosition pos2, @HintManager.PositionFlags short constraint, boolean showByBalloon) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(28);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(29);
        }
        if (pos1 == null) {
            HintManagerImpl.$$$reportNull$$$0(30);
        }
        if (pos2 == null) {
            HintManagerImpl.$$$reportNull$$$0(31);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return new Point();
        }
        Point p = HintManagerImpl._getHintPosition(hint, editor, pos1, pos2, constraint, showByBalloon);
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor);
        Dimension hintSize = hint.getComponent().getPreferredSize();
        if (constraint == 1) {
            if (p.y < 0) {
                Point p1 = HintManagerImpl._getHintPosition(hint, editor, pos1, pos2, (short)2, showByBalloon);
                if (p1.y + hintSize.height <= externalComponent.getSize().height) {
                    return p1;
                }
            }
        } else if (constraint == 2 && p.y + hintSize.height > externalComponent.getSize().height) {
            Point p1 = HintManagerImpl._getHintPosition(hint, editor, pos1, pos2, (short)1, showByBalloon);
            if (p1.y >= 0) {
                return p1;
            }
        }
        return p;
    }

    @NotNull
    public static JComponent getExternalComponent(@NotNull Editor editor) {
        JComponent externalComponent;
        JRootPane rootPane;
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(32);
        }
        if ((rootPane = (externalComponent = editor.getComponent()).getRootPane()) == null) {
            JComponent jComponent = externalComponent;
            if (jComponent == null) {
                HintManagerImpl.$$$reportNull$$$0(33);
            }
            return jComponent;
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        JComponent jComponent = layeredPane != null ? layeredPane : rootPane;
        if (jComponent == null) {
            HintManagerImpl.$$$reportNull$$$0(34);
        }
        return jComponent;
    }

    private static Point _getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull VisualPosition pos1, @NotNull VisualPosition pos2, @HintManager.PositionFlags short constraint, boolean showByBalloon) {
        Point location;
        Point p;
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(35);
        }
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(36);
        }
        if (pos1 == null) {
            HintManagerImpl.$$$reportNull$$$0(37);
        }
        if (pos2 == null) {
            HintManagerImpl.$$$reportNull$$$0(38);
        }
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor);
        JComponent internalComponent = editor.getContentComponent();
        if (constraint == 5) {
            p = editor.visualPositionToXY(pos2);
            if (!showByBalloon) {
                p.y += editor.getLineHeight();
            }
            location = SwingUtilities.convertPoint(internalComponent, p, externalComponent);
        } else {
            p = editor.visualPositionToXY(pos1);
            if (constraint == 2) {
                p.y += editor.getLineHeight();
            }
            location = SwingUtilities.convertPoint(internalComponent, p, externalComponent);
        }
        if (constraint == 1 && !showByBalloon) {
            location.y -= hintSize.height;
            int diff = location.x + hintSize.width - externalComponent.getWidth();
            if (diff > 0) {
                location.x = Math.max(location.x - diff, 0);
            }
        }
        if (!(constraint != 3 && constraint != 4 || showByBalloon)) {
            location.y -= hintSize.height / 2;
            if (constraint == 3) {
                location.x -= hintSize.width;
            }
        }
        return location;
    }

    public void showErrorHint(@NotNull Editor editor, @NotNull String text2) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(39);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(40);
        }
        this.showErrorHint(editor, text2, (short)1);
    }

    public void showErrorHint(@NotNull Editor editor, @NotNull String text2, short position) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(41);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(42);
        }
        JComponent label2 = HintUtil.createErrorLabel(text2);
        LightweightHint hint = new LightweightHint(label2);
        Point p = this.getHintPosition(hint, editor, position);
        this.showEditorHint(hint, editor, p, 42, 0, false, position);
    }

    public void showInformationHint(@NotNull Editor editor, @NotNull String text2, @HintManager.PositionFlags short position) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(43);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(44);
        }
        this.showInformationHint(editor, text2, null, position);
    }

    public void showInformationHint(@NotNull Editor editor, @NotNull String text2, @Nullable HyperlinkListener listener2) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(45);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(46);
        }
        this.showInformationHint(editor, text2, listener2, (short)1);
    }

    private void showInformationHint(@NotNull Editor editor, @NotNull String text2, @Nullable HyperlinkListener listener2, @HintManager.PositionFlags short position) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(47);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(48);
        }
        JComponent label2 = HintUtil.createInformationLabel(text2, listener2, null, null);
        this.showInformationHint(editor, label2, position);
    }

    public void showInformationHint(@NotNull Editor editor, @NotNull JComponent component) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(49);
        }
        if (component == null) {
            HintManagerImpl.$$$reportNull$$$0(50);
        }
        this.showInformationHint(editor, component, (short)1);
    }

    public void showInformationHint(@NotNull Editor editor, @NotNull JComponent component, @HintManager.PositionFlags short position) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(51);
        }
        if (component == null) {
            HintManagerImpl.$$$reportNull$$$0(52);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        AccessibleContextUtil.setName((Component)component, (String)"Hint");
        LightweightHint hint = new LightweightHint(component);
        Point p = this.getHintPosition(hint, editor, position);
        this.showEditorHint(hint, editor, p, 42, 0, false, position);
    }

    public void showErrorHint(@NotNull Editor editor, @NotNull String hintText, int offset1, int offset2, short constraint, int flags, int timeout) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(53);
        }
        if (hintText == null) {
            HintManagerImpl.$$$reportNull$$$0(54);
        }
        JComponent label2 = HintUtil.createErrorLabel(hintText);
        LightweightHint hint = new LightweightHint(label2);
        VisualPosition pos1 = editor.offsetToVisualPosition(offset1);
        VisualPosition pos2 = editor.offsetToVisualPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor, pos1, pos2, constraint);
        this.showEditorHint(hint, editor, p, flags, timeout, false);
    }

    public void showQuestionHint(@NotNull Editor editor, @NotNull String hintText, int offset1, int offset2, @NotNull QuestionAction action2) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(55);
        }
        if (hintText == null) {
            HintManagerImpl.$$$reportNull$$$0(56);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(57);
        }
        JComponent label2 = HintUtil.createQuestionLabel(hintText);
        LightweightHint hint = new LightweightHint(label2);
        this.showQuestionHint(editor, offset1, offset2, hint, action2, (short)1);
    }

    public void showQuestionHint(@NotNull Editor editor, int offset1, int offset2, @NotNull LightweightHint hint, @NotNull QuestionAction action2, @HintManager.PositionFlags short constraint) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(58);
        }
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(59);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(60);
        }
        VisualPosition pos1 = editor.offsetToVisualPosition(offset1);
        VisualPosition pos2 = editor.offsetToVisualPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor, pos1, pos2, constraint);
        this.showQuestionHint(editor, p, offset1, offset2, hint, action2, constraint);
    }

    public void showQuestionHint(@NotNull Editor editor, @NotNull Point p, int offset1, int offset2, final @NotNull LightweightHint hint, @NotNull QuestionAction action2, @HintManager.PositionFlags short constraint) {
        if (editor == null) {
            HintManagerImpl.$$$reportNull$$$0(61);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(62);
        }
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(63);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(64);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.hideQuestionHint();
        TextAttributes attributes = new TextAttributes();
        attributes.setEffectColor(HintUtil.QUESTION_UNDERSCORE_COLOR);
        attributes.setEffectType(EffectType.LINE_UNDERSCORE);
        final RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset1, offset2, 5001, attributes, HighlighterTargetArea.EXACT_RANGE);
        hint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(@NotNull EventObject event) {
                if (event == null) {
                    11.$$$reportNull$$$0(0);
                }
                hint.removeHintListener(this);
                highlighter.dispose();
                if (HintManagerImpl.this.myQuestionHint == hint) {
                    HintManagerImpl.this.myQuestionAction = null;
                    HintManagerImpl.this.myQuestionHint = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/HintManagerImpl$11", "hintHidden"));
            }
        });
        this.showEditorHint(hint, editor, p, 714, 0, false, HintManagerImpl.createHintHint(editor, p, hint, constraint));
        this.myQuestionAction = action2;
        this.myQuestionHint = hint;
    }

    private void hideQuestionHint() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myQuestionHint != null) {
            this.myQuestionHint.hide();
            this.myQuestionHint = null;
            this.myQuestionAction = null;
        }
    }

    public static HintHint createHintHint(Editor editor, Point p, LightweightHint hint, @HintManager.PositionFlags short constraint) {
        return HintManagerImpl.createHintHint(editor, p, hint, constraint, false);
    }

    public static HintHint createHintHint(Editor editor, Point p, LightweightHint hint, @HintManager.PositionFlags short constraint, boolean createInEditorComponent) {
        JRootPane rootPane = editor.getComponent().getRootPane();
        if (rootPane == null) {
            return new HintHint(editor, p);
        }
        JLayeredPane lp = rootPane.getLayeredPane();
        HintHint hintInfo = new HintHint(editor, SwingUtilities.convertPoint(lp, p, editor.getContentComponent()));
        boolean showByBalloon = Registry.is((String)"editor.balloonHints");
        if (showByBalloon) {
            if (!createInEditorComponent) {
                hintInfo = new HintHint(lp, p);
            }
            hintInfo.setAwtTooltip(true).setHighlighterType(true);
        }
        hintInfo.initStyleFrom(hint.getComponent());
        if (showByBalloon) {
            hintInfo.setBorderColor((Color)new JBColor(Color.gray, (Color)Gray._140));
            hintInfo.setFont(hintInfo.getTextFont().deriveFont(0));
            hintInfo.setCalloutShift((int)((double)editor.getLineHeight() * 0.1));
        }
        hintInfo.setPreferredPosition(Balloon.Position.above);
        if (constraint == 2 || constraint == 5) {
            hintInfo.setPreferredPosition(Balloon.Position.below);
        } else if (constraint == 4) {
            hintInfo.setPreferredPosition(Balloon.Position.atRight);
        } else if (constraint == 3) {
            hintInfo.setPreferredPosition(Balloon.Position.atLeft);
        }
        if (hint.isAwtTooltip()) {
            hintInfo.setAwtTooltip(true);
        }
        hintInfo.setPositionChangeShift(0, editor.getLineHeight());
        return hintInfo;
    }

    protected void updateLastEditor(Editor editor) {
        if (this.myLastEditor != editor) {
            if (this.myLastEditor != null) {
                this.myLastEditor.removeEditorMouseListener(this.myEditorMouseListener);
                this.myLastEditor.getDocument().removeDocumentListener(this.myEditorDocumentListener);
                this.myLastEditor.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
                this.myLastEditor.getCaretModel().removeCaretListener(this.myCaretMoveListener);
                this.myLastEditor.getSelectionModel().removeSelectionListener(this.mySelectionListener);
            }
            this.myLastEditor = editor;
            if (this.myLastEditor != null) {
                this.myLastEditor.addEditorMouseListener(this.myEditorMouseListener);
                this.myLastEditor.getDocument().addDocumentListener(this.myEditorDocumentListener);
                this.myLastEditor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
                this.myLastEditor.getCaretModel().addCaretListener(this.myCaretMoveListener);
                this.myLastEditor.getSelectionModel().addSelectionListener(this.mySelectionListener);
            }
        }
    }

    boolean isEscapeHandlerEnabled() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (int i = this.myHintsStack.size() - 1; i >= 0; --i) {
            HintInfo info = this.myHintsStack.get(i);
            if (!info.hint.isVisible()) {
                this.myHintsStack.remove(i);
                info.hint.hide();
                continue;
            }
            if ((info.flags & 3) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hideHints(int mask, boolean onlyOne, boolean editorChanged) {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        try {
            boolean done = false;
            for (int i = this.myHintsStack.size() - 1; i >= 0; --i) {
                HintInfo info = this.myHintsStack.get(i);
                if (!info.hint.isVisible() && !info.hint.vetoesHiding()) {
                    this.myHintsStack.remove(i);
                    info.hint.hide();
                    continue;
                }
                if ((info.flags & mask) == 0 && (!editorChanged || info.reviveOnEditorChange)) continue;
                info.hint.hide();
                this.myHintsStack.remove(info);
                if ((mask & 1) != 0 && (info.flags & 0x200) != 0) continue;
                if (onlyOne) {
                    boolean bl = true;
                    return bl;
                }
                done = true;
            }
            boolean bl = done;
            return bl;
        }
        finally {
            if (this.myHintsStack.isEmpty()) {
                this.updateLastEditor(null);
            }
        }
    }

    private static EditorHintListener getPublisher() {
        return EditorHintListenerHolder.ourEditorHintPublisher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectManager";
                break;
            }
            case 1: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/HintManagerImpl";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 35: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 11: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupBounds";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 26: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos1";
                break;
            }
            case 27: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos2";
                break;
            }
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintText";
                break;
            }
            case 57: 
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/HintManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHintsStackArray";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 33: 
            case 34: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showEditorHint";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getHintPosition";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHintPositionRelativeTo";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getExternalComponent";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "_getHintPosition";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "showInformationHint";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "showQuestionHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EditorHintListenerHolder {
        private static final EditorHintListener ourEditorHintPublisher = (EditorHintListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorHintListener.TOPIC);

        private EditorHintListenerHolder() {
        }
    }

    private final class MyProjectManagerListener
    implements ProjectManagerListener {
        private MyProjectManagerListener() {
        }

        public void projectOpened(@NotNull Project project) {
            if (project == null) {
                MyProjectManagerListener.$$$reportNull$$$0(0);
            }
            project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)HintManagerImpl.this.myEditorManagerListener);
        }

        public void projectClosed(@NotNull Project project) {
            if (project == null) {
                MyProjectManagerListener.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            TooltipController.getInstance().cancelTooltips();
            ApplicationManager.getApplication().invokeLater(() -> HintManagerImpl.this.hideHints(0, false, false));
            HintManagerImpl.this.myQuestionAction = null;
            HintManagerImpl.this.myQuestionHint = null;
            if (HintManagerImpl.this.myLastEditor != null && project == HintManagerImpl.this.myLastEditor.getProject()) {
                HintManagerImpl.this.updateLastEditor(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/codeInsight/hint/HintManagerImpl$MyProjectManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyEditorManagerListener
    implements FileEditorManagerListener {
        private MyEditorManagerListener() {
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyEditorManagerListener.$$$reportNull$$$0(0);
            }
            HintManagerImpl.this.hideHints(0, false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/HintManagerImpl$MyEditorManagerListener", "selectionChanged"));
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            if (action2 instanceof ActionToIgnore) {
                return;
            }
            AnAction escapeAction = ActionManagerEx.getInstanceEx().getAction("EditorEscape");
            if (action2 == escapeAction) {
                return;
            }
            HintManagerImpl.this.hideHints(2, false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/hint/HintManagerImpl$MyAnActionListener";
            objectArray[2] = "beforeActionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HintInfo {
        final LightweightHint hint;
        @HintManager.HideFlags
        final int flags;
        private final boolean reviveOnEditorChange;

        private HintInfo(LightweightHint hint, @HintManager.HideFlags int flags, boolean reviveOnEditorChange) {
            this.hint = hint;
            this.flags = flags;
            this.reviveOnEditorChange = reviveOnEditorChange;
        }
    }

    public static interface ActionToIgnore {
    }
}

