/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.CollapseBlockHandler;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CollapseBlockHandlerImpl
implements CollapseBlockHandler {
    Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.CollapseBlockHandler");

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(2);
        }
        int[] targetCaretOffset = new int[]{-1};
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            EditorFoldingInfo info = EditorFoldingInfo.get(editor);
            FoldingModelEx model2 = (FoldingModelEx)editor.getFoldingModel();
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file2.findElementAt(offset - 1);
            if (!this.isEndBlockToken(element)) {
                element = file2.findElementAt(offset);
            }
            if (element == null) {
                return;
            }
            PsiElement block = this.findParentBlock(element);
            FoldRegion previous = null;
            FoldRegion myPrevious = null;
            while (block != null) {
                int end;
                TextRange range2 = this.getFoldingRange(block);
                if (!range2.containsOffset(offset)) {
                    block = this.findParentBlock(block);
                    continue;
                }
                int start2 = range2.getStartOffset();
                FoldRegion existing = FoldingUtil.findFoldRegion(editor, start2, end = range2.getEndOffset());
                if (existing != null) {
                    if (existing.isExpanded()) {
                        existing.setExpanded(false);
                        targetCaretOffset[0] = existing.getEndOffset();
                        return;
                    }
                    previous = existing;
                    if (info.getPsiElement(existing) == null) {
                        myPrevious = existing;
                    }
                    block = this.findParentBlock(block);
                    continue;
                }
                if (model2.intersectsRegion(start2, end)) break;
                FoldRegion region = model2.addFoldRegion(start2, end, this.getPlaceholderText());
                this.LOG.assertTrue(region != null);
                region.setExpanded(false);
                if (myPrevious != null && info.getPsiElement(region) == null) {
                    info.removeRegion(myPrevious);
                    model2.removeFoldRegion(myPrevious);
                }
                targetCaretOffset[0] = block.getTextRange().getEndOffset() < offset ? start2 : end;
                return;
            }
            if (previous != null) {
                previous.setExpanded(false);
                if (myPrevious != null) {
                    info.removeRegion(myPrevious);
                    model2.removeFoldRegion(myPrevious);
                }
                targetCaretOffset[0] = previous.getEndOffset();
            }
        });
        if (targetCaretOffset[0] >= 0) {
            editor.getCaretModel().moveToOffset(targetCaretOffset[0]);
        }
    }

    @Nullable
    protected abstract PsiElement findParentBlock(@Nullable PsiElement var1);

    protected abstract boolean isEndBlockToken(@Nullable PsiElement var1);

    @NotNull
    protected String getPlaceholderText() {
        if ("{...}" == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(3);
        }
        return "{...}";
    }

    @NotNull
    protected TextRange getFoldingRange(@NotNull PsiElement element) {
        if (element == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(4);
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            CollapseBlockHandlerImpl.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/CollapseBlockHandlerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/CollapseBlockHandlerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

