/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.component;

import com.intellij.application.options.codeStyle.arrangement.component.AbstractArrangementUiComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Alarm;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class ArrangementTextFieldUiComponent
extends AbstractArrangementUiComponent {
    @NotNull
    private final JBTextField myTextField;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final ArrangementSettingsToken myToken;

    public ArrangementTextFieldUiComponent(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            ArrangementTextFieldUiComponent.$$$reportNull$$$0(0);
        }
        super(token);
        this.myTextField = new JBTextField(20);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myToken = token;
        this.myTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ArrangementTextFieldUiComponent.this.scheduleUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ArrangementTextFieldUiComponent.this.scheduleUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ArrangementTextFieldUiComponent.this.scheduleUpdate();
            }
        });
    }

    private void scheduleUpdate() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.fireStateChanged(), 1000);
    }

    @NotNull
    public ArrangementSettingsToken getToken() {
        ArrangementSettingsToken arrangementSettingsToken = this.myToken;
        if (arrangementSettingsToken == null) {
            ArrangementTextFieldUiComponent.$$$reportNull$$$0(1);
        }
        return arrangementSettingsToken;
    }

    public void chooseToken(@NotNull ArrangementSettingsToken data) throws IllegalArgumentException, UnsupportedOperationException {
        if (data == null) {
            ArrangementTextFieldUiComponent.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public ArrangementMatchCondition getMatchCondition() {
        String text2 = this.myTextField.getText();
        ArrangementAtomMatchCondition arrangementAtomMatchCondition = new ArrangementAtomMatchCondition(this.myToken, (Object)(StringUtil.isEmpty((String)text2) ? "" : text2.trim()));
        if (arrangementAtomMatchCondition == null) {
            ArrangementTextFieldUiComponent.$$$reportNull$$$0(3);
        }
        return arrangementAtomMatchCondition;
    }

    @Override
    protected JComponent doGetUiComponent() {
        return this.myTextField;
    }

    public boolean isSelected() {
        return !StringUtil.isEmpty((String)this.myTextField.getText());
    }

    public void setSelected(boolean selected2) {
    }

    @Override
    public boolean isEnabled() {
        return this.myTextField.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTextField.setEnabled(enabled);
    }

    @Override
    public void setData(@NotNull Object data) {
        if (data == null) {
            ArrangementTextFieldUiComponent.$$$reportNull$$$0(4);
        }
        if (data instanceof String) {
            this.myTextField.setText(data.toString());
        }
    }

    @Override
    public void doReset() {
        this.myTextField.setText("");
    }

    public int getBaselineToUse(int width, int height) {
        return this.myTextField.getBaseline(width, height);
    }

    public void handleMouseClickOnSelected() {
        this.setSelected(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/component/ArrangementTextFieldUiComponent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/component/ArrangementTextFieldUiComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToken";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "chooseToken";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

