/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.BaseCollectionBinding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.WriteContext;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u000f2\u0006\u0010\u0004\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0016H\u0016R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/serialization/CollectionBinding;", "Lcom/intellij/serialization/BaseCollectionBinding;", "type", "Ljava/lang/reflect/ParameterizedType;", "context", "Lcom/intellij/serialization/BindingInitializationContext;", "(Ljava/lang/reflect/ParameterizedType;Lcom/intellij/serialization/BindingInitializationContext;)V", "collectionClass", "Ljava/lang/Class;", "createCollection", "", "", "propertyForDebugPurposes", "Lcom/intellij/serialization/MutableAccessor;", "deserialize", "", "Lcom/intellij/serialization/ReadContext;", "hostObject", "", "property", "serialize", "obj", "Lcom/intellij/serialization/WriteContext;", "intellij.platform.objectSerializer"})
public final class CollectionBinding
extends BaseCollectionBinding {
    private final Class<?> collectionClass;

    @Override
    @NotNull
    public Collection<Object> deserialize(@NotNull ReadContext context, @Nullable Object hostObject) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getReader().getType() == IonType.INT) {
            ObjectSerializerKt.getLOG().assertTrue(context.getReader().intValue() == 0);
            return Set.class.isAssignableFrom(this.collectionClass) ? (Collection)SetsKt.emptySet() : (Collection)CollectionsKt.emptyList();
        }
        Collection result = CollectionBinding.createCollection$default(this, null, 1, null);
        this.readInto(hostObject, result, context);
        return result;
    }

    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IonWriter writer = context.getWriter();
        Collection collection = (Collection)obj2;
        if (context.getFilter().getSkipEmptyCollection() && collection.isEmpty()) {
            writer.writeInt(0L);
            return;
        }
        writer.stepIn(IonType.LIST);
        collection.forEach(this.createItemConsumer(context));
        writer.stepOut();
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context) {
        Intrinsics.checkParameterIsNotNull((Object)hostObject, (String)"hostObject");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IonType type = context.getReader().getType();
        if (type == IonType.NULL) {
            property.set(hostObject, null);
            return;
        }
        if (type == IonType.INT) {
            return;
        }
        Collection result = TypeIntrinsics.asMutableCollection((Object)property.readUnsafe(hostObject));
        if (result != null && ClassUtil.isMutableCollection((Object)result)) {
            result.clear();
        } else {
            result = CollectionBinding.createCollection$default(this, null, 1, null);
            property.set(hostObject, (Object)result);
        }
        this.readInto(hostObject, result, context);
    }

    private final Collection<Object> createCollection(MutableAccessor propertyForDebugPurposes) {
        if (this.collectionClass.isInterface()) {
            Class<?> clazz = this.collectionClass;
            if (Intrinsics.areEqual(clazz, Set.class)) {
                return (Collection)new THashSet();
            }
            if (Intrinsics.areEqual(clazz, List.class) || Intrinsics.areEqual(clazz, Collection.class)) {
                return new ArrayList();
            }
        } else {
            Collection collection;
            Class<?> clazz = this.collectionClass;
            if (Intrinsics.areEqual(clazz, THashSet.class)) {
                collection = (Collection)new THashSet();
            } else if (Intrinsics.areEqual(clazz, HashSet.class)) {
                collection = new HashSet();
            } else if (Intrinsics.areEqual(clazz, ArrayList.class)) {
                collection = new ArrayList();
            } else if (Intrinsics.areEqual(clazz, SmartList.class)) {
                collection = (Collection)new SmartList();
            } else {
                Object object = ReflectionUtil.newInstance(this.collectionClass, (boolean)false);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<kotlin.Any?>");
                }
                collection = TypeIntrinsics.asMutableCollection((Object)object);
            }
            return collection;
        }
        ObjectSerializerKt.getLOG().warn("Unknown collection type interface: " + this.collectionClass + " (property: " + propertyForDebugPurposes + ')');
        return new ArrayList();
    }

    static /* synthetic */ Collection createCollection$default(CollectionBinding collectionBinding, MutableAccessor mutableAccessor, int n, Object object) {
        if ((n & 1) != 0) {
            mutableAccessor = null;
        }
        return collectionBinding.createCollection(mutableAccessor);
    }

    public CollectionBinding(@NotNull ParameterizedType type, @NotNull BindingInitializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Type type2 = type.getActualTypeArguments()[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"type.actualTypeArguments[0]");
        super(type2, context);
        Class clazz = ClassUtil.typeToClass((Type)type);
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"ClassUtil.typeToClass(type)");
        this.collectionClass = clazz;
    }
}

