/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InclusionListener;
import com.intellij.openapi.vcs.changes.InclusionModel;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeCopyProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeCellRenderer;
import com.intellij.openapi.vcs.changes.ui.DefaultInclusionModel;
import com.intellij.openapi.vcs.changes.ui.NullInclusionModel;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTree
extends Tree
implements DataProvider {
    @NotNull
    protected final Project myProject;
    private boolean myShowCheckboxes;
    @Nullable
    private ClickListener myCheckBoxClickHandler;
    private final int myCheckboxWidth;
    @NotNull
    private final ChangesGroupingSupport myGroupingSupport;
    private boolean myIsModelFlat;
    @NotNull
    private InclusionModel myInclusionModel;
    @NotNull
    private final InclusionListener myInclusionModelListener;
    @Nullable
    private Runnable myTreeInclusionListener;
    @NotNull
    private Runnable myDoubleClickHandler;
    private boolean myKeepTreeState;
    @Deprecated
    @NonNls
    private static final String FLATTEN_OPTION_KEY = "ChangesBrowser.SHOW_FLATTEN";
    @NonNls
    private static final String GROUPING_KEYS = "ChangesTree.GroupingKeys";
    public static final String[] DEFAULT_GROUPING_KEYS = (String[])ContainerUtil.ar((Object[])new String[]{"directory", "module"});
    @NonNls
    public static final String GROUP_BY_ACTION_GROUP = "ChangesView.GroupBy";
    @NotNull
    private final CopyProvider myTreeCopyProvider;
    @NotNull
    private TreeExpander myTreeExpander;
    private boolean myModelUpdateInProgress;

    public ChangesTree(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            ChangesTree.$$$reportNull$$$0(0);
        }
        this(project, showCheckboxes, highlightProblems, false);
    }

    protected ChangesTree(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, boolean expandInSpeedSearch) {
        if (project == null) {
            ChangesTree.$$$reportNull$$$0(1);
        }
        super((TreeNode)ChangesBrowserNode.createRoot());
        this.myInclusionModel = new DefaultInclusionModel();
        this.myInclusionModelListener = () -> {
            this.notifyInclusionListener();
            this.repaint();
        };
        this.myDoubleClickHandler = EmptyRunnable.getInstance();
        this.myKeepTreeState = false;
        this.myTreeExpander = new MyTreeExpander();
        this.myProject = project;
        this.myShowCheckboxes = showCheckboxes;
        this.myCheckboxWidth = new JCheckBox().getPreferredSize().width;
        this.myInclusionModel.addInclusionListener(this.myInclusionModelListener);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        new TreeSpeedSearch((Tree)this, ChangesBrowserNode.TO_TEXT_CONVERTER, expandInSpeedSearch);
        ChangesBrowserNodeRenderer nodeRenderer = new ChangesBrowserNodeRenderer(this.myProject, this::isShowFlatten, highlightProblems);
        this.setCellRenderer(new ChangesTreeCellRenderer(nodeRenderer));
        new MyToggleSelectionAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)((Object)this));
        this.showCheckboxesChanged();
        this.installEnterKeyHandler();
        this.installDoubleClickHandler();
        this.installTreeLinkHandler(nodeRenderer);
        SmartExpander.installOn((JTree)((Object)this));
        this.myGroupingSupport = this.installGroupingSupport();
        this.setEmptyText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        this.myTreeCopyProvider = new ChangesBrowserNodeCopyProvider((JTree)((Object)this));
    }

    private ClickListener installCheckBoxClickHandler() {
        ClickListener handler = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                TreePath path;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((path = ChangesTree.this.getPathIfCheckBoxClicked(event.getPoint())) != null) {
                    ChangesTree.this.setSelectionPath(path);
                    ChangesTree.this.toggleChanges(ChangesTree.this.getIncludableUserObjects(VcsTreeModelData.selected((JTree)((Object)ChangesTree.this))));
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/ui/ChangesTree$1", "onClick"));
            }
        };
        handler.installOn((Component)((Object)this));
        return handler;
    }

    @Nullable
    private TreePath getPathIfCheckBoxClicked(@NotNull Point p) {
        if (p == null) {
            ChangesTree.$$$reportNull$$$0(2);
        }
        if (!this.myShowCheckboxes || !this.isEnabled()) {
            return null;
        }
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path == null) {
            return null;
        }
        Rectangle pathBounds = this.getPathBounds(path);
        if (pathBounds == null) {
            return null;
        }
        Rectangle checkBoxBounds = pathBounds.getBounds();
        checkBoxBounds.setSize(this.myCheckboxWidth, checkBoxBounds.height);
        return checkBoxBounds.contains(p) && this.isIncludable(path) ? path : null;
    }

    protected void installEnterKeyHandler() {
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangesTree.this.myDoubleClickHandler.run();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode() && e.getModifiers() == 0) {
                    if (ChangesTree.this.getSelectionCount() <= 1) {
                        Object lastPathComponent = ChangesTree.this.getLastSelectedPathComponent();
                        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
                            return;
                        }
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
                        if (!node.isLeaf()) {
                            return;
                        }
                    }
                    ChangesTree.this.myDoubleClickHandler.run();
                    e.consume();
                }
            }
        });
    }

    protected void installDoubleClickHandler() {
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TreePath clickPath;
                TreePath treePath = clickPath = WideSelectionTreeUI.isWideSelection((JTree)((Object)ChangesTree.this)) ? ChangesTree.this.getClosestPathForLocation(e.getX(), e.getY()) : ChangesTree.this.getPathForLocation(e.getX(), e.getY());
                if (clickPath == null) {
                    return false;
                }
                if (ChangesTree.this.getPathIfCheckBoxClicked(e.getPoint()) != null) {
                    return false;
                }
                ChangesTree.this.myDoubleClickHandler.run();
                return true;
            }
        }.installOn((Component)((Object)this));
    }

    protected void installTreeLinkHandler(@NotNull ChangesBrowserNodeRenderer nodeRenderer) {
        if (nodeRenderer == null) {
            ChangesTree.$$$reportNull$$$0(3);
        }
        new TreeLinkMouseListener(nodeRenderer){

            protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree, @NotNull TreePath path) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (tree == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(2);
                }
                int x = super.getRendererRelativeX(e, tree, path);
                return !ChangesTree.this.myShowCheckboxes ? x : x - ChangesTree.this.myCheckboxWidth;
            }

            public void mouseMoved(MouseEvent e) {
                if (!ChangesTree.this.isEmpty()) {
                    super.mouseMoved(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tree";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$5";
                objectArray[2] = "getRendererRelativeX";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.installOn((Component)((Object)this));
    }

    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        ChangesGroupingSupport result2 = new ChangesGroupingSupport(this.myProject, (Object)this, false);
        this.migrateShowFlattenSetting();
        result2.setGroupingKeysOrSkip(ContainerUtil.set((Object[])((Object[])ObjectUtils.notNull((Object)PropertiesComponent.getInstance((Project)this.myProject).getValues(GROUPING_KEYS), (Object)DEFAULT_GROUPING_KEYS))));
        result2.addPropertyChangeListener(e -> this.changeGrouping());
        ChangesGroupingSupport changesGroupingSupport = result2;
        if (changesGroupingSupport == null) {
            ChangesTree.$$$reportNull$$$0(4);
        }
        return changesGroupingSupport;
    }

    private void migrateShowFlattenSetting() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        if (properties.isValueSet(FLATTEN_OPTION_KEY)) {
            properties.setValues(GROUPING_KEYS, properties.isTrueValue(FLATTEN_OPTION_KEY) ? ArrayUtilRt.EMPTY_STRING_ARRAY : DEFAULT_GROUPING_KEYS);
            properties.unsetValue(FLATTEN_OPTION_KEY);
        }
    }

    public void setEmptyText(@NotNull String emptyText) {
        if (emptyText == null) {
            ChangesTree.$$$reportNull$$$0(5);
        }
        this.getEmptyText().setText(emptyText);
    }

    public void addSelectionListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            ChangesTree.$$$reportNull$$$0(6);
        }
        this.addSelectionListener(runnable, null);
    }

    public void addSelectionListener(final @NotNull Runnable runnable, @Nullable Disposable parent) {
        if (runnable == null) {
            ChangesTree.$$$reportNull$$$0(7);
        }
        TreeSelectionListener listener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                runnable.run();
            }
        };
        this.addTreeSelectionListener(listener);
        if (parent != null) {
            Disposer.register((Disposable)parent, () -> this.removeTreeSelectionListener(listener));
        }
    }

    public void setDoubleClickHandler(@NotNull Runnable doubleClickHandler) {
        if (doubleClickHandler == null) {
            ChangesTree.$$$reportNull$$$0(8);
        }
        this.myDoubleClickHandler = doubleClickHandler;
    }

    public void installPopupHandler(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)this), (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    public JComponent getPreferredFocusedComponent() {
        return this;
    }

    public void addGroupingChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ChangesTree.$$$reportNull$$$0(9);
        }
        this.myGroupingSupport.addPropertyChangeListener(listener);
    }

    public void removeGroupingChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ChangesTree.$$$reportNull$$$0(10);
        }
        this.myGroupingSupport.removePropertyChangeListener(listener);
    }

    @NotNull
    public ChangesGroupingSupport getGroupingSupport() {
        ChangesGroupingSupport changesGroupingSupport = this.myGroupingSupport;
        if (changesGroupingSupport == null) {
            ChangesTree.$$$reportNull$$$0(11);
        }
        return changesGroupingSupport;
    }

    @NotNull
    public ChangesGroupingPolicyFactory getGrouping() {
        ChangesGroupingPolicyFactory changesGroupingPolicyFactory = this.getGroupingSupport().getGrouping();
        if (changesGroupingPolicyFactory == null) {
            ChangesTree.$$$reportNull$$$0(12);
        }
        return changesGroupingPolicyFactory;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ChangesTree.$$$reportNull$$$0(13);
        }
        return project;
    }

    public boolean isShowFlatten() {
        return !this.myGroupingSupport.isDirectory();
    }

    public boolean isShowCheckboxes() {
        return this.myShowCheckboxes;
    }

    public void setShowCheckboxes(boolean value) {
        boolean oldValue = this.myShowCheckboxes;
        this.myShowCheckboxes = value;
        if (oldValue != value) {
            this.showCheckboxesChanged();
        }
    }

    private void showCheckboxesChanged() {
        if (this.isShowCheckboxes()) {
            this.myCheckBoxClickHandler = this.installCheckBoxClickHandler();
        } else if (this.myCheckBoxClickHandler != null) {
            this.myCheckBoxClickHandler.uninstall((Component)((Object)this));
            this.myCheckBoxClickHandler = null;
        }
        TreeCellRenderer renderer = this.getCellRenderer();
        if (renderer instanceof ChangesTreeCellRenderer) {
            ((ChangesTreeCellRenderer)renderer).updateLayout(this.isShowCheckboxes());
        }
        this.repaint();
    }

    private void changeGrouping() {
        PropertiesComponent.getInstance((Project)this.myProject).setValues(GROUPING_KEYS, ArrayUtilRt.toStringArray(this.getGroupingSupport().getGroupingKeys()));
        List<Object> oldSelection = VcsTreeModelData.selected((JTree)((Object)this)).userObjects();
        this.rebuildTree();
        this.setSelectedChanges(oldSelection);
    }

    private boolean isCurrentModelFlat() {
        boolean isFlat = true;
        Enumeration<TreeNode> enumeration = this.getRoot().depthFirstEnumeration();
        while (isFlat && enumeration.hasMoreElements()) {
            isFlat = ((ChangesBrowserNode)enumeration.nextElement()).getLevel() <= 1;
        }
        return isFlat;
    }

    public abstract void rebuildTree();

    protected void updateTreeModel(@NotNull DefaultTreeModel model) {
        if (model == null) {
            ChangesTree.$$$reportNull$$$0(14);
        }
        this.myModelUpdateInProgress = true;
        try {
            ApplicationManager.getApplication().assertIsDispatchThread();
            TreeState state = null;
            if (this.myKeepTreeState) {
                state = TreeState.createOn((JTree)((Object)this), this.getRoot());
            }
            this.setModel(model);
            this.myIsModelFlat = this.isCurrentModelFlat();
            this.setShowsRootHandles(!this.myGroupingSupport.isNone() || !this.myIsModelFlat);
            if (this.myKeepTreeState) {
                state.applyTo((JTree)((Object)this), this.getRoot());
            } else {
                this.resetTreeState();
            }
        }
        finally {
            this.myModelUpdateInProgress = false;
        }
    }

    public boolean isModelUpdateInProgress() {
        return this.myModelUpdateInProgress;
    }

    protected void resetTreeState() {
        if (ChangesTree.hasAtLeastNodes(this, 30000)) {
            TreeUtil.collapseAll((JTree)((Object)this), (int)1);
            return;
        }
        TreeUtil.expandAll((JTree)((Object)this));
        int selectedTreeRow = -1;
        if (this.myShowCheckboxes && !this.getIncludedSet().isEmpty()) {
            ChangesBrowserNode node;
            ChangesBrowserNode<?> root = this.getRoot();
            Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (node == root || this.getNodeStatus(node) != ThreeStateCheckBox.State.NOT_SELECTED) continue;
                this.collapsePath(new TreePath(node.getPath()));
            }
            enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (!node.isLeaf() || this.getNodeStatus(node) != ThreeStateCheckBox.State.SELECTED) continue;
                selectedTreeRow = this.getRowForPath(new TreePath(node.getPath()));
                break;
            }
        }
        if (selectedTreeRow >= 0) {
            this.setSelectionRow(selectedTreeRow);
        }
        TreeUtil.showRowCentered((JTree)((Object)this), (int)selectedTreeRow, (boolean)false);
    }

    private static boolean hasAtLeastNodes(@NotNull Tree tree, int nodeNumber) {
        if (tree == null) {
            ChangesTree.$$$reportNull$$$0(15);
        }
        return TreeUtil.treeTraverser((JTree)tree).traverse().take(nodeNumber).size() >= nodeNumber;
    }

    public void selectFile(@Nullable VirtualFile toSelect) {
        if (toSelect == null) {
            return;
        }
        this.selectFile(VcsUtil.getFilePath((VirtualFile)toSelect));
    }

    public void selectFile(@Nullable FilePath toSelect) {
        if (toSelect == null) {
            return;
        }
        int rowInTree = this.findRowContainingFile(this.getRoot(), toSelect);
        if (rowInTree == -1) {
            return;
        }
        this.setSelectionRow(rowInTree);
        TreeUtil.showRowCentered((JTree)((Object)this), (int)rowInTree, (boolean)false);
    }

    private int findRowContainingFile(@NotNull TreeNode root, @NotNull FilePath toSelect) {
        if (root == null) {
            ChangesTree.$$$reportNull$$$0(16);
        }
        if (toSelect == null) {
            ChangesTree.$$$reportNull$$$0(17);
        }
        Ref row2 = Ref.create((Object)-1);
        TreeUtil.traverse((TreeNode)root, node -> {
            Object userObject;
            if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Change && ChangesTree.matches((Change)userObject, toSelect)) {
                Object[] path = ((DefaultMutableTreeNode)node).getPath();
                row2.set((Object)this.getRowForPath(new TreePath(path)));
            }
            return (Integer)row2.get() == -1;
        });
        return (Integer)row2.get();
    }

    private static boolean matches(@NotNull Change change, @NotNull FilePath toSelect) {
        if (change == null) {
            ChangesTree.$$$reportNull$$$0(18);
        }
        if (toSelect == null) {
            ChangesTree.$$$reportNull$$$0(19);
        }
        return toSelect.equals(ChangesUtil.getAfterPath((Change)change));
    }

    @NotNull
    ChangesBrowserNode<?> getRoot() {
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)this.getModel().getRoot();
        if (changesBrowserNode == null) {
            ChangesTree.$$$reportNull$$$0(20);
        }
        return changesBrowserNode;
    }

    @NotNull
    public InclusionModel getInclusionModel() {
        InclusionModel inclusionModel = this.myInclusionModel;
        if (inclusionModel == null) {
            ChangesTree.$$$reportNull$$$0(21);
        }
        return inclusionModel;
    }

    public void setInclusionModel(@Nullable InclusionModel inclusionModel) {
        this.myInclusionModel.removeInclusionListener(this.myInclusionModelListener);
        this.myInclusionModel = inclusionModel != null ? inclusionModel : NullInclusionModel.INSTANCE;
        this.myInclusionModel.addInclusionListener(this.myInclusionModelListener);
    }

    public void setInclusionListener(@Nullable Runnable runnable) {
        this.myTreeInclusionListener = runnable;
    }

    private void notifyInclusionListener() {
        if (this.myTreeInclusionListener != null) {
            this.myTreeInclusionListener.run();
        }
    }

    public void setIncludedChanges(@NotNull Collection<?> changes2) {
        if (changes2 == null) {
            ChangesTree.$$$reportNull$$$0(22);
        }
        this.getInclusionModel().setInclusion(changes2);
    }

    public void includeChange(@NotNull Object change) {
        if (change == null) {
            ChangesTree.$$$reportNull$$$0(23);
        }
        this.includeChanges(Collections.singleton(change));
    }

    public void includeChanges(@NotNull Collection<?> changes2) {
        if (changes2 == null) {
            ChangesTree.$$$reportNull$$$0(24);
        }
        this.getInclusionModel().addInclusion(changes2);
    }

    public void excludeChange(@NotNull Object change) {
        if (change == null) {
            ChangesTree.$$$reportNull$$$0(25);
        }
        this.excludeChanges(Collections.singleton(change));
    }

    public void excludeChanges(@NotNull Collection<?> changes2) {
        if (changes2 == null) {
            ChangesTree.$$$reportNull$$$0(26);
        }
        this.getInclusionModel().removeInclusion(changes2);
    }

    protected void toggleChanges(@NotNull Collection<?> changes2) {
        if (changes2 == null) {
            ChangesTree.$$$reportNull$$$0(27);
        }
        boolean hasExcluded = false;
        for (Object item : changes2) {
            if (this.getInclusionModel().getInclusionState(item) == ThreeStateCheckBox.State.SELECTED) continue;
            hasExcluded = true;
            break;
        }
        if (hasExcluded) {
            this.includeChanges(changes2);
        } else {
            this.excludeChanges(changes2);
        }
    }

    public boolean isIncluded(@NotNull Object change) {
        if (change == null) {
            ChangesTree.$$$reportNull$$$0(28);
        }
        return this.getInclusionModel().getInclusionState(change) != ThreeStateCheckBox.State.NOT_SELECTED;
    }

    @NotNull
    public Set<Object> getIncludedSet() {
        Set set = this.getInclusionModel().getInclusion();
        if (set == null) {
            ChangesTree.$$$reportNull$$$0(29);
        }
        return set;
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public void setTreeExpander(@NotNull TreeExpander expander) {
        if (expander == null) {
            ChangesTree.$$$reportNull$$$0(30);
        }
        this.myTreeExpander = expander;
    }

    @Deprecated
    public AnAction[] getTreeActions() {
        return new AnAction[]{ActionManager.getInstance().getAction(GROUP_BY_ACTION_GROUP), this.createExpandAllAction(false), this.createCollapseAllAction(false)};
    }

    @NotNull
    public AnAction createExpandAllAction(boolean headerAction) {
        if (headerAction) {
            AnAction anAction = CommonActionsManager.getInstance().createExpandAllHeaderAction(this.myTreeExpander, (JComponent)((Object)this));
            if (anAction == null) {
                ChangesTree.$$$reportNull$$$0(31);
            }
            return anAction;
        }
        AnAction anAction = CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this));
        if (anAction == null) {
            ChangesTree.$$$reportNull$$$0(32);
        }
        return anAction;
    }

    @NotNull
    public AnAction createCollapseAllAction(boolean headerAction) {
        if (headerAction) {
            AnAction anAction = CommonActionsManager.getInstance().createCollapseAllHeaderAction(this.myTreeExpander, (JComponent)((Object)this));
            if (anAction == null) {
                ChangesTree.$$$reportNull$$$0(33);
            }
            return anAction;
        }
        AnAction anAction = CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this));
        if (anAction == null) {
            ChangesTree.$$$reportNull$$$0(34);
        }
        return anAction;
    }

    public void setSelectionMode(@JdkConstants.TreeSelectionMode int mode) {
        this.getSelectionModel().setSelectionMode(mode);
    }

    @NotNull
    ThreeStateCheckBox.State getNodeStatus(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesTree.$$$reportNull$$$0(35);
        }
        boolean hasIncluded = false;
        boolean hasExcluded = false;
        for (Object item : VcsTreeModelData.children(node).userObjects()) {
            ThreeStateCheckBox.State state = this.getInclusionModel().getInclusionState(item);
            if (state == ThreeStateCheckBox.State.SELECTED) {
                hasIncluded = true;
                continue;
            }
            if (state == ThreeStateCheckBox.State.NOT_SELECTED) {
                hasExcluded = true;
                continue;
            }
            hasIncluded = true;
            hasExcluded = true;
        }
        if (hasIncluded && hasExcluded) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.DONT_CARE;
            if (state == null) {
                ChangesTree.$$$reportNull$$$0(36);
            }
            return state;
        }
        if (hasIncluded) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.SELECTED;
            if (state == null) {
                ChangesTree.$$$reportNull$$$0(37);
            }
            return state;
        }
        ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
        if (state == null) {
            ChangesTree.$$$reportNull$$$0(38);
        }
        return state;
    }

    protected boolean isInclusionEnabled(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesTree.$$$reportNull$$$0(39);
        }
        return true;
    }

    protected boolean isInclusionVisible(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesTree.$$$reportNull$$$0(40);
        }
        return true;
    }

    private boolean isIncludable(@NotNull TreePath path) {
        Object lastComponent;
        if (path == null) {
            ChangesTree.$$$reportNull$$$0(41);
        }
        if (!((lastComponent = path.getLastPathComponent()) instanceof ChangesBrowserNode)) {
            return false;
        }
        return this.isIncludable((ChangesBrowserNode)lastComponent);
    }

    private boolean isIncludable(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesTree.$$$reportNull$$$0(42);
        }
        return this.isInclusionVisible(node) && this.isInclusionEnabled(node);
    }

    @NotNull
    private List<Object> getIncludableUserObjects(@NotNull VcsTreeModelData treeModelData) {
        if (treeModelData == null) {
            ChangesTree.$$$reportNull$$$0(43);
        }
        List<Object> list = treeModelData.nodesStream().filter(node -> this.isIncludable((ChangesBrowserNode<?>)node)).map(node -> node.getUserObject()).collect(Collectors.toList());
        if (list == null) {
            ChangesTree.$$$reportNull$$$0(44);
        }
        return list;
    }

    public void setSelectedChanges(@NotNull Collection<?> changes2) {
        if (changes2 == null) {
            ChangesTree.$$$reportNull$$$0(45);
        }
        HashSet changesSet = new HashSet(changes2);
        ArrayList treeSelection = new ArrayList(changes2.size());
        TreeUtil.traverse(this.getRoot(), node -> {
            DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)node;
            if (changesSet.contains(mutableNode.getUserObject())) {
                treeSelection.add(new TreePath(mutableNode.getPath()));
            }
            return true;
        });
        this.setSelectionPaths(TreePathUtil.toTreePathArray(treeSelection));
        if (treeSelection.size() == 1) {
            this.scrollPathToVisible((TreePath)treeSelection.get(0));
        }
    }

    public void setKeepTreeState(boolean keepTreeState) {
        this.myKeepTreeState = keepTreeState;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ChangesTree.$$$reportNull$$$0(46);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myTreeCopyProvider;
        }
        if (ChangesGroupingSupport.KEY.is(dataId)) {
            return this.myGroupingSupport;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.myTreeExpander;
        }
        return null;
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public Color getFileColorFor(Object object) {
        VirtualFile file = object instanceof FilePath ? ChangesTree.getVirtualFileFor((FilePath)object) : (object instanceof Change ? ChangesTree.getVirtualFileFor(ChangesUtil.getFilePath((Change)((Change)object))) : (VirtualFile)ObjectUtils.tryCast((Object)object, VirtualFile.class));
        if (file != null) {
            return VfsPresentationUtil.getFileBackgroundColor((Project)this.myProject, (VirtualFile)file);
        }
        return super.getFileColorFor(object);
    }

    @Nullable
    private static VirtualFile getVirtualFileFor(@NotNull FilePath filePath) {
        if (filePath == null) {
            ChangesTree.$$$reportNull$$$0(47);
        }
        if (filePath.isNonLocal()) {
            return null;
        }
        return ChangesUtil.findValidParentAccurately((FilePath)filePath);
    }

    public int getToggleClickCount() {
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRenderer";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesTree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubleClickHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 18: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expander";
                break;
            }
            case 35: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModelData";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "installGroupingSupport";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupingSupport";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrouping";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInclusionModel";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedSet";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandAllAction";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapseAllAction";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeStatus";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludableUserObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathIfCheckBoxClicked";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installTreeLinkHandler";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDoubleClickHandler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addGroupingChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeGroupingChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateTreeModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasAtLeastNodes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findRowContainingFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setIncludedChanges";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "includeChange";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "includeChanges";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "excludeChange";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "excludeChanges";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toggleChanges";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isIncluded";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setTreeExpander";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNodeStatus";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isInclusionEnabled";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isInclusionVisible";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isIncludable";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getIncludableUserObjects";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedChanges";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFileFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyToggleSelectionAction
    extends AnAction
    implements DumbAware {
        private MyToggleSelectionAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleSelectionAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(ChangesTree.this.isShowCheckboxes());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List changes2;
            if (e == null) {
                MyToggleSelectionAction.$$$reportNull$$$0(1);
            }
            if (!(changes2 = ChangesTree.this.getIncludableUserObjects(!ChangesTree.this.isSelectionEmpty() ? VcsTreeModelData.selected((JTree)((Object)ChangesTree.this)) : VcsTreeModelData.all((JTree)((Object)ChangesTree.this)))).isEmpty()) {
                ChangesTree.this.toggleChanges(changes2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$MyToggleSelectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyTreeExpander
    extends DefaultTreeExpander {
        MyTreeExpander() {
            super((JTree)((Object)ChangesTree.this));
        }

        public boolean isVisible(@NotNull AnActionEvent event) {
            if (event == null) {
                MyTreeExpander.$$$reportNull$$$0(0);
            }
            return !ChangesTree.this.myGroupingSupport.isNone() || !ChangesTree.this.myIsModelFlat;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/ui/ChangesTree$MyTreeExpander", "isVisible"));
        }
    }
}

