/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.validators.GitNewBranchNameValidator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUtil {
    private static final Logger LOG = Logger.getInstance(GitBranchUtil.class);
    private static final String NO_BRANCH_NAME = "(no branch)";

    private GitBranchUtil() {
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch branch) {
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(0);
        }
        if (branch == null) {
            GitBranchUtil.$$$reportNull$$$0(1);
        }
        return GitBranchUtil.getTrackInfo(repository, branch.getName());
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfo(@NotNull GitRepository repository, @NotNull String localBranchName) {
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(2);
        }
        if (localBranchName == null) {
            GitBranchUtil.$$$reportNull$$$0(3);
        }
        return repository.getBranchTrackInfo(localBranchName);
    }

    @NotNull
    static String getCurrentBranchOrRev(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(4);
        }
        if (repositories.size() > 1) {
            GitMultiRootBranchConfig multiRootBranchConfig = new GitMultiRootBranchConfig(repositories);
            String currentBranch = multiRootBranchConfig.getCurrentBranch();
            LOG.assertTrue(currentBranch != null, (Object)("Repositories have unexpectedly diverged. " + (Object)((Object)multiRootBranchConfig)));
            String string = currentBranch;
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        assert (!repositories.isEmpty()) : "No repositories passed to GitBranchOperationsProcessor.";
        GitRepository repository = repositories.iterator().next();
        String string = GitBranchUtil.getBranchNameOrRev(repository);
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static Collection<String> convertBranchesToNames(@NotNull Collection<? extends GitBranch> branches2) {
        if (branches2 == null) {
            GitBranchUtil.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.map(branches2, GitReference::getName);
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Deprecated
    @Nullable
    public static GitLocalBranch getCurrentBranch(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepository repository;
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(9);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(10);
        }
        if ((repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root)) != null) {
            return repository.getCurrentBranch();
        }
        LOG.info("getCurrentBranch: Repository is null for root " + root);
        return GitBranchUtil.getCurrentBranchFromGit(project, root);
    }

    @Nullable
    private static GitLocalBranch getCurrentBranchFromGit(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(12);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REV_PARSE);
        handler.addParameters("--abbrev-ref", "HEAD");
        handler.setSilent(true);
        try {
            String name = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
            if (!name.equals("HEAD")) {
                return new GitLocalBranch(name);
            }
            return null;
        }
        catch (VcsException e) {
            LOG.info("git rev-parse --abbrev-ref HEAD", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static List<String> getAllTags(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(13);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(14);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.TAG);
        h.addParameters("-l");
        h.setSilent(true);
        final ArrayList<String> tags = new ArrayList<String>();
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                if (line.length() != 0) {
                    tags.add(line);
                }
            }
        });
        GitCommandResult result2 = Git.getInstance().runCommandWithoutCollectingOutput(h);
        result2.throwOnError(new int[0]);
        ArrayList<String> arrayList = tags;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private static String trackedBranchKey(String branchName) {
        String string = "branch." + branchName + ".merge";
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String trackedRemoteKey(String branchName) {
        String string = "branch." + branchName + ".remote";
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public static GitRemoteBranch tracked(@NotNull Project project, @NotNull VirtualFile root, @NotNull String branchName) throws VcsException {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(18);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(19);
        }
        if (branchName == null) {
            GitBranchUtil.$$$reportNull$$$0(20);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        GitConfigUtil.getValues(project, root, null, result2);
        String remoteName = result2.get(GitBranchUtil.trackedRemoteKey(branchName));
        if (remoteName == null) {
            return null;
        }
        String branch = result2.get(GitBranchUtil.trackedBranchKey(branchName));
        if (branch == null) {
            return null;
        }
        if (".".equals(remoteName)) {
            return new GitSvnRemoteBranch(branch);
        }
        GitRemote remote = GitBranchUtil.findRemoteByNameOrLogError(project, root, remoteName);
        if (remote == null) {
            return null;
        }
        return new GitStandardRemoteBranch(remote, branch);
    }

    @Deprecated
    @Nullable
    public static GitRemote findRemoteByNameOrLogError(@NotNull Project project, @NotNull VirtualFile root, @NotNull String remoteName) {
        GitRepository repository;
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(21);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(22);
        }
        if (remoteName == null) {
            GitBranchUtil.$$$reportNull$$$0(23);
        }
        if ((repository = GitUtil.getRepositoryForRootOrLogError(project, root)) == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteName);
        if (remote == null) {
            LOG.warn("Couldn't find remote with name " + remoteName);
            return null;
        }
        return remote;
    }

    @NotNull
    public static Collection<String> getBranchNamesWithoutRemoteHead(@NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        if (remoteBranches == null) {
            GitBranchUtil.$$$reportNull$$$0(24);
        }
        List list = ContainerUtil.filter(GitBranchUtil.convertBranchesToNames(remoteBranches), input -> !input.equals("HEAD"));
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public static String stripRefsPrefix(@NotNull String branchName) {
        if (branchName == null) {
            GitBranchUtil.$$$reportNull$$$0(26);
        }
        if (branchName.startsWith("refs/heads/")) {
            String string = branchName.substring("refs/heads/".length());
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        if (branchName.startsWith("refs/remotes/")) {
            String string = branchName.substring("refs/remotes/".length());
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        if (branchName.startsWith("refs/tags/")) {
            String string = branchName.substring("refs/tags/".length());
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = branchName;
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static String getBranchNameOrRev(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(31);
        }
        if (repository.isOnBranch()) {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            String string = currentBranch.getName();
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        String currentRevision = repository.getCurrentRevision();
        String string = currentRevision != null ? currentRevision.substring(0, 7) : "";
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    public static GitNewBranchOptions getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String dialogTitle, @Nullable String initialName) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(34);
        }
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(35);
        }
        if (dialogTitle == null) {
            GitBranchUtil.$$$reportNull$$$0(36);
        }
        return new GitNewBranchDialog(project, dialogTitle, initialName, GitNewBranchNameValidator.newInstance(repositories)).showAndGetOptions();
    }

    @NotNull
    public static String getDisplayableBranchText(@NotNull GitRepository repository) {
        Repository.State state;
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(37);
        }
        if ((state = repository.getState()) == Repository.State.DETACHED) {
            String currentRevision = repository.getCurrentRevision();
            assert (currentRevision != null) : "Current revision can't be null in DETACHED state, only on the fresh repository.";
            String string = DvcsUtil.getShortHash((String)currentRevision);
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(38);
            }
            return string;
        }
        String prefix = "";
        if (state == Repository.State.MERGING || state == Repository.State.REBASING) {
            prefix = state.toString() + " ";
        } else if (state == Repository.State.GRAFTING) {
            prefix = "Cherry-picking in ";
        }
        GitLocalBranch branch = repository.getCurrentBranch();
        String branchName = branch == null ? "" : branch.getName();
        String string = prefix + branchName;
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    public static GitRepository getCurrentRepository(@NotNull Project project) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(40);
        }
        return GitBranchUtil.getRepositoryOrGuess(project, DvcsUtil.getSelectedFile((Project)project));
    }

    @Nullable
    public static GitRepository getRepositoryOrGuess(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(41);
        }
        if (project.isDisposed()) {
            return null;
        }
        return (GitRepository)DvcsUtil.guessRepositoryForFile((Project)project, (RepositoryManager)GitUtil.getRepositoryManager(project), (VirtualFile)file, (String)GitVcsSettings.getInstance(project).getRecentRootPath());
    }

    @NotNull
    public static Collection<String> getCommonBranches(Collection<? extends GitRepository> repositories, boolean local) {
        Collection<String> names = local ? GitBranchUtil.convertBranchesToNames(GitBranchUtil.getCommonLocalBranches(repositories)) : GitBranchUtil.getBranchNamesWithoutRemoteHead(GitBranchUtil.getCommonRemoteBranches(repositories));
        List list = ((StreamEx)StreamEx.of(names).sorted(StringUtil::naturalCompare)).toList();
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    public static List<GitLocalBranch> getCommonLocalBranches(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(43);
        }
        List<GitLocalBranch> list = GitBranchUtil.collectCommon(repositories.stream().map(repository -> repository.getBranches().getLocalBranches()));
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public static List<GitRemoteBranch> getCommonRemoteBranches(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(45);
        }
        List<GitRemoteBranch> list = GitBranchUtil.collectCommon(repositories.stream().map(repository -> repository.getBranches().getRemoteBranches()));
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(46);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> collectCommon(@NotNull Stream<? extends Collection<T>> groups) {
        if (groups == null) {
            GitBranchUtil.$$$reportNull$$$0(47);
        }
        List<T> list = GitBranchUtil.collectCommon(groups, ContainerUtil.canonicalStrategy());
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> collectCommon(@NotNull Stream<? extends Collection<T>> groups, @NotNull TObjectHashingStrategy<? super T> hashingStrategy) {
        if (groups == null) {
            GitBranchUtil.$$$reportNull$$$0(49);
        }
        if (hashingStrategy == null) {
            GitBranchUtil.$$$reportNull$$$0(50);
        }
        ArrayList common = new ArrayList();
        boolean[] firstGroup = new boolean[]{true};
        groups.forEach(values -> {
            if (firstGroup[0]) {
                firstGroup[0] = false;
                common.addAll(values);
            } else {
                common.retainAll((Collection<?>)new THashSet(values, hashingStrategy));
            }
        });
        ArrayList arrayList = common;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    @NotNull
    public static <T extends GitReference> List<T> sortBranchesByName(@NotNull Collection<? extends T> branches2) {
        if (branches2 == null) {
            GitBranchUtil.$$$reportNull$$$0(52);
        }
        List list = branches2.stream().sorted(Comparator.comparing(GitReference::getFullName, NaturalComparator.INSTANCE)).collect(Collectors.toList());
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(53);
        }
        return list;
    }

    @NotNull
    public static Collection<String> getBranches(@NotNull Project project, @NotNull VirtualFile root, boolean localWanted, boolean remoteWanted, @Nullable String containingCommit) throws VcsException {
        String[] split;
        String output;
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(54);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(55);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.BRANCH);
        handler.setSilent(true);
        handler.addParameters("--no-color");
        boolean remoteOnly = false;
        if (remoteWanted && localWanted) {
            handler.addParameters("-a");
            remoteOnly = false;
        } else if (remoteWanted) {
            handler.addParameters("-r");
            remoteOnly = true;
        }
        if (containingCommit != null) {
            handler.addParameters("--contains", containingCommit);
        }
        if ((output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0])).trim().length() == 0) {
            List<String> list;
            try {
                File headFile = ((GitRepository)ObjectUtils.assertNotNull((Object)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root))).getRepositoryFiles().getHeadFile();
                String head = FileUtil.loadFile((File)headFile, (Charset)StandardCharsets.UTF_8).trim();
                String prefix = "ref: refs/heads/";
                list = head.startsWith("ref: refs/heads/") ? Collections.singletonList(head.substring("ref: refs/heads/".length())) : Collections.emptyList();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    GitBranchUtil.$$$reportNull$$$0(57);
                }
                return list2;
            }
            if (list == null) {
                GitBranchUtil.$$$reportNull$$$0(56);
            }
            return list;
        }
        ArrayList<String> branches2 = new ArrayList<String>();
        for (String b : split = output.split("\n")) {
            boolean isRemote;
            if ((b = b.substring(2).trim()).equals(NO_BRANCH_NAME)) continue;
            String remotePrefix = null;
            if (b.startsWith("remotes/")) {
                remotePrefix = "remotes/";
            } else if (b.startsWith("refs/remotes/")) {
                remotePrefix = "refs/remotes/";
            }
            boolean bl = isRemote = remotePrefix != null || remoteOnly;
            if (isRemote) {
                int idx;
                if (!remoteOnly) {
                    b = b.substring(remotePrefix.length());
                }
                if ((idx = b.indexOf("HEAD ->")) > 0) continue;
            }
            branches2.add(b);
        }
        ArrayList<String> arrayList = branches2;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(58);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 56: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 56: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 4: 
            case 35: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 56: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchUtil";
                break;
            }
            case 7: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 34: 
            case 40: 
            case 41: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchOrRev";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertBranchesToNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTags";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "trackedBranchKey";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "trackedRemoteKey";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNamesWithoutRemoteHead";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "stripRefsPrefix";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNameOrRev";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayableBranchText";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonBranches";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonLocalBranches";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonRemoteBranches";
                break;
            }
            case 48: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommon";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "sortBranchesByName";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfoForBranch";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchOrRev";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 56: 
            case 57: 
            case 58: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertBranchesToNames";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranch";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchFromGit";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllTags";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tracked";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteByNameOrLogError";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNamesWithoutRemoteHead";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "stripRefsPrefix";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNameOrRev";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getNewBranchNameFromUser";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayableBranchText";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRepository";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryOrGuess";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getCommonLocalBranches";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getCommonRemoteBranches";
                break;
            }
            case 47: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "collectCommon";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sortBranchesByName";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 56: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

