/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopiesHolder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnCompatibilityChecker;
import org.jetbrains.idea.svn.SvnCopyRootSimple;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnMapping;
import org.jetbrains.idea.svn.SvnMappingSavedPart;
import org.jetbrains.idea.svn.SvnRootsDetector;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.UniqueRootsFilter;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;

@State(name="SvnFileUrlMappingImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SvnFileUrlMappingImpl
implements SvnFileUrlMapping,
PersistentStateComponent<SvnMappingSavedPart> {
    private static final Logger LOG = Logger.getInstance(SvnFileUrlMappingImpl.class);
    @NotNull
    private final SvnCompatibilityChecker myChecker;
    @NotNull
    private final Object myMonitor;
    @NotNull
    private final SvnMapping myMapping;
    @NotNull
    private final SvnMapping myMoreRealMapping;
    @NotNull
    private final List<RootUrlInfo> myErrorRoots;
    @NotNull
    private final MyRootsHelper myRootsHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final NestedCopiesHolder myNestedCopiesHolder;
    private boolean myInitialized;
    private boolean myInitedReloaded;

    @NotNull
    public static SvnFileUrlMappingImpl getInstance(@NotNull Project project) {
        if (project == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(0);
        }
        SvnFileUrlMappingImpl svnFileUrlMappingImpl = (SvnFileUrlMappingImpl)ServiceManager.getService((Project)project, SvnFileUrlMapping.class);
        if (svnFileUrlMappingImpl == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(1);
        }
        return svnFileUrlMappingImpl;
    }

    private SvnFileUrlMappingImpl(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(2);
        }
        if (vcsManager == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(3);
        }
        this.myMonitor = new Object();
        this.myMapping = new SvnMapping();
        this.myMoreRealMapping = new SvnMapping();
        this.myErrorRoots = new ArrayList<RootUrlInfo>();
        this.myNestedCopiesHolder = new NestedCopiesHolder();
        this.myProject = project;
        this.myRootsHelper = new MyRootsHelper(project, vcsManager);
        this.myChecker = new SvnCompatibilityChecker(project);
    }

    @Override
    @Nullable
    public Url getUrlForFile(@NotNull File file) {
        if (file == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(4);
        }
        Url result = null;
        RootUrlInfo rootUrlInfo = this.getWcRootForFilePath(VcsUtil.getFilePath((File)file));
        if (rootUrlInfo != null) {
            try {
                result = SvnUtil.append(rootUrlInfo.getUrl(), SvnUtil.getRelativePath(rootUrlInfo.getPath(), file.getAbsolutePath()));
            }
            catch (SvnBindException e) {
                LOG.info((Throwable)((Object)e));
            }
        }
        return result;
    }

    @Override
    @Nullable
    public File getLocalPath(@NotNull Url url) {
        RootUrlInfo parentInfo;
        if (url == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(5);
        }
        return (parentInfo = this.getWcRootForUrl(url)) != null ? new File(parentInfo.getIoFile(), SvnUtil.getRelativeUrl(parentInfo.getUrl(), url)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForFilePath(@NotNull FilePath path) {
        if (path == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(6);
        }
        Object object = this.myMonitor;
        synchronized (object) {
            String root = this.myMoreRealMapping.getRootForPath(FileUtil.toSystemDependentName((String)path.toString()));
            return root != null ? this.myMoreRealMapping.byFile(root) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForUrl(@NotNull Url url) {
        if (url == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(7);
        }
        Object object = this.myMonitor;
        synchronized (object) {
            RootUrlInfo result = null;
            Url rootUrl = (Url)ContainerUtil.find(this.myMoreRealMapping.getUrls(), parentRootUrl -> SvnUtil.isAncestor(parentRootUrl, url));
            if (rootUrl != null && (result = this.myMoreRealMapping.byUrl(rootUrl)) == null) {
                LOG.info("Inconsistent maps for url:" + url + " found root url: " + rootUrl);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<RootUrlInfo> getAllWcInfos() {
        Object object = this.myMonitor;
        // MONITORENTER : object
        List<RootUrlInfo> list = this.myMoreRealMapping.getAllCopies();
        // MONITOREXIT : object
        if (list != null) return list;
        SvnFileUrlMappingImpl.$$$reportNull$$$0(8);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<RootUrlInfo> getErrorRoots() {
        Object object = this.myMonitor;
        // MONITORENTER : object
        ArrayList<RootUrlInfo> arrayList = new ArrayList<RootUrlInfo>(this.myErrorRoots);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        SvnFileUrlMappingImpl.$$$reportNull$$$0(9);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> result) {
        if (result == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(10);
        }
        if (MyRootsHelper.isInProgress()) {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(result);
            if (arrayList != null) return arrayList;
            SvnFileUrlMappingImpl.$$$reportNull$$$0(11);
            return arrayList;
        }
        Object object = this.myMonitor;
        // MONITORENTER : object
        List<VirtualFile> cachedRoots = this.myMoreRealMapping.getUnderVcsRoots();
        List<VirtualFile> lonelyRoots = this.myMoreRealMapping.getLonelyRoots();
        if (!lonelyRoots.isEmpty()) {
            this.myChecker.reportNoRoots(lonelyRoots);
        }
        List<VirtualFile> iterable = cachedRoots.isEmpty() ? result : cachedRoots;
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(iterable);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        SvnFileUrlMappingImpl.$$$reportNull$$$0(12);
        return arrayList;
    }

    public void acceptNestedData(@NotNull Set<NestedCopyInfo> set) {
        if (set == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(13);
        }
        this.myNestedCopiesHolder.add(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean init() {
        Object object = this.myMonitor;
        synchronized (object) {
            boolean result = this.myInitialized;
            this.myInitialized = true;
            return result;
        }
    }

    public void realRefresh(Runnable afterRefreshCallback) {
        if (this.myProject.isDisposed()) {
            afterRefreshCallback.run();
        } else {
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            VirtualFile[] roots = this.myRootsHelper.execute();
            SvnRootsDetector rootsDetector = new SvnRootsDetector(vcs, this, this.myNestedCopiesHolder);
            rootsDetector.detectCopyRoots(roots, this.init(), afterRefreshCallback);
        }
    }

    public void applyDetectionResult(@NotNull SvnRootsDetector.Result result) {
        if (result == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(14);
        }
        new NewRootsApplier(result).apply();
    }

    @Override
    @NotNull
    public VirtualFile[] getNotFilteredRoots() {
        VirtualFile[] virtualFileArray = this.myRootsHelper.execute();
        if (virtualFileArray == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(15);
        }
        return virtualFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMapping.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnMappingSavedPart getState() {
        SvnMappingSavedPart result = new SvnMappingSavedPart();
        SvnMapping mapping = new SvnMapping();
        SvnMapping realMapping = new SvnMapping();
        Object object = this.myMonitor;
        synchronized (object) {
            mapping.copyFrom(this.myMapping);
            realMapping.copyFrom(this.myMoreRealMapping);
        }
        mapping.getAllCopies().forEach(result::add);
        realMapping.getAllCopies().forEach(result::addReal);
        return result;
    }

    public void loadState(@NotNull SvnMappingSavedPart state) {
        if (state == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(16);
        }
        ((ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject)).addInitializationRequest(VcsInitObject.AFTER_COMMON, (Runnable)((DumbAwareRunnable)() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            SvnMapping mapping = new SvnMapping();
            SvnMapping realMapping = new SvnMapping();
            try {
                this.fillMapping(mapping, state.getMappingRoots());
                this.fillMapping(realMapping, state.getMoreRealMappingRoots());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.info(t);
                return;
            }
            Object object = this.myMonitor;
            synchronized (object) {
                this.myMapping.copyFrom(mapping);
                this.myMoreRealMapping.copyFrom(realMapping);
            }
        })));
    }

    private void fillMapping(@NotNull SvnMapping mapping, @NotNull List<SvnCopyRootSimple> list) {
        if (mapping == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(17);
        }
        if (list == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(18);
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (SvnCopyRootSimple simple : list) {
            SvnVcs vcs;
            Info info2;
            VirtualFile copyRoot = lfs.findFileByIoFile(new File(simple.myCopyRoot));
            VirtualFile vcsRoot = lfs.findFileByIoFile(new File(simple.myVcsRoot));
            if (copyRoot == null || vcsRoot == null || (info2 = (vcs = SvnVcs.getInstance(this.myProject)).getInfo(copyRoot)) == null || info2.getRepositoryRootUrl() == null) continue;
            Node node = new Node(copyRoot, info2.getUrl(), info2.getRepositoryRootUrl());
            mapping.add(new RootUrlInfo(node, SvnFormatSelector.findRootAndGetFormat(info2.getFile()), vcsRoot));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnFileUrlMappingImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnFileUrlMappingImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllWcInfos";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorRoots";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFilteredRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUrlForFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getWcRootForFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWcRootForUrl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertRoots";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acceptNestedData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyDetectionResult";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NewRootsApplier {
        @NotNull
        private final SvnRootsDetector.Result myResult;
        @NotNull
        private final SvnMapping myNewMapping;
        @NotNull
        private final SvnMapping myNewFilteredMapping;

        private NewRootsApplier(SvnRootsDetector.Result result) {
            if (result == null) {
                NewRootsApplier.$$$reportNull$$$0(0);
            }
            this.myNewMapping = new SvnMapping();
            this.myNewFilteredMapping = new SvnMapping();
            this.myResult = result;
        }

        public void apply() {
            this.myNewMapping.addAll(this.myResult.getTopRoots());
            this.myNewMapping.reportLonelyRoots(this.myResult.getLonelyRoots());
            this.myNewFilteredMapping.addAll(new UniqueRootsFilter().filter(this.myResult.getTopRoots()));
            this.runUpdateMappings();
        }

        private void runUpdateMappings() {
            ReadAction.run(() -> {
                if (!SvnFileUrlMappingImpl.this.myProject.isDisposed()) {
                    boolean mappingsChanged = this.updateMappings();
                    this.notifyRootsReloaded(mappingsChanged);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateMappings() {
            boolean mappingsChanged;
            Object object = SvnFileUrlMappingImpl.this.myMonitor;
            synchronized (object) {
                mappingsChanged = !SvnFileUrlMappingImpl.this.myMoreRealMapping.equals(this.myNewFilteredMapping);
                mappingsChanged |= !SvnFileUrlMappingImpl.this.myErrorRoots.equals(this.myResult.getErrorRoots());
                SvnFileUrlMappingImpl.this.myMapping.copyFrom(this.myNewMapping);
                SvnFileUrlMappingImpl.this.myMoreRealMapping.copyFrom(this.myNewFilteredMapping);
                SvnFileUrlMappingImpl.this.myErrorRoots.clear();
                SvnFileUrlMappingImpl.this.myErrorRoots.addAll(this.myResult.getErrorRoots());
            }
            return mappingsChanged;
        }

        private void notifyRootsReloaded(boolean mappingsChanged) {
            if (mappingsChanged || !SvnFileUrlMappingImpl.this.myInitedReloaded) {
                SvnFileUrlMappingImpl.this.myInitedReloaded = true;
                ((Consumer)BackgroundTaskUtil.syncPublisher((Project)SvnFileUrlMappingImpl.this.myProject, SvnVcs.ROOTS_RELOADED)).consume((Object)true);
                ((VcsListener)BackgroundTaskUtil.syncPublisher((Project)SvnFileUrlMappingImpl.this.myProject, (Topic)ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN)).directoryMappingChanged();
            } else {
                ((Consumer)BackgroundTaskUtil.syncPublisher((Project)SvnFileUrlMappingImpl.this.myProject, SvnVcs.ROOTS_RELOADED)).consume((Object)false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl$NewRootsApplier", "<init>"));
        }
    }

    private static class MyRootsHelper {
        @NotNull
        private static final ThreadLocal<Boolean> ourInProgress = ThreadLocal.withInitial(() -> Boolean.FALSE);
        @NotNull
        private final Project myProject;
        @NotNull
        private final ProjectLevelVcsManager myVcsManager;

        private MyRootsHelper(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
            if (project == null) {
                MyRootsHelper.$$$reportNull$$$0(0);
            }
            if (vcsManager == null) {
                MyRootsHelper.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myVcsManager = vcsManager;
        }

        @NotNull
        public VirtualFile[] execute() {
            VirtualFile[] virtualFileArray;
            block3: {
                ourInProgress.set(Boolean.TRUE);
                virtualFileArray = this.myVcsManager.getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(this.myProject));
                if (virtualFileArray != null) break block3;
                MyRootsHelper.$$$reportNull$$$0(2);
            }
            return virtualFileArray;
            finally {
                ourInProgress.set(Boolean.FALSE);
            }
        }

        public static boolean isInProgress() {
            return ourInProgress.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsManager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/SvnFileUrlMappingImpl$MyRootsHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/SvnFileUrlMappingImpl$MyRootsHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

