/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;

public class SvnChangelistListener
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangelistListener");
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Condition<FilePath> myUnderSvnCondition;

    public SvnChangelistListener(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnChangelistListener.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myUnderSvnCondition = path -> {
            AbstractVcs vcs1 = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject()).getVcsFor(path);
            return vcs1 != null && "svn".equals(vcs1.getName());
        };
    }

    public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
        if (LocalChangeList.DEFAULT_NAME.equals(fromList.getName())) {
            return;
        }
        this.removeFromChangeList(changes);
    }

    public void changesAdded(Collection<Change> changes, ChangeList toList) {
        if (toList == null || LocalChangeList.DEFAULT_NAME.equals(toList.getName())) {
            return;
        }
        this.addToChangeList(toList.getName(), changes);
    }

    public void changeListRemoved(ChangeList list) {
        this.removeFromChangeList(list.getChanges());
    }

    @NotNull
    private List<FilePath> getPathsFromChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            SvnChangelistListener.$$$reportNull$$$0(1);
        }
        List list = ContainerUtil.findAll((Collection)ChangesUtil.getPaths(changes), this.myUnderSvnCondition);
        if (list == null) {
            SvnChangelistListener.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void changeListRenamed(ChangeList list, String oldName) {
        if (Comparing.equal((String)list.getName(), (String)oldName)) {
            return;
        }
        if (LocalChangeList.DEFAULT_NAME.equals(list.getName())) {
            this.changeListRemoved(list);
            return;
        }
        this.addToChangeList(list.getName(), list.getChanges());
    }

    public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
        String[] stringArray;
        if (fromList.getName().equals(toList.getName())) {
            return;
        }
        if (LocalChangeList.DEFAULT_NAME.equals(toList.getName())) {
            this.changeListRemoved(toList);
            return;
        }
        if (LocalChangeList.DEFAULT_NAME.equals(fromList.getName())) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fromList.getName();
        }
        String[] fromLists = stringArray;
        this.addToChangeList(toList.getName(), changes, fromLists);
    }

    @Nullable
    public static String getCurrentMapping(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            SvnChangelistListener.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SvnChangelistListener.$$$reportNull$$$0(4);
        }
        try {
            Status status = vcs.getFactory(file).createStatusClient().doStatus(file, false);
            return status == null ? null : status.getChangeListName();
        }
        catch (SvnBindException e) {
            if (e.contains(ErrorCode.WC_NOT_WORKING_COPY) || e.contains(ErrorCode.WC_NOT_FILE)) {
                LOG.debug("Logging only, exception is valid (caught) here", (Throwable)((Object)e));
            } else {
                LOG.info("Logging only, exception is valid (caught) here", (Throwable)((Object)e));
            }
            return null;
        }
    }

    public static void putUnderList(@NotNull SvnVcs vcs, @NotNull String list, @NotNull File after) throws VcsException {
        if (vcs == null) {
            SvnChangelistListener.$$$reportNull$$$0(5);
        }
        if (list == null) {
            SvnChangelistListener.$$$reportNull$$$0(6);
        }
        if (after == null) {
            SvnChangelistListener.$$$reportNull$$$0(7);
        }
        SvnChangelistListener.doChangeListOperation(vcs, after, (ThrowableConsumer<ChangeListClient, VcsException>)((ThrowableConsumer)client -> client.add(list, after, null)));
    }

    public static void removeFromList(@NotNull SvnVcs vcs, @NotNull File after) throws VcsException {
        if (vcs == null) {
            SvnChangelistListener.$$$reportNull$$$0(8);
        }
        if (after == null) {
            SvnChangelistListener.$$$reportNull$$$0(9);
        }
        SvnChangelistListener.doChangeListOperation(vcs, after, (ThrowableConsumer<ChangeListClient, VcsException>)((ThrowableConsumer)client -> client.remove(after)));
    }

    private static void doChangeListOperation(@NotNull SvnVcs vcs, @NotNull File file, @NotNull ThrowableConsumer<ChangeListClient, VcsException> operation) throws VcsException {
        if (vcs == null) {
            SvnChangelistListener.$$$reportNull$$$0(10);
        }
        if (file == null) {
            SvnChangelistListener.$$$reportNull$$$0(11);
        }
        if (operation == null) {
            SvnChangelistListener.$$$reportNull$$$0(12);
        }
        try {
            operation.consume((Object)vcs.getFactory(file).createChangeListClient());
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            if (!e.contains(ErrorCode.WC_NOT_WORKING_COPY) && !e.contains(ErrorCode.WC_NOT_FILE)) {
                throw e;
            }
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            throw e;
        }
    }

    private void removeFromChangeList(@NotNull Collection<Change> changes) {
        if (changes == null) {
            SvnChangelistListener.$$$reportNull$$$0(13);
        }
        for (FilePath path : this.getPathsFromChanges(changes)) {
            try {
                File file = path.getIOFile();
                this.myVcs.getFactory(file).createChangeListClient().remove(file);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private void addToChangeList(@NotNull String changeList, @NotNull Collection<Change> changes) {
        if (changeList == null) {
            SvnChangelistListener.$$$reportNull$$$0(14);
        }
        if (changes == null) {
            SvnChangelistListener.$$$reportNull$$$0(15);
        }
        this.addToChangeList(changeList, changes, null);
    }

    private void addToChangeList(@NotNull String changeList, @NotNull Collection<Change> changes, @Nullable String[] changeListsToOperate) {
        if (changeList == null) {
            SvnChangelistListener.$$$reportNull$$$0(16);
        }
        if (changes == null) {
            SvnChangelistListener.$$$reportNull$$$0(17);
        }
        for (FilePath path : this.getPathsFromChanges(changes)) {
            try {
                File file = path.getIOFile();
                this.myVcs.getFactory(file).createChangeListClient().add(changeList, file, changeListsToOperate);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnChangelistListener";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnChangelistListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsFromChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPathsFromChanges";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentMapping";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putUnderList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFromList";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doChangeListOperation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeFromChangeList";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addToChangeList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

