/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public abstract class FileEditorManagerTestCase
extends BasePlatformTestCase {
    protected FileEditorManagerImpl myManager;
    private FileEditorManager myOldManager;
    private Set<DockContainer> myOldDockContainers;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.myOldDockContainers = DockManager.getInstance((Project)this.getProject()).getContainers();
        this.myManager = new FileEditorManagerImpl(this.getProject());
        this.myOldManager = (FileEditorManager)((ComponentManagerImpl)this.getProject()).registerComponentInstance(FileEditorManager.class, (Object)this.myManager);
        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
    }

    @Override
    protected void tearDown() throws Exception {
        new RunAll(() -> {
            for (DockContainer container : DockManager.getInstance((Project)this.getProject()).getContainers()) {
                if (this.myOldDockContainers.contains(container)) continue;
                Disposer.dispose((Disposable)container);
            }
            this.myOldDockContainers = null;
            ((ComponentManagerImpl)this.getProject()).registerComponentInstance(FileEditorManager.class, (Object)this.myOldManager);
            this.myManager.closeAllFiles();
            EditorHistoryManager.getInstance((Project)this.getProject()).removeAllFiles();
            ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
        }, () -> Disposer.dispose((Disposable)this.myManager), () -> {
            this.myManager = null;
            this.myOldManager = null;
        }, () -> super.tearDown()).run();
    }

    protected VirtualFile getFile(String path) {
        String fullPath = this.getTestDataPath() + path;
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
        FileEditorManagerTestCase.assertNotNull((String)("Can't find " + fullPath), (Object)file);
        return file;
    }

    protected void openFiles(@NotNull String femSerialisedText) throws IOException, JDOMException, InterruptedException, ExecutionException {
        if (femSerialisedText == null) {
            FileEditorManagerTestCase.$$$reportNull$$$0(0);
        }
        Element rootElement = JDOMUtil.load((CharSequence)femSerialisedText);
        ExpandMacroToPathMap map = new ExpandMacroToPathMap();
        map.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        map.substitute(rootElement, true, true);
        this.myManager.loadState(rootElement);
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> this.myManager.getMainSplitters().openFiles());
        while (true) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                UIUtil.dispatchAllInvocationEvents();
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "femSerialisedText", "com/intellij/testFramework/FileEditorManagerTestCase", "openFiles"));
    }
}

