/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.selector.misc.BufferedProxySelector;
import com.github.markusbernhardt.proxy.selector.pac.PacProxySelector;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptSource;
import com.github.markusbernhardt.proxy.selector.pac.UrlPacScriptSource;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class IdeaWideProxySelector
extends ProxySelector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.net.IdeaWideProxySelector");
    private final HttpConfigurable myHttpConfigurable;
    private final AtomicReference<Pair<ProxySelector, String>> myPacProxySelector = new AtomicReference();

    public IdeaWideProxySelector(HttpConfigurable configurable) {
        this.myHttpConfigurable = configurable;
    }

    @Override
    public List<Proxy> select(@NotNull URI uri) {
        if (uri == null) {
            IdeaWideProxySelector.$$$reportNull$$$0(0);
        }
        LOG.debug("IDEA-wide proxy selector asked for " + uri.toString());
        String scheme = uri.getScheme();
        if (!"http".equals(scheme) && !"https".equals(scheme)) {
            LOG.debug("No proxy: not http/https scheme: " + scheme);
            return CommonProxy.NO_PROXY_LIST;
        }
        if (this.myHttpConfigurable.USE_HTTP_PROXY) {
            if (this.myHttpConfigurable.isProxyException(uri)) {
                LOG.debug("No proxy: URI '", new Object[]{uri, "' matches proxy exceptions [", this.myHttpConfigurable.PROXY_EXCEPTIONS, "]"});
                return CommonProxy.NO_PROXY_LIST;
            }
            if (this.myHttpConfigurable.PROXY_PORT < 0 || this.myHttpConfigurable.PROXY_PORT > 65535) {
                LOG.debug("No proxy: invalid port: " + this.myHttpConfigurable.PROXY_PORT);
                return CommonProxy.NO_PROXY_LIST;
            }
            Proxy.Type type = this.myHttpConfigurable.PROXY_TYPE_IS_SOCKS ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
            Proxy proxy = new Proxy(type, new InetSocketAddress(this.myHttpConfigurable.PROXY_HOST, this.myHttpConfigurable.PROXY_PORT));
            LOG.debug("Defined proxy: ", new Object[]{proxy});
            this.myHttpConfigurable.LAST_ERROR = null;
            return Collections.singletonList(proxy);
        }
        if (this.myHttpConfigurable.USE_PROXY_PAC) {
            return this.selectUsingPac(uri);
        }
        return CommonProxy.NO_PROXY_LIST;
    }

    @NotNull
    private List<Proxy> selectUsingPac(@NotNull URI uri) {
        ProxySelector pacProxySelector;
        if (uri == null) {
            IdeaWideProxySelector.$$$reportNull$$$0(1);
        }
        String pacUrlForUse = this.myHttpConfigurable.USE_PAC_URL && !StringUtil.isEmpty((String)this.myHttpConfigurable.PAC_URL) ? this.myHttpConfigurable.PAC_URL : null;
        Pair pair = this.myPacProxySelector.get();
        if (pair != null && !Comparing.equal((String)((String)pair.second), (String)pacUrlForUse)) {
            pair = null;
        }
        if (pair == null) {
            Object newProxySelector;
            if (pacUrlForUse == null) {
                ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
                proxySearch.setPacCacheSettings(32, 600000L, BufferedProxySelector.CacheScope.CACHE_SCOPE_HOST);
                newProxySelector = proxySearch.getProxySelector();
            } else {
                newProxySelector = new PacProxySelector((PacScriptSource)new UrlPacScriptSource(pacUrlForUse));
            }
            pair = Pair.create((Object)newProxySelector, (Object)pacUrlForUse);
            this.myPacProxySelector.lazySet((Pair<ProxySelector, String>)pair);
        }
        if ((pacProxySelector = (ProxySelector)pair.first) == null) {
            LOG.debug("No proxies detected");
        } else {
            List<Proxy> list;
            try {
                List<Proxy> select = pacProxySelector.select(uri);
                LOG.debug("Autodetected proxies: ", new Object[]{select});
                list = select;
            }
            catch (StackOverflowError ignore) {
                LOG.warn("Too large PAC script (JRE-247)");
            }
            if (list == null) {
                IdeaWideProxySelector.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<Proxy> list = CommonProxy.NO_PROXY_LIST;
        if (list == null) {
            IdeaWideProxySelector.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        InetSocketAddress isa;
        if (this.myHttpConfigurable.USE_PROXY_PAC) {
            this.myHttpConfigurable.removeGeneric(new CommonProxy.HostInfo(uri.getScheme(), uri.getHost(), uri.getPort()));
            LOG.debug("generic proxy credentials (if were saved) removed");
            return;
        }
        InetSocketAddress inetSocketAddress = isa = sa instanceof InetSocketAddress ? (InetSocketAddress)sa : null;
        if (this.myHttpConfigurable.USE_HTTP_PROXY && isa != null && Comparing.equal((String)this.myHttpConfigurable.PROXY_HOST, (String)isa.getHostName())) {
            LOG.debug("connection failed message passed to http configurable");
            this.myHttpConfigurable.LAST_ERROR = ioe.getMessage();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/IdeaWideProxySelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/IdeaWideProxySelector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "selectUsingPac";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectUsingPac";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

