/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.newImpl;

import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.newImpl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class TabsSideSplitter
implements Splittable,
PropertyChangeListener {
    @NotNull
    private final JBTabsImpl myTabs;
    private int mySideTabsLimit;
    private boolean myDragging;
    private final OnePixelDivider myDivider;

    TabsSideSplitter(@NotNull JBTabsImpl tabs) {
        if (tabs == null) {
            TabsSideSplitter.$$$reportNull$$$0(0);
        }
        this.mySideTabsLimit = JBTabsImpl.DEFAULT_MAX_TAB_WIDTH;
        this.myTabs = tabs;
        this.myTabs.addPropertyChangeListener(JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY.toString(), this);
        this.myDivider = new OnePixelDivider(false, this);
    }

    OnePixelDivider getDivider() {
        return this.myDivider;
    }

    public float getMinProportion(boolean first) {
        return Math.min(0.5f, (float)JBTabsImpl.MIN_TAB_WIDTH / (float)Math.max(1, this.myTabs.getWidth()));
    }

    public void setProportion(float proportion) {
        int width = this.myTabs.getWidth();
        if (this.myTabs.getTabsPosition() == JBTabsPosition.left) {
            this.setSideTabsLimit((int)Math.max((float)JBTabsImpl.MIN_TAB_WIDTH, proportion * (float)width));
        } else if (this.myTabs.getTabsPosition() == JBTabsPosition.right) {
            this.setSideTabsLimit(width - (int)Math.max((float)JBTabsImpl.MIN_TAB_WIDTH, proportion * (float)width));
        }
    }

    int getSideTabsLimit() {
        return this.mySideTabsLimit;
    }

    void setSideTabsLimit(int sideTabsLimit) {
        if (this.mySideTabsLimit != sideTabsLimit) {
            JComponent page;
            this.mySideTabsLimit = sideTabsLimit;
            UIUtil.putClientProperty((JComponent)this.myTabs, JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY, (Object)this.mySideTabsLimit);
            this.myTabs.resetLayout(true);
            this.myTabs.doLayout();
            this.myTabs.repaint();
            TabInfo info = this.myTabs.getSelectedInfo();
            JComponent jComponent = page = info != null ? info.getComponent() : null;
            if (page != null) {
                page.revalidate();
                page.repaint();
            }
        }
    }

    public boolean getOrientation() {
        return false;
    }

    public void setOrientation(boolean verticalSplit) {
    }

    public void setDragging(boolean dragging) {
        this.myDragging = dragging;
    }

    boolean isDragging() {
        return this.myDragging;
    }

    @NotNull
    public Component asComponent() {
        JBTabsImpl jBTabsImpl = this.myTabs;
        if (jBTabsImpl == null) {
            TabsSideSplitter.$$$reportNull$$$0(1);
        }
        return jBTabsImpl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() != this.myTabs) {
            return;
        }
        Integer limit = (Integer)UIUtil.getClientProperty((Object)this.myTabs, JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY);
        if (limit == null) {
            limit = JBTabsImpl.DEFAULT_MAX_TAB_WIDTH;
        }
        this.setSideTabsLimit(limit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/newImpl/TabsSideSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/newImpl/TabsSideSplitter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

