/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AsyncValueLoader<T> {
    private final AtomicReference<Promise<T>> ref = new AtomicReference();
    private volatile long modificationCount;
    private volatile long loadedModificationCount;
    private final Consumer<T> doneHandler = new Consumer<T>(){

        @Override
        public void accept(T o) {
            AsyncValueLoader.this.loadedModificationCount = AsyncValueLoader.this.modificationCount;
        }
    };

    @NotNull
    public final Promise<T> get() {
        Promise<T> promise = this.get(true);
        if (promise == null) {
            AsyncValueLoader.$$$reportNull$$$0(0);
        }
        return promise;
    }

    public final T getResultIfFullFilled() {
        Promise<T> result = this.ref.get();
        try {
            return (T)(result != null && result.isSucceeded() ? result.blockingGet(0) : null);
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }

    public final void reset() {
        Promise oldValue = this.ref.getAndSet(null);
        if (oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    private void rejectAndDispose(@NotNull AsyncPromise<? extends T> asyncResult) {
        Object result;
        if (asyncResult == null) {
            AsyncValueLoader.$$$reportNull$$$0(1);
        }
        if (asyncResult.setError("rejected")) {
            return;
        }
        try {
            result = asyncResult.blockingGet(0);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        if (result != null) {
            this.disposeResult(result);
        }
    }

    protected void disposeResult(@NotNull T result) {
        if (result == null) {
            AsyncValueLoader.$$$reportNull$$$0(2);
        }
        if (result instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)result), (boolean)false);
        }
    }

    @NotNull
    public final Promise<T> get(boolean checkFreshness) {
        Promise<T> promise = this.ref.get();
        if (promise == null) {
            promise = new AsyncPromise();
            if (!this.ref.compareAndSet(null, promise)) {
                Promise<T> promise2 = this.ref.get();
                if (promise2 == null) {
                    AsyncValueLoader.$$$reportNull$$$0(3);
                }
                return promise2;
            }
        } else {
            Promise.State state = promise.getState();
            if (state == Promise.State.PENDING) {
                Promise<T> promise3 = promise;
                if (promise3 == null) {
                    AsyncValueLoader.$$$reportNull$$$0(4);
                }
                return promise3;
            }
            if (state == Promise.State.SUCCEEDED) {
                if (!checkFreshness || this.isUpToDate()) {
                    Promise<T> promise4 = promise;
                    if (promise4 == null) {
                        AsyncValueLoader.$$$reportNull$$$0(5);
                    }
                    return promise4;
                }
                if (!this.ref.compareAndSet(promise, promise = new AsyncPromise())) {
                    Promise<T> valueFromAnotherThread = this.ref.get();
                    while (valueFromAnotherThread == null) {
                        if (this.ref.compareAndSet(null, promise)) {
                            Promise<T> promise5 = this.getPromise((AsyncPromise)promise);
                            if (promise5 == null) {
                                AsyncValueLoader.$$$reportNull$$$0(6);
                            }
                            return promise5;
                        }
                        valueFromAnotherThread = this.ref.get();
                    }
                    Promise<T> promise6 = valueFromAnotherThread;
                    if (promise6 == null) {
                        AsyncValueLoader.$$$reportNull$$$0(7);
                    }
                    return promise6;
                }
            }
        }
        Promise<T> promise7 = this.getPromise((AsyncPromise)promise);
        if (promise7 == null) {
            AsyncValueLoader.$$$reportNull$$$0(8);
        }
        return promise7;
    }

    protected boolean isCancelOnReject() {
        return false;
    }

    @NotNull
    private Promise<T> getPromise(@NotNull AsyncPromise<T> promise) {
        Promise<T> effectivePromise;
        if (promise == null) {
            AsyncValueLoader.$$$reportNull$$$0(9);
        }
        try {
            effectivePromise = this.load(promise);
            if (effectivePromise != promise) {
                this.ref.compareAndSet(promise, effectivePromise);
            }
        }
        catch (Throwable e) {
            this.ref.compareAndSet(promise, null);
            this.rejectAndDispose(promise);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        effectivePromise.onSuccess(this.doneHandler);
        if (this.isCancelOnReject()) {
            effectivePromise.onError(throwable -> this.ref.compareAndSet(effectivePromise, null));
        }
        if (effectivePromise != promise) {
            effectivePromise.processed(promise);
        }
        Promise<T> promise2 = effectivePromise;
        if (promise2 == null) {
            AsyncValueLoader.$$$reportNull$$$0(10);
        }
        return promise2;
    }

    @NotNull
    protected abstract Promise<T> load(@NotNull AsyncPromise<T> var1) throws IOException;

    private boolean isUpToDate() {
        return this.loadedModificationCount == this.modificationCount;
    }

    public final void set(@NotNull T result) {
        Promise<T> oldValue;
        if (result == null) {
            AsyncValueLoader.$$$reportNull$$$0(11);
        }
        if ((oldValue = this.ref.getAndSet(Promises.resolvedPromise(result))) instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    public final void markDirty() {
        ++this.modificationCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/concurrency/AsyncValueLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncResult";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/concurrency/AsyncValueLoader";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromise";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rejectAndDispose";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disposeResult";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPromise";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

