/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingWorker;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgressBar;
import processing.app.contrib.ContribProgressMonitor;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusPanel;
import processing.app.ui.Editor;
import processing.core.PApplet;
import processing.data.StringDict;

public class ContributionManager {
    static ContributionListing listing;
    static ManagerFrame managerDialog;

    /*
     * Unable to fully structure code
     */
    static boolean download(URL source, byte[] post, File dest, ContribProgressMonitor progress) {
        block11: {
            success = false;
            try {
                block12: {
                    conn = (HttpURLConnection)source.openConnection();
                    HttpURLConnection.setFollowRedirects(true);
                    conn.setConnectTimeout(15000);
                    conn.setReadTimeout(60000);
                    if (post == null) {
                        conn.setRequestMethod("GET");
                        conn.connect();
                    } else {
                        post = Util.gzipEncode(post);
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        conn.setRequestProperty("Content-Encoding", "gzip");
                        conn.setRequestProperty("Content-Length", String.valueOf(post.length));
                        conn.setUseCaches(false);
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.getOutputStream().write(post);
                    }
                    if (progress != null) {
                        progress.max = fileSize = conn.getContentLength();
                        progress.startTask(Language.text("contrib.progress.downloading"), fileSize);
                    }
                    if ((response = conn.getResponseCode()) >= 300 && response < 400) {
                        newLocation = conn.getHeaderField("Location");
                        return ContributionManager.download(new URL(newLocation), post, dest, progress);
                    }
                    in = conn.getInputStream();
                    out = new FileOutputStream(dest);
                    b = new byte[8192];
                    if (progress == null) ** GOTO lbl37
                    total = 0;
                    while (!progress.isCanceled() && (amount = in.read(b)) != -1) {
                        out.write(b, 0, amount);
                        progress.setProgress(total += amount);
                    }
                    break block12;
lbl-1000:
                    // 1 sources

                    {
                        out.write(b, 0, amount);
lbl37:
                        // 2 sources

                        ** while ((amount = in.read((byte[])b)) != -1)
                    }
                }
                out.flush();
                out.close();
                success = true;
            }
            catch (SocketTimeoutException ste) {
                if (progress != null) {
                    progress.error(ste);
                    progress.cancel();
                }
            }
            catch (IOException ioe) {
                if (progress == null) break block11;
                progress.error(ioe);
                progress.cancel();
            }
        }
        if (progress != null) {
            progress.finished();
        }
        return success;
    }

    static void downloadAndInstall(final Base base, final URL url, final AvailableContribution ad, final ContribProgressBar downloadProgress, final ContribProgressBar installProgress, final StatusPanel status) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String filename = url.getFile();
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                try {
                    File contribZip = File.createTempFile("download", filename);
                    contribZip.setWritable(true);
                    try {
                        ContributionManager.download(url, null, contribZip, downloadProgress);
                        if (!downloadProgress.isCanceled() && !downloadProgress.isError()) {
                            installProgress.startTask(Language.text("contrib.progress.installing"), -1);
                            final LocalContribution contribution = ad.install(base, contribZip, false, status);
                            if (contribution != null) {
                                try {
                                    EventQueue.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            listing.replaceContribution(ad, contribution);
                                            base.refreshContribs(contribution.getType());
                                            base.setUpdatesAvailable(listing.countUpdates(base));
                                        }
                                    });
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    throw (Exception)e.getCause();
                                }
                            }
                            installProgress.finished();
                        } else if (downloadProgress.exception instanceof SocketTimeoutException) {
                            status.setErrorMessage(Language.interpolate("contrib.errors.contrib_download.timeout", ad.getName()));
                        } else {
                            status.setErrorMessage("Could not download " + url + " to " + contribZip + " : " + Language.interpolate("contrib.errors.download_and_install", ad.getName()));
                        }
                        contribZip.delete();
                    }
                    catch (Exception e) {
                        String msg = null;
                        if (e instanceof RuntimeException) {
                            Throwable cause = ((RuntimeException)e).getCause();
                            if (cause instanceof NoClassDefFoundError || cause instanceof NoSuchMethodError) {
                                msg = "This item is not compatible with this version of Processing";
                            } else if (cause instanceof UnsupportedClassVersionError) {
                                msg = "This item needs to be recompiled for Java " + PApplet.javaPlatform;
                            }
                        }
                        if (msg == null) {
                            msg = Language.interpolate("contrib.errors.download_and_install", ad.getName());
                        }
                        status.setErrorMessage(msg);
                        downloadProgress.cancel();
                        installProgress.cancel();
                    }
                }
                catch (IOException iOException) {
                    status.setErrorMessage(Language.text("contrib.errors.temporary_directory"));
                    downloadProgress.cancel();
                    installProgress.cancel();
                }
            }
        }, "Contribution Installer").start();
    }

    static void downloadAndInstallOnStartup(final Base base, final URL url, final AvailableContribution ad) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String filename = url.getFile();
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                try {
                    File contribZip = File.createTempFile("download", filename);
                    contribZip.setWritable(true);
                    try {
                        ContributionManager.download(url, null, contribZip, null);
                        final LocalContribution contribution = ad.install(base, contribZip, false, null);
                        if (contribution != null) {
                            try {
                                EventQueue.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        listing.replaceContribution(ad, contribution);
                                        base.refreshContribs(contribution.getType());
                                        base.setUpdatesAvailable(listing.countUpdates(base));
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof RuntimeException) {
                                    throw (RuntimeException)cause;
                                }
                                cause.printStackTrace();
                            }
                        }
                        contribZip.delete();
                        ContributionManager.handleUpdateFailedMarkers(ad, filename.substring(0, filename.lastIndexOf(46)));
                    }
                    catch (Exception exception) {
                        String arg = "contrib.startup.errors.download_install";
                        System.err.println(Language.interpolate(arg, ad.getName()));
                    }
                }
                catch (IOException iOException) {
                    String arg = "contrib.startup.errors.temp_dir";
                    System.err.println(Language.interpolate(arg, ad.getName()));
                }
            }
        }, "Contribution Installer").start();
    }

    private static void handleUpdateFailedMarkers(AvailableContribution c, String filename) {
        File typeFolder = c.getType().getSketchbookFolder();
        File[] fileArray = typeFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File propsFile;
            File contribDir = fileArray[n2];
            if (contribDir.isDirectory() && (propsFile = new File(contribDir, (Object)((Object)c.getType()) + ".properties")).exists()) {
                StringDict props = Util.readSettings(propsFile);
                if (c.getName().equals(props.get("name"))) {
                    return;
                }
            }
            ++n2;
        }
        try {
            new File(typeFolder, c.getName()).createNewFile();
        }
        catch (IOException iOException) {
            String arg = "contrib.startup.errors.new_marker";
            System.err.println(Language.interpolate(arg, c.getName()));
        }
    }

    public static void downloadAndInstallOnImport(final Base base, List<AvailableContribution> list) {
        Editor editor = base.getActiveEditor();
        editor.getTextArea().setEditable(false);
        ArrayList<String> installedLibList = new ArrayList<String>();
        boolean isPrevDone = false;
        for (final AvailableContribution contrib : list) {
            if (contrib.getType() != ContributionType.LIBRARY) continue;
            try {
                URL url = new URL(contrib.link);
                String filename = url.getFile();
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                try {
                    File contribZip = File.createTempFile("download", filename);
                    contribZip.setWritable(true);
                    try {
                        String arg;
                        String statusMsg = editor.getStatusMessage();
                        if (isPrevDone) {
                            String status = String.valueOf(statusMsg) + " " + Language.interpolate("contrib.import.progress.download", contrib.name);
                            editor.statusNotice(status);
                        } else {
                            arg = "contrib.import.progress.download";
                            String status = Language.interpolate(arg, contrib.name);
                            editor.statusNotice(status);
                        }
                        isPrevDone = false;
                        ContributionManager.download(url, null, contribZip, null);
                        arg = "contrib.import.progress.install";
                        editor.statusNotice(Language.interpolate(arg, contrib.name));
                        final LocalContribution contribution = contrib.install(base, contribZip, false, null);
                        if (contribution != null) {
                            try {
                                EventQueue.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        listing.replaceContribution(contrib, contribution);
                                        base.refreshContribs(contribution.getType());
                                        base.setUpdatesAvailable(listing.countUpdates(base));
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof RuntimeException) {
                                    throw (RuntimeException)cause;
                                }
                                cause.printStackTrace();
                            }
                        }
                        contribZip.delete();
                        installedLibList.add(contrib.name);
                        isPrevDone = true;
                        arg = "contrib.import.progress.done";
                        editor.statusNotice(Language.interpolate(arg, contrib.name));
                    }
                    catch (Exception exception) {
                        String arg = "contrib.startup.errors.download_install";
                        System.err.println(Language.interpolate(arg, contrib.getName()));
                    }
                }
                catch (IOException iOException) {
                    String arg = "contrib.startup.errors.temp_dir";
                    System.err.println(Language.interpolate(arg, contrib.getName()));
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(Language.interpolate("contrib.import.errors.link", contrib.getName()));
            }
        }
        editor.getTextArea().setEditable(true);
        editor.statusEmpty();
        System.out.println(Language.text("contrib.import.progress.final_list"));
        for (String l : installedLibList) {
            System.out.println("  * " + l);
        }
    }

    public static File getUniqueName(File parentFolder, String fileName) {
        String folderName;
        File backupFolderForLib;
        int i = 1;
        do {
            folderName = fileName;
            if (i >= 2) {
                folderName = String.valueOf(folderName) + "(" + i + ")";
            }
            ++i;
        } while ((backupFolderForLib = new File(parentFolder, folderName)).exists());
        return backupFolderForLib;
    }

    public static String getFileName(File libFile) {
        String path = libFile.getPath();
        int lastSeparator = path.lastIndexOf(File.separatorChar);
        String fileName = lastSeparator != -1 ? path.substring(lastSeparator + 1) : path;
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot != -1) {
            return fileName.substring(0, lastDot);
        }
        return fileName;
    }

    private static void cleanup(final Base base) throws Exception {
        ContributionManager.deleteTemp(Base.getSketchbookModesFolder());
        ContributionManager.deleteTemp(Base.getSketchbookToolsFolder());
        ContributionManager.deleteFlagged(Base.getSketchbookLibrariesFolder());
        ContributionManager.deleteFlagged(Base.getSketchbookModesFolder());
        ContributionManager.deleteFlagged(Base.getSketchbookToolsFolder());
        ContributionManager.installPreviouslyFailed(base, Base.getSketchbookModesFolder());
        ContributionManager.updateFlagged(base, Base.getSketchbookModesFolder());
        ContributionManager.updateFlagged(base, Base.getSketchbookToolsFolder());
        SwingWorker<Void, Void> s = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    Thread.sleep(1000L);
                    ContributionManager.installPreviouslyFailed(base, Base.getSketchbookToolsFolder());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        s.execute();
        ContributionManager.clearRestartFlags(Base.getSketchbookModesFolder());
        ContributionManager.clearRestartFlags(Base.getSketchbookToolsFolder());
    }

    private static void deleteTemp(File root) {
        String pattern = String.valueOf(root.getName().substring(0, 4)) + "\\d*" + "tmp";
        File[] possible = root.listFiles();
        if (possible != null) {
            File[] fileArray = possible;
            int n = possible.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().matches(pattern)) {
                    Util.removeDir(f);
                }
                ++n2;
            }
        }
    }

    private static void deleteFlagged(File root) throws Exception {
        File[] markedForDeletion = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File folder) {
                return folder.isDirectory() && LocalContribution.isDeletionFlagged(folder);
            }
        });
        if (markedForDeletion != null) {
            File[] fileArray = markedForDeletion;
            int n = markedForDeletion.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                Util.removeDir(folder);
                ++n2;
            }
        }
    }

    private static void installPreviouslyFailed(Base base, File root) throws Exception {
        File[] installList;
        File[] fileArray = installList = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File folder) {
                return folder.isFile();
            }
        });
        int n = installList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            for (AvailableContribution contrib : ContributionManager.listing.advertisedContributions) {
                if (!file.getName().equals(contrib.getName())) continue;
                file.delete();
                ContributionManager.installOnStartUp(base, contrib);
                EventQueue.invokeAndWait(() -> listing.replaceContribution(contrib, contrib));
            }
            ++n2;
        }
    }

    private static void updateFlagged(Base base, File root) throws Exception {
        File[] markedForUpdate = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File folder) {
                return folder.isDirectory() && LocalContribution.isUpdateFlagged(folder);
            }
        });
        ArrayList<String> updateContribsNames = new ArrayList<String>();
        LinkedList<AvailableContribution> updateContribsList = new LinkedList<AvailableContribution>();
        String type = root.getName().substring(root.getName().lastIndexOf(47) + 1);
        String propFileName = null;
        if (type.equalsIgnoreCase("tools")) {
            propFileName = "tool.properties";
        } else if (type.equalsIgnoreCase("modes")) {
            propFileName = "mode.properties";
        } else if (type.equalsIgnoreCase("libraries")) {
            propFileName = "libraries.properties";
        }
        File[] fileArray = markedForUpdate;
        int n = markedForUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            StringDict props = Util.readSettings(new File(folder, propFileName));
            updateContribsNames.add(props.get("name"));
            Util.removeDir(folder);
            ++n2;
        }
        for (AvailableContribution availableContribs : ContributionManager.listing.advertisedContributions) {
            if (!updateContribsNames.contains(availableContribs.getName())) continue;
            updateContribsList.add(availableContribs);
        }
        for (AvailableContribution contribToUpdate : updateContribsList) {
            ContributionManager.installOnStartUp(base, contribToUpdate);
            listing.replaceContribution(contribToUpdate, contribToUpdate);
        }
    }

    private static void installOnStartUp(Base base, AvailableContribution availableContrib) {
        if (availableContrib.link == null) {
            Messages.showWarning(Language.interpolate("contrib.errors.update_on_restart_failed", availableContrib.getName()), Language.text("contrib.unsupported_operating_system"));
        } else {
            try {
                URL downloadUrl = new URL(availableContrib.link);
                ContributionManager.downloadAndInstallOnStartup(base, downloadUrl, availableContrib);
            }
            catch (MalformedURLException e) {
                Messages.showWarning(Language.interpolate("contrib.errors.update_on_restart_failed", availableContrib.getName()), Language.text("contrib.errors.malformed_url"), e);
            }
        }
    }

    private static void clearRestartFlags(File root) throws Exception {
        File[] folderList;
        File[] fileArray = folderList = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File folder) {
                return folder.isDirectory();
            }
        });
        int n = folderList.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            LocalContribution.clearRestartFlags(folder);
            ++n2;
        }
    }

    public static void init(Base base) throws Exception {
        listing = ContributionListing.getInstance();
        managerDialog = new ManagerFrame(base);
        ContributionManager.cleanup(base);
    }

    public static void openLibraries() {
        managerDialog.showFrame(ContributionType.LIBRARY);
    }

    public static void openModes() {
        managerDialog.showFrame(ContributionType.MODE);
    }

    public static void openTools() {
        managerDialog.showFrame(ContributionType.TOOL);
    }

    public static void openExamples() {
        managerDialog.showFrame(ContributionType.EXAMPLES);
    }

    public static void openUpdates() {
        managerDialog.showFrame(null);
    }

    static int getTypeIndex(ContributionType contributionType) {
        int index = contributionType == ContributionType.LIBRARY ? 0 : (contributionType == ContributionType.MODE ? 1 : (contributionType == ContributionType.TOOL ? 2 : (contributionType == ContributionType.EXAMPLES ? 3 : 4)));
        return index;
    }
}

