/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GeomUtils {
    public static Point2D translate(Point2D pt, double deltaX, double deltaY) {
        return new Point2D.Double(pt.getX() + deltaX, pt.getY() + deltaY);
    }

    public static boolean isHorizontal(Line2D.Double seg) {
        return seg.getP1().getY() == seg.getP2().getY();
    }

    public static boolean isVertical(Line2D.Double seg) {
        return seg.getP1().getX() == seg.getP2().getX();
    }

    public static double getMinX(Line2D.Double seg) {
        return Math.min(seg.x1, seg.x2);
    }

    public static double getMaxX(Line2D.Double seg) {
        return Math.max(seg.x1, seg.x2);
    }

    public static double getMinY(Line2D.Double seg) {
        return Math.min(seg.y1, seg.y2);
    }

    public static double getMaxY(Line2D.Double seg) {
        return Math.max(seg.y1, seg.y2);
    }

    public static Point2D.Double getPoint2D(Line2D.Double line, double u) {
        double x = line.x1 + u * (line.x2 - line.x1);
        double y = line.y1 + u * (line.y2 - line.y1);
        return new Point2D.Double(x, y);
    }

    private static boolean isBetween(double value, double v1, double v2) {
        if (v1 < v2) {
            return value >= v1 && value <= v2;
        }
        assert (v2 <= v1);
        return value >= v2 && value <= v1;
    }

    static boolean isBetween(Point2D toTest, Point2D pos1, Point2D pos2) {
        return GeomUtils.isBetween(toTest.getX(), pos1.getX(), pos2.getX()) && GeomUtils.isBetween(toTest.getY(), pos1.getY(), pos2.getY());
    }

    private static double getIntersectionVertical(Line2D.Double line, double xOther) {
        double coef = line.x2 - line.x1;
        if (coef == 0.0) {
            return Double.NaN;
        }
        return (xOther - line.x1) / coef;
    }

    private static double getIntersectionHorizontal(Line2D.Double line, double yOther) {
        double coef = line.y2 - line.y1;
        if (coef == 0.0) {
            return Double.NaN;
        }
        return (yOther - line.y1) / coef;
    }

    public static Point2D.Double getSegIntersection(Line2D.Double line1, Line2D.Double line2) {
        double u;
        if (GeomUtils.isVertical(line2)) {
            u = GeomUtils.getIntersectionVertical(line1, line2.getP1().getX());
        } else if (GeomUtils.isHorizontal(line2)) {
            u = GeomUtils.getIntersectionHorizontal(line1, line2.getP1().getY());
        } else {
            throw new UnsupportedOperationException();
        }
        if (Double.isNaN(u) || u < 0.0 || u > 1.0) {
            return null;
        }
        Point2D.Double result = GeomUtils.getPoint2D(line1, u);
        if (GeomUtils.isBetween(result, line2.getP1(), line2.getP2())) {
            return result;
        }
        return null;
    }

    public static String toString(Line2D line) {
        return GeomUtils.toString(line.getP1()) + "-" + GeomUtils.toString(line.getP2());
    }

    public static String toString(Point2D pt) {
        return "[" + pt.getX() + "," + pt.getY() + "]";
    }

    public static Point2D.Double getCenter(Line2D.Double l) {
        double x = (l.getX1() + l.getX2()) / 2.0;
        double y = (l.getY1() + l.getY2()) / 2.0;
        return new Point2D.Double(x, y);
    }

    public static void fillPoint2D(Graphics2D g2d, Point2D pt) {
        int x = (int)pt.getX() - 1;
        int y = (int)pt.getY() - 1;
        g2d.fillOval(x, y, 3, 3);
    }

    public static double getOrthoDistance(Line2D.Double seg, Point2D pt) {
        if (GeomUtils.isHorizontal(seg)) {
            return Math.abs(seg.getP1().getY() - pt.getY());
        }
        if (GeomUtils.isVertical(seg)) {
            return Math.abs(seg.getP1().getX() - pt.getX());
        }
        throw new IllegalArgumentException();
    }
}

