/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfScaler;
import org.sejda.model.PageSize;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.ResizePagesParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.scale.ScaleType;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizePagesTask
extends BaseTask<ResizePagesParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ResizePagesTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(ResizePagesParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ResizePagesParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            try {
                this.documentHandler = (PDDocumentHandler)source.open(this.documentLoader);
                this.documentHandler.getPermissions().ensurePermission(PdfAccessPermission.MODIFY);
                this.documentHandler.setCreatorOnPDDocument();
                File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
                LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
                ArrayList<PDPage> pages = new ArrayList<PDPage>();
                if (parameters.getPageSelection().isEmpty()) {
                    for (PDPage p : this.documentHandler.getPages()) {
                        pages.add(p);
                    }
                } else {
                    Iterator iterator = parameters.getPages(this.documentHandler.getNumberOfPages()).iterator();
                    while (iterator.hasNext()) {
                        int pageNumber = (Integer)iterator.next();
                        pages.add(this.documentHandler.getPage(pageNumber));
                    }
                }
                if (Objects.nonNull(parameters.getMargins())) {
                    LOG.debug("Adding margins of {} (inches) to {} pages", (Object)parameters.getMargins(), (Object)pages.size());
                    PdfScaler.margin(this.documentHandler.getUnderlyingPDDocument(), pages, parameters.getMargins());
                } else {
                    PageSize pageSize = parameters.getPageSize();
                    if (pageSize != null) {
                        PDRectangle desiredPageSize = new PDRectangle(pageSize.getWidth(), pageSize.getHeight());
                        LOG.debug("Resizing {} pages to match {}", (Object)pages.size(), (Object)desiredPageSize);
                        PdfScaler scaler = new PdfScaler(ScaleType.PAGE);
                        scaler.changePageSize(this.documentHandler.getUnderlyingPDDocument(), pages, desiredPageSize);
                    }
                }
                this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
                this.documentHandler.setCompress(parameters.isCompress());
                this.documentHandler.savePDDocument(tmpFile);
                String outName = NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
                this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
            }
            finally {
                ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
            }
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Input documents scaled and written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
    }
}

