/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import org.apache.commons.lang3.mutable.MutableInt;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfRotator;
import org.sejda.impl.sambox.component.image.ImagesToPdfDocumentConverter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.Source;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.parameter.image.JpegToPdfParameters;
import org.sejda.model.rotation.Rotation;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpegToPdfTask
extends BaseTask<JpegToPdfParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(JpegToPdfTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private SingleOutputWriter outputWriter;

    public void before(JpegToPdfParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.outputWriter = OutputWriters.newSingleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    public void execute(JpegToPdfParameters parameters) throws TaskException {
        final MutableInt currentStep = new MutableInt(0);
        File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        ImagesToPdfDocumentConverter converter = new ImagesToPdfDocumentConverter(){

            @Override
            public void beforeImage(Source<?> source) throws TaskException {
                JpegToPdfTask.this.executionContext().assertTaskNotCancelled();
                currentStep.increment();
            }

            @Override
            public void afterImage(PDImageXObject image) {
                ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)JpegToPdfTask.this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep.getValue().intValue()).outOf(JpegToPdfTask.this.totalSteps);
            }

            @Override
            public void failedImage(Source<?> source, TaskIOException e) throws TaskException {
                JpegToPdfTask.this.executionContext().assertTaskIsLenient((Exception)((Object)e));
                ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)JpegToPdfTask.this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Image %s was skipped, could not be processed", source.getName()), (Exception)((Object)e));
            }
        };
        converter.setDefaultPageSize(parameters.getPageSize());
        converter.setShouldPageSizeMatchImageSize(parameters.isPageSizeMatchImageSize());
        converter.setPageOrientation(parameters.getPageOrientation());
        converter.setMarginInches(parameters.getMarginInches());
        this.documentHandler = converter.convert(parameters.getSourceList());
        PdfRotator rotator = new PdfRotator(this.documentHandler.getUnderlyingPDDocument());
        for (int i = 0; i < parameters.getRotations().size(); ++i) {
            Rotation rotation = (Rotation)parameters.getRotations().get(i);
            if (rotation == null || rotation == Rotation.DEGREES_0) continue;
            rotator.rotate(i + 1, rotation);
        }
        this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
        this.documentHandler.setCompress(parameters.isCompress());
        this.documentHandler.savePDDocument(tmpFile);
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Input images written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
        this.outputWriter = null;
    }
}

