/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.merge;

import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.merge.MergeOptionsPane;
import org.pdfsam.merge.MergeParametersBuilder;
import org.pdfsam.merge.MergeSelectionPane;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.SingleOutputTaskParametersBuilder;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.io.BrowsablePdfOutputField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.module.Footer;
import org.pdfsam.ui.module.OpenButton;
import org.pdfsam.ui.module.RunButton;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.injector.Auto;
import org.sejda.injector.Components;
import org.sejda.injector.Provides;

@Auto
public class MergeModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "merge";
    private MergeSelectionPane selectionPane = new MergeSelectionPane("merge");
    private MergeOptionsPane mergeOptions = new MergeOptionsPane();
    private BrowsablePdfOutputField destinationFileField;
    private PdfDestinationPane destinationPane;
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.MERGE).inputTypes(new ModuleInputOutputType[]{ModuleInputOutputType.MULTIPLE_PDF}).name(DefaultI18nContext.getInstance().i18n("Merge")).description(DefaultI18nContext.getInstance().i18n("Merge together multiple PDF documents or subsections of them.")).priority(ModulePriority.HIGH.getPriority()).supportURL("https://pdfsam.org/pdf-merge/").build();

    @Inject
    public MergeModule(@Named(value="mergefield") BrowsablePdfOutputField destinationFileField, @Named(value="mergepane") PdfDestinationPane destinationPane, @Named(value="mergefooter") Footer footer) {
        super(footer);
        this.destinationFileField = destinationFileField;
        this.destinationPane = destinationPane;
        this.initModuleSettingsPanel(this.settingPanel());
    }

    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.mergeOptions.saveStateTo(data);
        this.destinationFileField.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.mergeOptions.restoreStateFrom(data);
        this.destinationFileField.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
    }

    protected MergeParametersBuilder getBuilder(Consumer<String> onError) {
        MergeParametersBuilder builder = new MergeParametersBuilder();
        this.selectionPane.apply(builder, onError);
        this.mergeOptions.apply(builder, onError);
        this.destinationFileField.apply((SingleOutputTaskParametersBuilder)builder, onError);
        this.destinationPane.apply((AbstractPdfOutputParametersBuilder)builder, onError);
        return builder;
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.selectionPane, (Priority)Priority.ALWAYS);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)DefaultI18nContext.getInstance().i18n("Merge settings"), (Node)this.mergeOptions), Views.titledPane((String)DefaultI18nContext.getInstance().i18n("Destination file"), (Node)this.destinationPane)});
        return pane;
    }

    @EventStation
    public String id() {
        return MODULE_ID;
    }

    @EventListener
    public void onClearModule(ClearModuleEvent e) {
        if (e.clearEverything) {
            this.mergeOptions.resetView();
            this.destinationPane.resetView();
        }
    }

    public Node graphic() {
        return new ImageView("merge.png");
    }

    @Components(value={MergeModule.class})
    public static class ModuleConfig {
        @Provides
        @Named(value="mergefield")
        public BrowsablePdfOutputField destinationFileField() {
            return new BrowsablePdfOutputField();
        }

        @Provides
        @Named(value="mergepane")
        public PdfDestinationPane destinationPane(@Named(value="mergefield") BrowsablePdfOutputField outputField, UserContext userContext) {
            return new PdfDestinationPane((BrowsableField)outputField, MergeModule.MODULE_ID, userContext, new PdfDestinationPane.DestinationPanelFields[0]);
        }

        @Provides
        @Named(value="mergefooter")
        public Footer footer(RunButton runButton, @Named(value="mergeopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, MergeModule.MODULE_ID);
        }

        @Provides
        @Named(value="mergeopenButton")
        public OpenButton openButton() {
            return new OpenButton(MergeModule.MODULE_ID, ModuleInputOutputType.SINGLE_PDF);
        }
    }
}

