import { ILogger } from "./ILogger";
export declare class LogService {
    private static logger;
    private constructor();
    /**
     * Sets a new logger for the Log Service
     * @param {ILogger} logger the new logger
     */
    static setLogger(logger: ILogger): void;
    /**
     * Logs to the DEBUG channel
     * @param {string} module The module being logged
     * @param {*[]} messageOrObject The data to log
     */
    static debug(module: string, ...messageOrObject: any[]): void;
    /**
     * Logs to the ERROR channel
     * @param {string} module The module being logged
     * @param {*[]} messageOrObject The data to log
     */
    static error(module: string, ...messageOrObject: any[]): void;
    /**
     * Logs to the INFO channel
     * @param {string} module The module being logged
     * @param {*[]} messageOrObject The data to log
     */
    static info(module: string, ...messageOrObject: any[]): void;
    /**
     * Logs to the WARN channel
     * @param {string} module The module being logged
     * @param {*[]} messageOrObject The data to log
     */
    static warn(module: string, ...messageOrObject: any[]): void;
}
