/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.exceptions;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.MessageUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import java.util.Optional;

public class BeanInstantiationException
extends BeanContextException {
    private final BeanType rootBeanType;

    public BeanInstantiationException(String message, Throwable cause) {
        super(message, cause);
        this.rootBeanType = null;
    }

    public BeanInstantiationException(String message) {
        super(message);
        this.rootBeanType = null;
    }

    public BeanInstantiationException(BeanResolutionContext resolutionContext, Throwable cause) {
        super(MessageUtils.buildMessage(resolutionContext, cause.getMessage()), cause);
        this.rootBeanType = this.resolveRootBeanDefinition(resolutionContext);
    }

    public BeanInstantiationException(BeanResolutionContext resolutionContext, String message) {
        super(MessageUtils.buildMessage(resolutionContext, message));
        this.rootBeanType = this.resolveRootBeanDefinition(resolutionContext);
    }

    public <T> BeanInstantiationException(BeanType<T> beanDefinition, Throwable cause) {
        super("Error instantiating bean of type [" + beanDefinition.getName() + "]: " + cause.getMessage(), cause);
        this.rootBeanType = beanDefinition;
    }

    public <T> BeanInstantiationException(BeanType<T> beanDefinition, String message) {
        super("Error instantiating bean of type [" + beanDefinition.getName() + "]: " + message);
        this.rootBeanType = beanDefinition;
    }

    public Optional<BeanType> getRootBeanType() {
        return Optional.ofNullable(this.rootBeanType);
    }

    private BeanType resolveRootBeanDefinition(BeanResolutionContext resolutionContext) {
        BeanDefinition rootBeanType = null;
        if (resolutionContext != null) {
            BeanResolutionContext.Path path = resolutionContext.getPath();
            if (!path.isEmpty()) {
                BeanResolutionContext.Segment segment = (BeanResolutionContext.Segment)path.peek();
                rootBeanType = segment.getDeclaringType();
            } else {
                rootBeanType = resolutionContext.getRootDefinition();
            }
        }
        return rootBeanType;
    }
}

