/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;

public class AvailableColumnsModel {
    private static final int MAX_AVAILABLE_COLUMNS = 20;
    private final Set<Column> availableColumns = new HashSet<Column>();
    private final Set<Column> allKnownColumns = new HashSet<Column>();
    private final Table table;

    public AvailableColumnsModel(Table table) {
        this.table = table;
    }

    public boolean isColumnAvailable(Column column) {
        return this.availableColumns.contains(column);
    }

    public synchronized boolean addAvailableColumn(Column column) {
        if (this.canAddAvailableColumn()) {
            if (!this.availableColumns.contains(column)) {
                this.availableColumns.add(column);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean removeAvailableColumn(Column column) {
        return this.availableColumns.remove(column);
    }

    public synchronized void removeAllColumns() {
        this.availableColumns.clear();
    }

    public boolean canAddAvailableColumn() {
        return this.availableColumns.size() < 20;
    }

    public Column[] getAvailableColumns() {
        ArrayList<Column> availableColumnsList = new ArrayList<Column>();
        for (Column column : this.table) {
            if (!this.availableColumns.contains(column)) continue;
            availableColumnsList.add(column);
        }
        return availableColumnsList.toArray(new Column[0]);
    }

    public int getAvailableColumnsCount() {
        return this.availableColumns.size();
    }

    public synchronized void syncronizeTableColumns() {
        HashSet<Column> availableColumnsCopy = new HashSet<Column>(this.availableColumns);
        this.removeAllColumns();
        for (Column column : this.table) {
            if (!availableColumnsCopy.contains(column) && this.allKnownColumns.contains(column)) continue;
            this.allKnownColumns.add(column);
            this.addAvailableColumn(column);
        }
    }
}

