/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.emf.workbench;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;

public class WorkbenchURIConverterImpl
extends URIConverterImpl
implements WorkbenchURIConverter {
    private static final IWorkspaceRoot WORKSPACE_ROOT = URIConverterImpl.workspaceRoot;
    private static final String WORKSPACE_ROOT_LOCATION = WORKSPACE_ROOT.getLocation().toString();
    private static final String FILE_PROTOCOL = "file";
    private static final IPath INVALID_PATH = new Path("!!!!~!!!!");
    private static final IFile INVALID_FILE = WORKSPACE_ROOT.getFile(INVALID_PATH.append(INVALID_PATH));
    protected boolean forceSaveRelative = false;
    protected List inputContainers;
    protected IContainer outputContainer;
    protected ResourceSetWorkbenchSynchronizer resourceSetSynchronizer;
    protected static final String METADATA_LOCATION = Platform.getLogFileLocation().removeLastSegments(1).toString();

    public WorkbenchURIConverterImpl() {
    }

    public WorkbenchURIConverterImpl(IContainer anInputContainer) {
        this(anInputContainer, (ResourceSetWorkbenchSynchronizer)null);
    }

    public WorkbenchURIConverterImpl(IContainer aContainer, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        this(aContainer, null, aSynchronizer);
    }

    public WorkbenchURIConverterImpl(IContainer anInputContainer, IContainer anOutputContainer) {
        this(anInputContainer, anOutputContainer, null);
    }

    public WorkbenchURIConverterImpl(IContainer anInputContainer, IContainer anOutputContainer, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        this.addInputContainer(anInputContainer);
        this.setOutputContainer(anOutputContainer);
        this.resourceSetSynchronizer = aSynchronizer;
    }

    public void addInputContainer(IContainer aContainer) {
        if (aContainer != null && !this.getInputContainers().contains(aContainer)) {
            this.getInputContainers().add(aContainer);
        }
    }

    public void addInputContainers(List containers) {
        int i = 0;
        while (i < containers.size()) {
            this.addInputContainer((IContainer)containers.get(i));
            ++i;
        }
    }

    public boolean removeInputContainer(IContainer aContainer) {
        return this.getInputContainers().remove(aContainer);
    }

    public List getInputContainers() {
        if (this.inputContainers == null) {
            this.inputContainers = new ArrayList();
        }
        return this.inputContainers;
    }

    public IContainer getInputContainer() {
        if (!this.getInputContainers().isEmpty()) {
            return (IContainer)this.getInputContainers().get(0);
        }
        return null;
    }

    public IContainer getOutputContainer() {
        if (this.outputContainer == null) {
            this.outputContainer = this.getInputContainer();
        }
        return this.outputContainer;
    }

    public void setOutputContainer(IContainer newOutputContainer) {
        this.outputContainer = newOutputContainer;
    }

    public IFile getOutputFile(IPath aPath) {
        IFile file = null;
        if (this.getOutputContainer() != null) {
            if (this.forceSaveRelative) {
                return this.primGetOutputFile(aPath);
            }
            file = this.getOutputFileForPathWithContainerSegments(aPath);
            if (file != null) {
                return file;
            }
            return this.primGetOutputFile(aPath);
        }
        return file;
    }

    protected IFile primGetOutputFile(IPath aPath) {
        return this.primGetFile(this.getOutputContainer(), aPath);
    }

    protected IFile getOutputFileForPathWithContainerSegments(IPath aPath) {
        IContainer out = this.getOutputContainer();
        return this.getFileForPathWithContainerSegments(aPath, out, false);
    }

    protected IFile getFileForPathWithContainerSegments(IPath aPath, IContainer container, boolean testExists) {
        IPath containerPath = null;
        IFile file = null;
        if (testExists && !(containerPath = container.getProjectRelativePath()).isEmpty() && (file = this.getFileForMatchingPath(aPath, containerPath, container)) != null && file.exists()) {
            return file;
        }
        containerPath = container.getFullPath();
        file = this.getFileForMatchingPath(aPath, containerPath, container);
        return file;
    }

    protected IFile getFileForMatchingPath(IPath containerPath, IPath sourcePath, IContainer container) {
        int matches = 0;
        matches = containerPath.matchingFirstSegments(sourcePath);
        if (matches > 0 && matches == sourcePath.segmentCount()) {
            IPath loadPath = containerPath.removeFirstSegments(matches);
            return this.primGetFile(container, loadPath);
        }
        return null;
    }

    public IFile getFile(String uri) {
        return this.getFile((IPath)new Path(uri));
    }

    public IFile getFile(IPath path) {
        IFile file = null;
        if (this.getInputContainer() != null) {
            path = path.makeRelative();
            for (IContainer con : this.getInputContainers()) {
                file = this.getInputFile(con, path);
                if (file == null || !file.exists()) continue;
                return file;
            }
        }
        if (file == null) {
            return INVALID_FILE;
        }
        return file;
    }

    public IFile getOutputFile(String uri) {
        return this.getOutputFile((IPath)new Path(uri));
    }

    public IFile getInputFile(IContainer con, IPath path) {
        IFile file = null;
        if (WORKSPACE_ROOT.equals((Object)con) && path.segmentCount() < 2) {
            path = INVALID_PATH.append(path);
        }
        if ((file = this.primGetFile(con, path)) == null || !file.exists()) {
            file = this.getFileForPathWithContainerSegments(path, con, true);
        }
        return file;
    }

    protected IFile primGetFile(IContainer container, IPath path) {
        try {
            return container.getFile(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean canGetUnderlyingResource(String aFileName) {
        IFile file = this.getFile(aFileName);
        return file != null && file.exists();
    }

    public boolean isForceSaveRelative() {
        return this.forceSaveRelative;
    }

    public void setForceSaveRelative(boolean forceSaveRelative) {
        this.forceSaveRelative = forceSaveRelative;
    }

    public URI normalize(URI uri) {
        URI result = uri;
        String fragment = null;
        if (uri.hasFragment()) {
            fragment = uri.fragment();
            result = uri.trimFragment();
        }
        if (WorkbenchResourceHelperBase.isPlatformResourceURI(result = this.getInternalURIMap().getURI(result))) {
            return this.appendFragment(result, fragment);
        }
        if (WorkbenchResourceHelperBase.isPlatformPluginResourceURI(result)) {
            URI normalized = this.normalizePluginURI(result, fragment);
            return normalized != null ? normalized : uri;
        }
        String protocol = result.scheme();
        URI fileSearchURI = null;
        if (protocol == null) {
            fileSearchURI = this.normalizeEmptyProtocol(result, fragment);
            if (fileSearchURI != null) {
                return fileSearchURI;
            }
        } else if (FILE_PROTOCOL.equals(protocol)) {
            fileSearchURI = this.normalizeFileProtocol(result, fragment);
            if (fileSearchURI != null) {
                return fileSearchURI;
            }
        } else if ("workspace".equals(protocol)) {
            return this.normalizeWorkspaceProtocol(result, fragment);
        }
        return super.normalize(uri);
    }

    protected URI normalizePluginURI(URI uri, String fragment) {
        if (uri.segmentCount() < 2) {
            return uri;
        }
        int u_scoreNdx = uri.segment(1).lastIndexOf(95);
        if (u_scoreNdx != -1) {
            String[] segments = uri.segments();
            segments[1] = segments[1].substring(0, u_scoreNdx);
            return URI.createHierarchicalURI((String)uri.scheme(), (String)uri.authority(), (String)uri.device(), (String[])segments, (String)uri.query(), (String)fragment);
        }
        return uri;
    }

    protected URI normalizeWorkspaceProtocol(URI aWorkspaceURI, String fragment) {
        String uriString = aWorkspaceURI.toString();
        uriString = uriString.substring("workspace".length() + 1);
        URI result = URI.createPlatformResourceURI((String)uriString);
        if (fragment != null) {
            result = this.appendFragment(aWorkspaceURI, fragment);
        }
        return result;
    }

    protected URI normalizeEmptyProtocol(URI aFileUri, String fragment) {
        Path path = new Path(aFileUri.toString());
        return this.normalizeToWorkspaceURI((IPath)path, fragment);
    }

    private URI normalizeToWorkspaceURI(IPath path, String fragment) {
        URI result = null;
        IFile file = this.getFile(path);
        if (file == null || !file.exists()) {
            file = this.getOutputFile(path);
        }
        if (file != null) {
            result = URI.createPlatformResourceURI((String)file.getFullPath().toString());
            result = this.appendFragment(result, fragment);
        }
        return result;
    }

    protected URI normalizeFileProtocol(URI aFileUri, String fragment) {
        URI result = null;
        String devicePath = aFileUri.devicePath();
        result = !devicePath.startsWith(METADATA_LOCATION) && devicePath.startsWith(WORKSPACE_ROOT_LOCATION) && devicePath.length() > WORKSPACE_ROOT_LOCATION.length() ? this.normalizeToWorkspaceURI((IPath)new Path(devicePath.substring(WORKSPACE_ROOT_LOCATION.length())), fragment) : (aFileUri.isRelative() ? this.normalizeToWorkspaceURI((IPath)new Path(aFileUri.toString()), fragment) : aFileUri);
        return result;
    }

    protected URI appendFragment(URI result, String fragment) {
        if (fragment != null) {
            return result.appendFragment(fragment);
        }
        return result;
    }

    public IFile getOutputFileWithMappingApplied(String uri) {
        URI converted = this.getInternalURIMap().getURI(URI.createURI((String)uri));
        return this.getOutputFile((IPath)new Path(converted.toString()));
    }

    public OutputStream createPlatformResourceOutputStream(String platformResourcePath) throws IOException {
        IFile file = WORKSPACE_ROOT.getFile((IPath)new Path(platformResourcePath));
        ProjectUtilities.ensureContainerNotReadOnly((IResource)file);
        return new WorkbenchByteArrayOutputStream(file, this.resourceSetSynchronizer);
    }

    protected URI getContainerRelativeURI(IFile aFile) {
        IPath path = WorkbenchResourceHelperBase.getPathFromContainers(this.inputContainers, aFile.getFullPath());
        if (path != null) {
            return URI.createURI((String)path.toString());
        }
        return null;
    }

    public InputStream createPlatformResourceInputStream(String platformResourcePath) throws IOException {
        IFile file = WORKSPACE_ROOT.getFile((IPath)new Path(platformResourcePath));
        try {
            block6: {
                if (!file.isSynchronized(1)) {
                    try {
                        File iofile = file.getFullPath().toFile();
                        if (iofile.exists() || file.exists()) {
                            file.refreshLocal(1, null);
                        }
                    }
                    catch (CoreException ce) {
                        if (ce.getStatus().getCode() == 380) break block6;
                        throw ce;
                    }
                }
            }
            return file.getContents(true);
        }
        catch (CoreException exception) {
            throw new Resource.IOWrappedException((Exception)((Object)exception));
        }
    }
}

