/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.internal.StartParameterInternal;

public class BuildLayoutConfiguration {
    private File currentDir;
    private boolean searchUpwards;
    private final File settingsFile;
    private final boolean useEmptySettings;

    public BuildLayoutConfiguration(StartParameter startParameter) {
        this.currentDir = startParameter.getCurrentDir();
        this.searchUpwards = ((StartParameterInternal)startParameter).isSearchUpwardsWithoutDeprecationWarning() && !this.isInitTaskRequested(startParameter);
        this.settingsFile = startParameter.getSettingsFile();
        this.useEmptySettings = ((StartParameterInternal)startParameter).isUseEmptySettingsWithoutDeprecationWarning();
    }

    private boolean isInitTaskRequested(StartParameter startParameter) {
        if (startParameter.getTaskNames().contains("init")) {
            return true;
        }
        for (TaskExecutionRequest request : startParameter.getTaskRequests()) {
            if (!request.getArgs().contains("init")) continue;
            return true;
        }
        return false;
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public boolean isSearchUpwards() {
        return this.searchUpwards;
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    public boolean isUseEmptySettings() {
        return this.useEmptySettings;
    }
}

