"use strict";
/**
 * <p>See <a href="http://raml.org">http://raml.org</a> for more information about RAML.</p>
 *
 * <p>This parser is at a beta state of development, as part of the API Workbench development cycle (<a href="http://apiworkbench.com">http://apiworkbench.com</a>).</p>
 *
 * <p><a href="https://github.com/raml-org/raml-js-parser-2/blob/master/documentation/GettingStarted.md">Getting Started Guide</a> describes the first steps with the parser.</p>
 *
 * <h2>Installation</h2>
 *
 * <pre><code>git clone https://github.com/raml-org/raml-js-parser-2
 *
 * cd raml-js-parser-2
 *
 * npm install
 *
 * node test/test.js  //here you should observe JSON representation of XKCD API in your console
 *
 * node test/testAsync.js  //same as above but in asynchronous mode
 * </code></pre>
 *
 * <h2>Usage</h2>
 *
 * <ul>
 * <li>For parser usage example refer to <code>test/test.js</code></li>
 * <li>For asynchrounous usage example refer to <code>test/testAsync.js</code></li>
 * </ul>
 **/
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Custom type guard for Api. Returns true if node is instance of Api. Returns false otherwise.
 * Also returns false for super interfaces of Api.
 */
function isApi(node) {
    return node.kind() == "Api" && node.RAMLVersion() == "RAML10";
}
exports.isApi = isApi;
/**
 * Custom type guard for LibraryBase. Returns true if node is instance of LibraryBase. Returns false otherwise.
 * Also returns false for super interfaces of LibraryBase.
 */
function isLibraryBase(node) {
    return node.kind() == "LibraryBase" && node.RAMLVersion() == "RAML10";
}
exports.isLibraryBase = isLibraryBase;
/**
 * Custom type guard for Annotable. Returns true if node is instance of Annotable. Returns false otherwise.
 * Also returns false for super interfaces of Annotable.
 */
function isAnnotable(node) {
    return node.kind() == "Annotable" && node.RAMLVersion() == "RAML10";
}
exports.isAnnotable = isAnnotable;
/**
 * Custom type guard for AnnotationRef. Returns true if node is instance of AnnotationRef. Returns false otherwise.
 * Also returns false for super interfaces of AnnotationRef.
 */
function isAnnotationRef(node) {
    return node.kind() == "AnnotationRef" && node.RAMLVersion() == "RAML10";
}
exports.isAnnotationRef = isAnnotationRef;
/**
 * Custom type guard for Reference. Returns true if node is instance of Reference. Returns false otherwise.
 * Also returns false for super interfaces of Reference.
 */
function isReference(node) {
    return node.kind() == "Reference" && node.RAMLVersion() == "RAML10";
}
exports.isReference = isReference;
/**
 * Custom type guard for ValueType. Returns true if node is instance of ValueType. Returns false otherwise.
 * Also returns false for super interfaces of ValueType.
 */
function isValueType(node) {
    return node.kind() == "ValueType" && node.RAMLVersion() == "RAML10";
}
exports.isValueType = isValueType;
/**
 * Custom type guard for StringType. Returns true if node is instance of StringType. Returns false otherwise.
 * Also returns false for super interfaces of StringType.
 */
function isStringType(node) {
    return node.kind() == "StringType" && node.RAMLVersion() == "RAML10";
}
exports.isStringType = isStringType;
/**
 * Custom type guard for UriTemplate. Returns true if node is instance of UriTemplate. Returns false otherwise.
 * Also returns false for super interfaces of UriTemplate.
 */
function isUriTemplate(node) {
    return node.kind() == "UriTemplate" && node.RAMLVersion() == "RAML10";
}
exports.isUriTemplate = isUriTemplate;
/**
 * Custom type guard for RelativeUriString. Returns true if node is instance of RelativeUriString. Returns false otherwise.
 * Also returns false for super interfaces of RelativeUriString.
 */
function isRelativeUriString(node) {
    return node.kind() == "RelativeUriString" && node.RAMLVersion() == "RAML10";
}
exports.isRelativeUriString = isRelativeUriString;
/**
 * Custom type guard for FullUriTemplateString. Returns true if node is instance of FullUriTemplateString. Returns false otherwise.
 * Also returns false for super interfaces of FullUriTemplateString.
 */
function isFullUriTemplateString(node) {
    return node.kind() == "FullUriTemplateString" && node.RAMLVersion() == "RAML10";
}
exports.isFullUriTemplateString = isFullUriTemplateString;
/**
 * Custom type guard for StatusCodeString. Returns true if node is instance of StatusCodeString. Returns false otherwise.
 * Also returns false for super interfaces of StatusCodeString.
 */
function isStatusCodeString(node) {
    return node.kind() == "StatusCodeString" && node.RAMLVersion() == "RAML10";
}
exports.isStatusCodeString = isStatusCodeString;
/**
 * Custom type guard for FixedUriString. Returns true if node is instance of FixedUriString. Returns false otherwise.
 * Also returns false for super interfaces of FixedUriString.
 */
function isFixedUriString(node) {
    return node.kind() == "FixedUriString" && node.RAMLVersion() == "RAML10";
}
exports.isFixedUriString = isFixedUriString;
/**
 * Custom type guard for ContentType. Returns true if node is instance of ContentType. Returns false otherwise.
 * Also returns false for super interfaces of ContentType.
 */
function isContentType(node) {
    return node.kind() == "ContentType" && node.RAMLVersion() == "RAML10";
}
exports.isContentType = isContentType;
/**
 * Custom type guard for MarkdownString. Returns true if node is instance of MarkdownString. Returns false otherwise.
 * Also returns false for super interfaces of MarkdownString.
 */
function isMarkdownString(node) {
    return node.kind() == "MarkdownString" && node.RAMLVersion() == "RAML10";
}
exports.isMarkdownString = isMarkdownString;
/**
 * Custom type guard for SchemaString. Returns true if node is instance of SchemaString. Returns false otherwise.
 * Also returns false for super interfaces of SchemaString.
 */
function isSchemaString(node) {
    return node.kind() == "SchemaString" && node.RAMLVersion() == "RAML10";
}
exports.isSchemaString = isSchemaString;
/**
 * Custom type guard for MimeType. Returns true if node is instance of MimeType. Returns false otherwise.
 * Also returns false for super interfaces of MimeType.
 */
function isMimeType(node) {
    return node.kind() == "MimeType" && node.RAMLVersion() == "RAML10";
}
exports.isMimeType = isMimeType;
/**
 * Custom type guard for AnyType. Returns true if node is instance of AnyType. Returns false otherwise.
 * Also returns false for super interfaces of AnyType.
 */
function isAnyType(node) {
    return node.kind() == "AnyType" && node.RAMLVersion() == "RAML10";
}
exports.isAnyType = isAnyType;
/**
 * Custom type guard for NumberType. Returns true if node is instance of NumberType. Returns false otherwise.
 * Also returns false for super interfaces of NumberType.
 */
function isNumberType(node) {
    return node.kind() == "NumberType" && node.RAMLVersion() == "RAML10";
}
exports.isNumberType = isNumberType;
/**
 * Custom type guard for IntegerType. Returns true if node is instance of IntegerType. Returns false otherwise.
 * Also returns false for super interfaces of IntegerType.
 */
function isIntegerType(node) {
    return node.kind() == "IntegerType" && node.RAMLVersion() == "RAML10";
}
exports.isIntegerType = isIntegerType;
/**
 * Custom type guard for NullType. Returns true if node is instance of NullType. Returns false otherwise.
 * Also returns false for super interfaces of NullType.
 */
function isNullType(node) {
    return node.kind() == "NullType" && node.RAMLVersion() == "RAML10";
}
exports.isNullType = isNullType;
/**
 * Custom type guard for TimeOnlyType. Returns true if node is instance of TimeOnlyType. Returns false otherwise.
 * Also returns false for super interfaces of TimeOnlyType.
 */
function isTimeOnlyType(node) {
    return node.kind() == "TimeOnlyType" && node.RAMLVersion() == "RAML10";
}
exports.isTimeOnlyType = isTimeOnlyType;
/**
 * Custom type guard for DateOnlyType. Returns true if node is instance of DateOnlyType. Returns false otherwise.
 * Also returns false for super interfaces of DateOnlyType.
 */
function isDateOnlyType(node) {
    return node.kind() == "DateOnlyType" && node.RAMLVersion() == "RAML10";
}
exports.isDateOnlyType = isDateOnlyType;
/**
 * Custom type guard for DateTimeOnlyType. Returns true if node is instance of DateTimeOnlyType. Returns false otherwise.
 * Also returns false for super interfaces of DateTimeOnlyType.
 */
function isDateTimeOnlyType(node) {
    return node.kind() == "DateTimeOnlyType" && node.RAMLVersion() == "RAML10";
}
exports.isDateTimeOnlyType = isDateTimeOnlyType;
/**
 * Custom type guard for DateTimeType. Returns true if node is instance of DateTimeType. Returns false otherwise.
 * Also returns false for super interfaces of DateTimeType.
 */
function isDateTimeType(node) {
    return node.kind() == "DateTimeType" && node.RAMLVersion() == "RAML10";
}
exports.isDateTimeType = isDateTimeType;
/**
 * Custom type guard for FileType. Returns true if node is instance of FileType. Returns false otherwise.
 * Also returns false for super interfaces of FileType.
 */
function isFileType(node) {
    return node.kind() == "FileType" && node.RAMLVersion() == "RAML10";
}
exports.isFileType = isFileType;
/**
 * Custom type guard for BooleanType. Returns true if node is instance of BooleanType. Returns false otherwise.
 * Also returns false for super interfaces of BooleanType.
 */
function isBooleanType(node) {
    return node.kind() == "BooleanType" && node.RAMLVersion() == "RAML10";
}
exports.isBooleanType = isBooleanType;
/**
 * Custom type guard for AnnotationTarget. Returns true if node is instance of AnnotationTarget. Returns false otherwise.
 * Also returns false for super interfaces of AnnotationTarget.
 */
function isAnnotationTarget(node) {
    return node.kind() == "AnnotationTarget" && node.RAMLVersion() == "RAML10";
}
exports.isAnnotationTarget = isAnnotationTarget;
/**
 * Custom type guard for TraitRef. Returns true if node is instance of TraitRef. Returns false otherwise.
 * Also returns false for super interfaces of TraitRef.
 */
function isTraitRef(node) {
    return node.kind() == "TraitRef" && node.RAMLVersion() == "RAML10";
}
exports.isTraitRef = isTraitRef;
/**
 * Custom type guard for Trait. Returns true if node is instance of Trait. Returns false otherwise.
 * Also returns false for super interfaces of Trait.
 */
function isTrait(node) {
    return node.kind() == "Trait" && node.RAMLVersion() == "RAML10";
}
exports.isTrait = isTrait;
/**
 * Custom type guard for MethodBase. Returns true if node is instance of MethodBase. Returns false otherwise.
 * Also returns false for super interfaces of MethodBase.
 */
function isMethodBase(node) {
    return node.kind() == "MethodBase" && node.RAMLVersion() == "RAML10";
}
exports.isMethodBase = isMethodBase;
/**
 * Custom type guard for Operation. Returns true if node is instance of Operation. Returns false otherwise.
 * Also returns false for super interfaces of Operation.
 */
function isOperation(node) {
    return node.kind() == "Operation" && node.RAMLVersion() == "RAML10";
}
exports.isOperation = isOperation;
/**
 * Custom type guard for TypeDeclaration. Returns true if node is instance of TypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of TypeDeclaration.
 */
function isTypeDeclaration(node) {
    return node.kind() == "TypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isTypeDeclaration = isTypeDeclaration;
/**
 * Custom type guard for ModelLocation. Returns true if node is instance of ModelLocation. Returns false otherwise.
 * Also returns false for super interfaces of ModelLocation.
 */
function isModelLocation(node) {
    return node.kind() == "ModelLocation" && node.RAMLVersion() == "RAML10";
}
exports.isModelLocation = isModelLocation;
/**
 * Custom type guard for LocationKind. Returns true if node is instance of LocationKind. Returns false otherwise.
 * Also returns false for super interfaces of LocationKind.
 */
function isLocationKind(node) {
    return node.kind() == "LocationKind" && node.RAMLVersion() == "RAML10";
}
exports.isLocationKind = isLocationKind;
/**
 * Custom type guard for ExampleSpec. Returns true if node is instance of ExampleSpec. Returns false otherwise.
 * Also returns false for super interfaces of ExampleSpec.
 */
function isExampleSpec(node) {
    return node.kind() == "ExampleSpec" && node.RAMLVersion() == "RAML10";
}
exports.isExampleSpec = isExampleSpec;
/**
 * Custom type guard for UsesDeclaration. Returns true if node is instance of UsesDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of UsesDeclaration.
 */
function isUsesDeclaration(node) {
    return node.kind() == "UsesDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isUsesDeclaration = isUsesDeclaration;
/**
 * Custom type guard for XMLFacetInfo. Returns true if node is instance of XMLFacetInfo. Returns false otherwise.
 * Also returns false for super interfaces of XMLFacetInfo.
 */
function isXMLFacetInfo(node) {
    return node.kind() == "XMLFacetInfo" && node.RAMLVersion() == "RAML10";
}
exports.isXMLFacetInfo = isXMLFacetInfo;
/**
 * Custom type guard for ArrayTypeDeclaration. Returns true if node is instance of ArrayTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of ArrayTypeDeclaration.
 */
function isArrayTypeDeclaration(node) {
    return node.kind() == "ArrayTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isArrayTypeDeclaration = isArrayTypeDeclaration;
/**
 * Custom type guard for UnionTypeDeclaration. Returns true if node is instance of UnionTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of UnionTypeDeclaration.
 */
function isUnionTypeDeclaration(node) {
    return node.kind() == "UnionTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isUnionTypeDeclaration = isUnionTypeDeclaration;
/**
 * Custom type guard for ObjectTypeDeclaration. Returns true if node is instance of ObjectTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of ObjectTypeDeclaration.
 */
function isObjectTypeDeclaration(node) {
    return node.kind() == "ObjectTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isObjectTypeDeclaration = isObjectTypeDeclaration;
/**
 * Custom type guard for StringTypeDeclaration. Returns true if node is instance of StringTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of StringTypeDeclaration.
 */
function isStringTypeDeclaration(node) {
    return node.kind() == "StringTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isStringTypeDeclaration = isStringTypeDeclaration;
/**
 * Custom type guard for BooleanTypeDeclaration. Returns true if node is instance of BooleanTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of BooleanTypeDeclaration.
 */
function isBooleanTypeDeclaration(node) {
    return node.kind() == "BooleanTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isBooleanTypeDeclaration = isBooleanTypeDeclaration;
/**
 * Custom type guard for NumberTypeDeclaration. Returns true if node is instance of NumberTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of NumberTypeDeclaration.
 */
function isNumberTypeDeclaration(node) {
    return node.kind() == "NumberTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isNumberTypeDeclaration = isNumberTypeDeclaration;
/**
 * Custom type guard for IntegerTypeDeclaration. Returns true if node is instance of IntegerTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of IntegerTypeDeclaration.
 */
function isIntegerTypeDeclaration(node) {
    return node.kind() == "IntegerTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isIntegerTypeDeclaration = isIntegerTypeDeclaration;
/**
 * Custom type guard for DateOnlyTypeDeclaration. Returns true if node is instance of DateOnlyTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of DateOnlyTypeDeclaration.
 */
function isDateOnlyTypeDeclaration(node) {
    return node.kind() == "DateOnlyTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isDateOnlyTypeDeclaration = isDateOnlyTypeDeclaration;
/**
 * Custom type guard for TimeOnlyTypeDeclaration. Returns true if node is instance of TimeOnlyTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of TimeOnlyTypeDeclaration.
 */
function isTimeOnlyTypeDeclaration(node) {
    return node.kind() == "TimeOnlyTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isTimeOnlyTypeDeclaration = isTimeOnlyTypeDeclaration;
/**
 * Custom type guard for DateTimeOnlyTypeDeclaration. Returns true if node is instance of DateTimeOnlyTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of DateTimeOnlyTypeDeclaration.
 */
function isDateTimeOnlyTypeDeclaration(node) {
    return node.kind() == "DateTimeOnlyTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isDateTimeOnlyTypeDeclaration = isDateTimeOnlyTypeDeclaration;
/**
 * Custom type guard for DateTimeTypeDeclaration. Returns true if node is instance of DateTimeTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of DateTimeTypeDeclaration.
 */
function isDateTimeTypeDeclaration(node) {
    return node.kind() == "DateTimeTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isDateTimeTypeDeclaration = isDateTimeTypeDeclaration;
/**
 * Custom type guard for FileTypeDeclaration. Returns true if node is instance of FileTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of FileTypeDeclaration.
 */
function isFileTypeDeclaration(node) {
    return node.kind() == "FileTypeDeclaration" && node.RAMLVersion() == "RAML10";
}
exports.isFileTypeDeclaration = isFileTypeDeclaration;
/**
 * Custom type guard for Response. Returns true if node is instance of Response. Returns false otherwise.
 * Also returns false for super interfaces of Response.
 */
function isResponse(node) {
    return node.kind() == "Response" && node.RAMLVersion() == "RAML10";
}
exports.isResponse = isResponse;
/**
 * Custom type guard for SecuritySchemePart. Returns true if node is instance of SecuritySchemePart. Returns false otherwise.
 * Also returns false for super interfaces of SecuritySchemePart.
 */
function isSecuritySchemePart(node) {
    return node.kind() == "SecuritySchemePart" && node.RAMLVersion() == "RAML10";
}
exports.isSecuritySchemePart = isSecuritySchemePart;
/**
 * Custom type guard for SecuritySchemeRef. Returns true if node is instance of SecuritySchemeRef. Returns false otherwise.
 * Also returns false for super interfaces of SecuritySchemeRef.
 */
function isSecuritySchemeRef(node) {
    return node.kind() == "SecuritySchemeRef" && node.RAMLVersion() == "RAML10";
}
exports.isSecuritySchemeRef = isSecuritySchemeRef;
/**
 * Custom type guard for AbstractSecurityScheme. Returns true if node is instance of AbstractSecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of AbstractSecurityScheme.
 */
function isAbstractSecurityScheme(node) {
    return node.kind() == "AbstractSecurityScheme" && node.RAMLVersion() == "RAML10";
}
exports.isAbstractSecurityScheme = isAbstractSecurityScheme;
/**
 * Custom type guard for SecuritySchemeSettings. Returns true if node is instance of SecuritySchemeSettings. Returns false otherwise.
 * Also returns false for super interfaces of SecuritySchemeSettings.
 */
function isSecuritySchemeSettings(node) {
    return node.kind() == "SecuritySchemeSettings" && node.RAMLVersion() == "RAML10";
}
exports.isSecuritySchemeSettings = isSecuritySchemeSettings;
/**
 * Custom type guard for OAuth1SecuritySchemeSettings. Returns true if node is instance of OAuth1SecuritySchemeSettings. Returns false otherwise.
 * Also returns false for super interfaces of OAuth1SecuritySchemeSettings.
 */
function isOAuth1SecuritySchemeSettings(node) {
    return node.kind() == "OAuth1SecuritySchemeSettings" && node.RAMLVersion() == "RAML10";
}
exports.isOAuth1SecuritySchemeSettings = isOAuth1SecuritySchemeSettings;
/**
 * Custom type guard for OAuth2SecuritySchemeSettings. Returns true if node is instance of OAuth2SecuritySchemeSettings. Returns false otherwise.
 * Also returns false for super interfaces of OAuth2SecuritySchemeSettings.
 */
function isOAuth2SecuritySchemeSettings(node) {
    return node.kind() == "OAuth2SecuritySchemeSettings" && node.RAMLVersion() == "RAML10";
}
exports.isOAuth2SecuritySchemeSettings = isOAuth2SecuritySchemeSettings;
/**
 * Custom type guard for OAuth2SecurityScheme. Returns true if node is instance of OAuth2SecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of OAuth2SecurityScheme.
 */
function isOAuth2SecurityScheme(node) {
    return node.kind() == "OAuth2SecurityScheme" && node.RAMLVersion() == "RAML10";
}
exports.isOAuth2SecurityScheme = isOAuth2SecurityScheme;
/**
 * Custom type guard for OAuth1SecurityScheme. Returns true if node is instance of OAuth1SecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of OAuth1SecurityScheme.
 */
function isOAuth1SecurityScheme(node) {
    return node.kind() == "OAuth1SecurityScheme" && node.RAMLVersion() == "RAML10";
}
exports.isOAuth1SecurityScheme = isOAuth1SecurityScheme;
/**
 * Custom type guard for PassThroughSecurityScheme. Returns true if node is instance of PassThroughSecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of PassThroughSecurityScheme.
 */
function isPassThroughSecurityScheme(node) {
    return node.kind() == "PassThroughSecurityScheme" && node.RAMLVersion() == "RAML10";
}
exports.isPassThroughSecurityScheme = isPassThroughSecurityScheme;
/**
 * Custom type guard for BasicSecurityScheme. Returns true if node is instance of BasicSecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of BasicSecurityScheme.
 */
function isBasicSecurityScheme(node) {
    return node.kind() == "BasicSecurityScheme" && node.RAMLVersion() == "RAML10";
}
exports.isBasicSecurityScheme = isBasicSecurityScheme;
/**
 * Custom type guard for DigestSecurityScheme. Returns true if node is instance of DigestSecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of DigestSecurityScheme.
 */
function isDigestSecurityScheme(node) {
    return node.kind() == "DigestSecurityScheme" && node.RAMLVersion() == "RAML10";
}
exports.isDigestSecurityScheme = isDigestSecurityScheme;
/**
 * Custom type guard for CustomSecurityScheme. Returns true if node is instance of CustomSecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of CustomSecurityScheme.
 */
function isCustomSecurityScheme(node) {
    return node.kind() == "CustomSecurityScheme" && node.RAMLVersion() == "RAML10";
}
exports.isCustomSecurityScheme = isCustomSecurityScheme;
/**
 * Custom type guard for Method. Returns true if node is instance of Method. Returns false otherwise.
 * Also returns false for super interfaces of Method.
 */
function isMethod(node) {
    return node.kind() == "Method" && node.RAMLVersion() == "RAML10";
}
exports.isMethod = isMethod;
/**
 * Custom type guard for ResourceTypeRef. Returns true if node is instance of ResourceTypeRef. Returns false otherwise.
 * Also returns false for super interfaces of ResourceTypeRef.
 */
function isResourceTypeRef(node) {
    return node.kind() == "ResourceTypeRef" && node.RAMLVersion() == "RAML10";
}
exports.isResourceTypeRef = isResourceTypeRef;
/**
 * Custom type guard for ResourceType. Returns true if node is instance of ResourceType. Returns false otherwise.
 * Also returns false for super interfaces of ResourceType.
 */
function isResourceType(node) {
    return node.kind() == "ResourceType" && node.RAMLVersion() == "RAML10";
}
exports.isResourceType = isResourceType;
/**
 * Custom type guard for ResourceBase. Returns true if node is instance of ResourceBase. Returns false otherwise.
 * Also returns false for super interfaces of ResourceBase.
 */
function isResourceBase(node) {
    return node.kind() == "ResourceBase" && node.RAMLVersion() == "RAML10";
}
exports.isResourceBase = isResourceBase;
/**
 * Custom type guard for Resource. Returns true if node is instance of Resource. Returns false otherwise.
 * Also returns false for super interfaces of Resource.
 */
function isResource(node) {
    return node.kind() == "Resource" && node.RAMLVersion() == "RAML10";
}
exports.isResource = isResource;
/**
 * Custom type guard for DocumentationItem. Returns true if node is instance of DocumentationItem. Returns false otherwise.
 * Also returns false for super interfaces of DocumentationItem.
 */
function isDocumentationItem(node) {
    return node.kind() == "DocumentationItem" && node.RAMLVersion() == "RAML10";
}
exports.isDocumentationItem = isDocumentationItem;
/**
 * Custom type guard for Library. Returns true if node is instance of Library. Returns false otherwise.
 * Also returns false for super interfaces of Library.
 */
function isLibrary(node) {
    return node.kind() == "Library" && node.RAMLVersion() == "RAML10";
}
exports.isLibrary = isLibrary;
/**
 * Custom type guard for Overlay. Returns true if node is instance of Overlay. Returns false otherwise.
 * Also returns false for super interfaces of Overlay.
 */
function isOverlay(node) {
    return node.kind() == "Overlay" && node.RAMLVersion() == "RAML10";
}
exports.isOverlay = isOverlay;
/**
 * Custom type guard for Extension. Returns true if node is instance of Extension. Returns false otherwise.
 * Also returns false for super interfaces of Extension.
 */
function isExtension(node) {
    return node.kind() == "Extension" && node.RAMLVersion() == "RAML10";
}
exports.isExtension = isExtension;
/**
 * Check if the AST node represents fragment
 */
function isFragment(node) {
    return node.highLevel().parent() == null;
}
exports.isFragment = isFragment;
/**
 * Convert fragment representing node to FragmentDeclaration instance.
 */
function asFragment(node) {
    return isFragment(node) ? node : null;
}
exports.asFragment = asFragment;
//# sourceMappingURL=raml10parserapi.js.map