/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import gps.convert.ExternalUtils;
import gps.log.GPSRecord;

public final class CommonIn {
    private static final double KNOT_PER_KMH = 1.852;

    private static final void setTime(GPSRecord gPSRecord, int n) {
        gPSRecord.utc = n = gPSRecord.utc - gPSRecord.utc % 86400 + n;
    }

    private static final void setDate(GPSRecord gPSRecord, int n) {
        gPSRecord.utc = n = gPSRecord.utc % 86400 + n;
    }

    private static final boolean setTime(GPSRecord gPSRecord, String string) {
        try {
            int n = JavaLibBridge.toInt(string.substring(0, 2)) * 3600 + JavaLibBridge.toInt(string.substring(2, 4)) * 60 + JavaLibBridge.toInt(string.substring(4, 6));
            CommonIn.setTime(gPSRecord, n);
            if (string.charAt(6) == '.') {
                gPSRecord.milisecond = (int)(JavaLibBridge.toFloat(string.substring(6)) * 1000.0f);
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private static final void setDate(GPSRecord gPSRecord, String string) {
        int n = JavaLibBridge.toInt(string);
        int n2 = n / 10000;
        int n3 = n / 100 % 100;
        n = n % 100 + (n % 100 >= 70 ? 1900 : 2000);
        CommonIn.setDate(gPSRecord, JavaLibBridge.getDateInstance(n2, n3, n).dateToUTCepoch1970());
    }

    private static final void setLatitude(GPSRecord gPSRecord, String string, String string2) {
        gPSRecord.latitude = (JavaLibBridge.toDouble(string.substring(0, 2)) + JavaLibBridge.toDouble(string.substring(2)) / 60.0) * (double)(string2.equals("N") ? 1 : -1);
    }

    private static final void setLongitude(GPSRecord gPSRecord, String string, String string2) {
        gPSRecord.longitude = (JavaLibBridge.toDouble(string.substring(0, 3)) + JavaLibBridge.toDouble(string.substring(3)) / 60.0) * (double)(string2.equals("E") ? 1 : -1);
    }

    public static final int analyzeNMEA(String[] stringArray, GPSRecord gPSRecord) {
        int n = CommonIn.analyzeGPGGA(stringArray, gPSRecord);
        if (n != 0) {
            return n;
        }
        n = CommonIn.analyzeGPRMC(stringArray, gPSRecord);
        if (n != 0) {
            return n;
        }
        n = CommonIn.analyzeGPGSV(stringArray, gPSRecord);
        if (n != 0) {
            return n;
        }
        return n;
    }

    public static final int analyzeGPRMC(String[] stringArray, GPSRecord gPSRecord) {
        int n = 0;
        if ((stringArray[0].equals("GPRMC") || stringArray[0].equals("GNRMC")) && stringArray.length >= 10) {
            try {
                if (stringArray[1].length() != 0) {
                    if (CommonIn.setTime(gPSRecord, stringArray[1])) {
                        n = 262144;
                    }
                    n |= 1;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPRMC1", exception);
            }
            try {
                if (stringArray[3].length() != 0) {
                    CommonIn.setLatitude(gPSRecord, stringArray[3], stringArray[4]);
                    n |= 4;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPRMC3", exception);
            }
            try {
                if (stringArray[5].length() != 0) {
                    CommonIn.setLongitude(gPSRecord, stringArray[5], stringArray[6]);
                    n |= 8;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPRMC5", exception);
            }
            try {
                if (stringArray[7].length() != 0) {
                    gPSRecord.speed = JavaLibBridge.toFloat(stringArray[7]) * 1.852f;
                    n |= 0x20;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPRMC7", exception);
            }
            try {
                if (stringArray[8].length() != 0) {
                    gPSRecord.heading = JavaLibBridge.toFloat(stringArray[8]);
                    n |= 0x40;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPRMC8", exception);
            }
            try {
                if (stringArray[9].length() != 0) {
                    CommonIn.setDate(gPSRecord, stringArray[9]);
                    n |= 1;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPRMC9", exception);
            }
        }
        return n;
    }

    private static final void debugInfo(String[] stringArray, String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(string);
        stringBuffer.append(':');
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        Generic.debug(stringBuffer.toString(), exception);
    }

    public static final int analyzeGPGGA(String[] stringArray, GPSRecord gPSRecord) {
        int n = 0;
        if ((stringArray[0].equals("GPGGA") || stringArray[0].equals("GNGGA")) && stringArray.length >= 12) {
            try {
                if (stringArray[1].length() != 0) {
                    if (CommonIn.setTime(gPSRecord, stringArray[1])) {
                        n = 262144;
                    }
                    n |= 1;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGGA1", exception);
            }
            try {
                if (stringArray[4].length() != 0) {
                    CommonIn.setLatitude(gPSRecord, stringArray[2], stringArray[3]);
                    n |= 4;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGGA2", exception);
            }
            try {
                if (stringArray[4].length() != 0) {
                    CommonIn.setLongitude(gPSRecord, stringArray[4], stringArray[5]);
                    n |= 8;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGGA4", exception);
            }
            try {
                if (stringArray[6].length() != 0) {
                    gPSRecord.valid = 1 << JavaLibBridge.toInt(stringArray[6]);
                    n |= 2;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGGA6", exception);
            }
            try {
                if (stringArray[7].length() != 0) {
                    gPSRecord.nsat = JavaLibBridge.toInt(stringArray[7]) << 8 | gPSRecord.nsat & 0xFF;
                    n |= 0x1000;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGGA7", exception);
            }
            try {
                if (stringArray[8].length() != 0) {
                    gPSRecord.hdop = (int)(JavaLibBridge.toFloat(stringArray[8]) * 100.0f);
                    n |= 0x400;
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGGA8", exception);
            }
            try {
                if (stringArray[9].length() != 0) {
                    gPSRecord.height = JavaLibBridge.toFloat(stringArray[9]);
                    n |= 0x10;
                }
                if (stringArray[11].length() != 0) {
                    gPSRecord.geoid = JavaLibBridge.toFloat(stringArray[11]);
                    gPSRecord.height += gPSRecord.geoid;
                } else if ((n & 4) != 0 && (n & 8) != 0) {
                    gPSRecord.geoid = (float)ExternalUtils.wgs84Separation(gPSRecord.latitude, gPSRecord.longitude);
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGGA9/11", exception);
            }
            if (stringArray.length >= 14) {
                try {
                    if (stringArray[13].length() != 0) {
                        gPSRecord.dage = JavaLibBridge.toInt(stringArray[13]);
                        n |= 0x100;
                    }
                }
                catch (Exception exception) {
                    CommonIn.debugInfo(stringArray, "GPGGA13", exception);
                }
            }
            if (stringArray.length >= 15) {
                try {
                    if (stringArray[14].length() != 0) {
                        gPSRecord.dsta = JavaLibBridge.toInt(stringArray[14]);
                        n |= 0x80;
                    }
                }
                catch (Exception exception) {
                    CommonIn.debugInfo(stringArray, "GPGGA14", exception);
                }
            }
        }
        return n;
    }

    public static final int analyzeGPGSV(String[] stringArray, GPSRecord gPSRecord) {
        if ((stringArray[0].equals("GPGSV") || stringArray[0].equals("GNGSV")) && stringArray.length >= 19) {
            try {
                if (stringArray[1].length() != 0) {
                    JavaLibBridge.toInt(stringArray[1]);
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGSV1", exception);
            }
            try {
                if (stringArray[2].length() != 0) {
                    JavaLibBridge.toInt(stringArray[2]);
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGSV2", exception);
            }
            try {
                if (stringArray[3].length() != 0) {
                    gPSRecord.nsat = gPSRecord.nsat & 0xFF00 | JavaLibBridge.toInt(stringArray[3]);
                }
            }
            catch (Exception exception) {
                CommonIn.debugInfo(stringArray, "GPGSV3", exception);
            }
        }
        return 0;
    }

    public static final void convertHeight(GPSRecord gPSRecord, int n) {
        if (n != 0 && gPSRecord.hasPosition()) {
            if (n < 0) {
                gPSRecord.height = (float)((double)gPSRecord.height - ExternalUtils.wgs84Separation(gPSRecord.latitude, gPSRecord.longitude));
                return;
            }
            gPSRecord.height = (float)((double)gPSRecord.height + ExternalUtils.wgs84Separation(gPSRecord.latitude, gPSRecord.longitude));
        }
    }

    public static final void adjustHeight(GPSRecord gPSRecord, int n) {
        if (n != 0 && gPSRecord.hasPosition() && gPSRecord.hasHeight()) {
            if (n < 0) {
                gPSRecord.height = (float)((double)gPSRecord.height - ExternalUtils.wgs84Separation(gPSRecord.latitude, gPSRecord.longitude));
                return;
            }
            gPSRecord.height = (float)((double)gPSRecord.height + ExternalUtils.wgs84Separation(gPSRecord.latitude, gPSRecord.longitude));
        }
    }
}

