/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.platform.DefaultPlatform;
import processing.core.PApplet;

public class LinuxPlatform
extends DefaultPlatform {
    String homeDir;

    @Override
    public void initBase(Base base) {
        super.initBase(base);
        String javaVendor = System.getProperty("java.vendor");
        String javaVM = System.getProperty("java.vm.name");
        if (javaVendor != null && (javaVendor.contains("Sun") || javaVendor.contains("Oracle")) && javaVM != null) {
            javaVM.contains("Java");
        }
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, "Processing");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getHomeDir() {
        if (this.homeDir == null) {
            this.homeDir = System.getProperty("user.home");
            String sudoUser = System.getenv("SUDO_USER");
            if (sudoUser != null && sudoUser.length() != 0) {
                try {
                    this.homeDir = LinuxPlatform.getHomeDir(sudoUser);
                }
                catch (Exception exception) {}
            }
        }
        return this.homeDir;
    }

    public static String getHomeDir(String user) throws Exception {
        Process p = PApplet.exec((String[])new String[]{"/bin/sh", "-c", "echo ~" + user});
        return PApplet.createReader((InputStream)p.getInputStream()).readLine();
    }

    @Override
    public File getSettingsFolder() throws Exception {
        return new File(this.getHomeDir(), ".processing");
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return new File(this.getHomeDir(), "sketchbook");
    }

    @Override
    public void openURL(String url) throws Exception {
        if (Desktop.isDesktopSupported()) {
            super.openURL(url);
        } else if (this.openFolderAvailable()) {
            String launcher = Preferences.get("launcher");
            Runtime.getRuntime().exec(new String[]{launcher, url});
        } else {
            System.err.println("No launcher set, cannot open " + url);
        }
    }

    @Override
    public boolean openFolderAvailable() {
        if (Preferences.get("launcher") != null) {
            return true;
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"xdg-open"});
            p.waitFor();
            Preferences.set("launcher", "xdg-open");
            return true;
        }
        catch (Exception exception) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                p.waitFor();
                Preferences.set("launcher", "gnome-open");
                return true;
            }
            catch (Exception exception2) {
                try {
                    Process p = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p.waitFor();
                    Preferences.set("launcher", "kde-open");
                    return true;
                }
                catch (Exception exception3) {
                    return false;
                }
            }
        }
    }

    @Override
    public void openFolder(File file) throws Exception {
        if (Desktop.isDesktopSupported()) {
            super.openFolder(file);
        } else if (this.openFolderAvailable()) {
            String launcher = Preferences.get("launcher");
            String[] params = new String[]{launcher, file.getAbsolutePath()};
            Runtime.getRuntime().exec(params);
        } else {
            System.err.println("No launcher set, cannot open " + file.getAbsolutePath());
        }
    }
}

