/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import processing.app.Base;
import processing.app.Platform;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.DetailPanel;
import processing.app.contrib.ManagerFrame;
import processing.app.ui.Toolkit;

class StatusPanel
extends JPanel {
    static final int BUTTON_WIDTH = Toolkit.zoom(150);
    static Icon foundationIcon;
    static Icon installIcon;
    static Icon updateIcon;
    static Icon removeIcon;
    static Font buttonFont;
    JTextPane label;
    JButton installButton;
    JPanel progressPanel;
    JLabel updateLabel;
    JButton updateButton;
    JButton removeButton;
    GroupLayout layout;
    JLabel iconLabel;
    ContributionListing contributionListing = ContributionListing.getInstance();
    ContributionTab contributionTab;
    private String bodyRule;

    public StatusPanel() {
    }

    public StatusPanel(final ContributionTab contributionTab, int width) {
        this.contributionTab = contributionTab;
        if (foundationIcon == null) {
            foundationIcon = Toolkit.getLibIconX("icons/foundation", 32);
            installIcon = Toolkit.getLibIconX("manager/install");
            updateIcon = Toolkit.getLibIconX("manager/update");
            removeIcon = Toolkit.getLibIconX("manager/remove");
            buttonFont = ManagerFrame.NORMAL_PLAIN;
        }
        this.setBackground(new Color(0xEBEBEB));
        this.iconLabel = new JLabel();
        this.iconLabel.setHorizontalAlignment(0);
        this.label = new JTextPane();
        this.label.setEditable(false);
        this.label.setOpaque(false);
        this.label.setContentType("text/html");
        this.bodyRule = "a, body { font-family: " + buttonFont.getFamily() + "; " + "font-size: " + buttonFont.getSize() + "pt; color: black; text-decoration: none;}";
        this.label.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
                    Platform.openURL(e.getURL().toString());
                }
            }
        });
        this.installButton = Toolkit.createIconButton("Install", installIcon);
        this.installButton.setFont(buttonFont);
        this.installButton.setHorizontalAlignment(2);
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.installButton.setEnabled(false);
                DetailPanel currentPanel = contributionTab.contributionListPanel.getSelectedPanel();
                currentPanel.install();
                StatusPanel.this.update(currentPanel);
            }
        });
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.setOpaque(false);
        this.updateLabel = new JLabel(" ");
        this.updateLabel.setFont(buttonFont);
        this.updateLabel.setHorizontalAlignment(0);
        this.updateButton = Toolkit.createIconButton("Update", updateIcon);
        this.updateButton.setFont(buttonFont);
        this.updateButton.setHorizontalAlignment(2);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.updateButton.setEnabled(false);
                DetailPanel currentPanel = contributionTab.contributionListPanel.getSelectedPanel();
                currentPanel.update();
                StatusPanel.this.update(currentPanel);
            }
        });
        this.removeButton = Toolkit.createIconButton("Remove", removeIcon);
        this.removeButton.setFont(buttonFont);
        this.removeButton.setHorizontalAlignment(2);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.removeButton.setEnabled(false);
                DetailPanel currentPanel = contributionTab.contributionListPanel.getSelectedPanel();
                currentPanel.remove();
                StatusPanel.this.update(currentPanel);
            }
        });
        int labelWidth = width != 0 ? 3 * width / 4 : -2;
        this.layout = new GroupLayout(this);
        this.setLayout(this.layout);
        this.layout.setAutoCreateContainerGaps(true);
        this.layout.setAutoCreateGaps(true);
        this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGap(0).addComponent(this.iconLabel, ManagerFrame.STATUS_WIDTH, ManagerFrame.STATUS_WIDTH, ManagerFrame.STATUS_WIDTH).addGap(0).addComponent(this.label, labelWidth, labelWidth, labelWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.installButton, BUTTON_WIDTH, BUTTON_WIDTH, BUTTON_WIDTH).addComponent(this.progressPanel).addComponent(this.updateLabel, BUTTON_WIDTH, BUTTON_WIDTH, BUTTON_WIDTH).addComponent(this.updateButton).addComponent(this.removeButton)).addGap(12));
        this.layout.setVerticalGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel).addComponent(this.label).addGroup(this.layout.createSequentialGroup().addComponent(this.installButton).addGroup(this.layout.createParallelGroup().addComponent(this.progressPanel).addComponent(this.updateLabel)).addComponent(this.updateButton).addComponent(this.removeButton)));
        this.layout.linkSize(0, this.installButton, this.progressPanel, this.updateButton, this.removeButton);
        this.progressPanel.setVisible(false);
        this.updateLabel.setVisible(false);
        this.installButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.updateLabel.setVisible(true);
        this.layout.setHonorsVisibility(this.updateLabel, false);
        this.validate();
    }

    void setMessage(String message) {
        if (this.label != null) {
            this.label.setText(message);
            this.label.repaint();
        }
    }

    void setErrorMessage(String message) {
        if (this.label != null) {
            this.label.setText(message);
            this.label.repaint();
        }
    }

    void clearMessage() {
        if (this.label != null) {
            this.label.setText(null);
            this.label.repaint();
        }
    }

    public void update(DetailPanel panel) {
        this.progressPanel.removeAll();
        this.iconLabel.setIcon(panel.getContrib().isSpecial() ? foundationIcon : null);
        this.label.setText(panel.description);
        ((HTMLDocument)this.label.getDocument()).getStyleSheet().addRule(this.bodyRule);
        this.updateButton.setEnabled(this.contributionListing.hasDownloadedLatestList() && this.contributionListing.hasUpdates(panel.getContrib()) && !panel.getContrib().isUpdateFlagged() && !panel.updateInProgress);
        String latestVersion = this.contributionListing.getLatestPrettyVersion(panel.getContrib());
        String currentVersion = panel.getContrib().getPrettyVersion();
        this.installButton.setEnabled(!panel.getContrib().isInstalled() && this.contributionListing.hasDownloadedLatestList() && panel.getContrib().isCompatible(Base.getRevision()) && !panel.installInProgress);
        if (panel.getContrib().isCompatible(Base.getRevision())) {
            if (this.installButton.isEnabled()) {
                if (latestVersion != null) {
                    this.updateLabel.setText(String.valueOf(latestVersion) + " available");
                } else {
                    this.updateLabel.setText("Available");
                }
            } else if (currentVersion != null) {
                this.updateLabel.setText(String.valueOf(currentVersion) + " installed");
            } else {
                this.updateLabel.setText("Installed");
            }
        } else if (currentVersion != null) {
            this.updateLabel.setText(String.valueOf(currentVersion) + " not compatible");
        } else {
            this.updateLabel.setText("Not compatible");
        }
        latestVersion = latestVersion != null ? "Update to " + latestVersion : "Update";
        if (this.updateButton.isEnabled()) {
            this.updateButton.setText(latestVersion);
        } else {
            this.updateButton.setText("Update");
        }
        this.removeButton.setEnabled(panel.getContrib().isInstalled() && !panel.removeInProgress);
        this.progressPanel.add(panel.installProgressBar);
        this.progressPanel.setVisible(false);
        this.updateLabel.setVisible(true);
        if (panel.updateInProgress || panel.installInProgress || panel.removeInProgress) {
            this.progressPanel.setVisible(true);
            this.updateLabel.setVisible(false);
            this.progressPanel.repaint();
        }
    }
}

