/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import org.apache.batik.apps.svgbrowser.ElementOverlayController;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.Overlay;
import org.w3c.dom.Element;

public class ElementOverlayManager {
    protected Color elementOverlayStrokeColor = Color.black;
    protected Color elementOverlayColor = Color.white;
    protected boolean xorMode = true;
    protected JSVGCanvas canvas;
    protected Overlay elementOverlay = new ElementOverlay();
    protected ArrayList elements;
    protected ElementOverlayController controller;
    protected boolean isOverlayEnabled = true;

    public ElementOverlayManager(JSVGCanvas jSVGCanvas) {
        this.canvas = jSVGCanvas;
        this.elements = new ArrayList();
        jSVGCanvas.getOverlays().add(this.elementOverlay);
    }

    public void addElement(Element element) {
        this.elements.add(element);
    }

    public void removeElement(Element element) {
        if (this.elements.remove(element)) {
            // empty if block
        }
    }

    public void removeElements() {
        this.elements.clear();
        this.repaint();
    }

    protected Rectangle getAllElementsBounds() {
        Rectangle rectangle = null;
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this.elements.get(i);
            Rectangle rectangle2 = this.getElementBounds(element);
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    protected Rectangle getElementBounds(Element element) {
        return this.getElementBounds(this.canvas.getUpdateManager().getBridgeContext().getGraphicsNode(element));
    }

    protected Rectangle getElementBounds(GraphicsNode graphicsNode) {
        if (graphicsNode == null) {
            return null;
        }
        AffineTransform affineTransform = this.canvas.getRenderingTransform();
        Shape shape = affineTransform.createTransformedShape(graphicsNode.getOutline());
        return this.outset(shape.getBounds(), 1);
    }

    protected Rectangle outset(Rectangle rectangle, int n) {
        rectangle.x -= n;
        rectangle.y -= n;
        rectangle.width += 2 * n;
        rectangle.height += 2 * n;
        return rectangle;
    }

    public void repaint() {
        this.canvas.repaint();
    }

    public Color getElementOverlayColor() {
        return this.elementOverlayColor;
    }

    public void setElementOverlayColor(Color color) {
        this.elementOverlayColor = color;
    }

    public Color getElementOverlayStrokeColor() {
        return this.elementOverlayStrokeColor;
    }

    public void setElementOverlayStrokeColor(Color color) {
        this.elementOverlayStrokeColor = color;
    }

    public boolean isXorMode() {
        return this.xorMode;
    }

    public void setXorMode(boolean bl) {
        this.xorMode = bl;
    }

    public Overlay getElementOverlay() {
        return this.elementOverlay;
    }

    public void removeOverlay() {
        this.canvas.getOverlays().remove(this.elementOverlay);
    }

    public void setController(ElementOverlayController elementOverlayController) {
        this.controller = elementOverlayController;
    }

    public boolean isOverlayEnabled() {
        return this.isOverlayEnabled;
    }

    public void setOverlayEnabled(boolean bl) {
        this.isOverlayEnabled = bl;
    }

    public class ElementOverlay
    implements Overlay {
        public void paint(Graphics graphics) {
            if (ElementOverlayManager.this.controller.isOverlayEnabled() && ElementOverlayManager.this.isOverlayEnabled()) {
                int n = ElementOverlayManager.this.elements.size();
                for (int i = 0; i < n; ++i) {
                    Element element = (Element)ElementOverlayManager.this.elements.get(i);
                    GraphicsNode graphicsNode = ElementOverlayManager.this.canvas.getUpdateManager().getBridgeContext().getGraphicsNode(element);
                    if (graphicsNode == null) continue;
                    AffineTransform affineTransform = graphicsNode.getGlobalTransform();
                    Shape shape = graphicsNode.getOutline();
                    AffineTransform affineTransform2 = ElementOverlayManager.this.canvas.getRenderingTransform();
                    affineTransform2.concatenate(affineTransform);
                    Shape shape2 = affineTransform2.createTransformedShape(shape);
                    if (shape2 == null) break;
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    if (ElementOverlayManager.this.xorMode) {
                        graphics2D.setColor(Color.black);
                        graphics2D.setXORMode(Color.yellow);
                        graphics2D.fill(shape2);
                        graphics2D.draw(shape2);
                        continue;
                    }
                    graphics2D.setColor(ElementOverlayManager.this.elementOverlayColor);
                    graphics2D.setStroke(new BasicStroke(1.8f));
                    graphics2D.setColor(ElementOverlayManager.this.elementOverlayStrokeColor);
                    graphics2D.draw(shape2);
                }
            }
        }
    }
}

