/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTSimpleDeclaration
extends ASTAttributeOwner
implements IASTSimpleDeclaration,
IASTAmbiguityParent {
    private IASTDeclarator[] declarators;
    private int declaratorsPos = -1;
    private IASTDeclSpecifier declSpecifier;

    public CASTSimpleDeclaration() {
    }

    public CASTSimpleDeclaration(IASTDeclSpecifier declSpecifier) {
        this.setDeclSpecifier(declSpecifier);
    }

    @Override
    public CASTSimpleDeclaration copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTSimpleDeclaration copy(IASTNode.CopyStyle style) {
        CASTSimpleDeclaration copy = new CASTSimpleDeclaration();
        copy.setDeclSpecifier(this.declSpecifier == null ? null : this.declSpecifier.copy(style));
        IASTDeclarator[] iASTDeclaratorArray = this.getDeclarators();
        int n = iASTDeclaratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator declarator = iASTDeclaratorArray[n2];
            copy.addDeclarator(declarator == null ? null : declarator.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpecifier;
    }

    @Override
    public IASTDeclarator[] getDeclarators() {
        if (this.declarators == null) {
            return IASTDeclarator.EMPTY_DECLARATOR_ARRAY;
        }
        this.declarators = ArrayUtil.trimAt(IASTDeclarator.class, this.declarators, this.declaratorsPos);
        return this.declarators;
    }

    @Override
    public void addDeclarator(IASTDeclarator d) {
        this.assertNotFrozen();
        if (d != null) {
            d.setParent(this);
            d.setPropertyInParent(DECLARATOR);
            this.declarators = ArrayUtil.appendAt(IASTDeclarator.class, this.declarators, ++this.declaratorsPos, d);
        }
    }

    @Override
    public void setDeclSpecifier(IASTDeclSpecifier declSpecifier) {
        this.assertNotFrozen();
        this.declSpecifier = declSpecifier;
        if (declSpecifier != null) {
            declSpecifier.setParent(this);
            declSpecifier.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.declSpecifier != null && !this.declSpecifier.accept(action)) {
            return false;
        }
        IASTDeclarator[] dtors = this.getDeclarators();
        int i = 0;
        while (i < dtors.length) {
            if (!dtors[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.declSpecifier == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.declSpecifier = (IASTDeclSpecifier)other;
        } else {
            IASTDeclarator[] declarators = this.getDeclarators();
            int i = 0;
            while (i < declarators.length) {
                if (declarators[i] == child) {
                    declarators[i] = (IASTDeclarator)other;
                    other.setParent(child.getParent());
                    other.setPropertyInParent(child.getPropertyInParent());
                    break;
                }
                ++i;
            }
        }
    }
}

