/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.model;

import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.mylyn.internal.discovery.core.model.Certification;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorCategory;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptorKind;
import org.eclipse.mylyn.internal.discovery.core.model.FeatureFilter;
import org.eclipse.mylyn.internal.discovery.core.model.Group;
import org.eclipse.mylyn.internal.discovery.core.model.Icon;
import org.eclipse.mylyn.internal.discovery.core.model.Messages;
import org.eclipse.mylyn.internal.discovery.core.model.Overview;
import org.eclipse.mylyn.internal.discovery.core.model.ValidationException;

public class ConnectorDiscoveryExtensionReader {
    private static final String P2_FEATURE_GROUP_SUFFIX = ".feature.group";
    public static final String EXTENSION_POINT_ID = "org.eclipse.mylyn.discovery.core.connectorDiscovery";
    public static final String CONNECTOR_DESCRIPTOR = "connectorDescriptor";
    public static final String CONNECTOR_CATEGORY = "connectorCategory";
    public static final String CERTIFICATION = "certification";
    public static final String ICON = "icon";
    public static final String OVERVIEW = "overview";
    public static final String FEATURE_FILTER = "featureFilter";
    public static final String GROUP = "group";

    public ConnectorDescriptor readConnectorDescriptor(IConfigurationElement element) throws ValidationException {
        return this.readConnectorDescriptor(element, ConnectorDescriptor.class);
    }

    public <T extends ConnectorDescriptor> T readConnectorDescriptor(IConfigurationElement element, Class<T> clazz) throws ValidationException {
        IConfigurationElement child;
        int n;
        ConnectorDescriptor connectorDescriptor;
        try {
            connectorDescriptor = (ConnectorDescriptor)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            String kinds = element.getAttribute("kind");
            if (kinds != null) {
                String[] akinds;
                String[] stringArray = akinds = kinds.split("\\s*,\\s*");
                int n2 = akinds.length;
                n = 0;
                while (n < n2) {
                    String kind = stringArray[n];
                    connectorDescriptor.getKind().add(ConnectorDescriptorKind.fromValue(kind));
                    ++n;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_value_kind);
        }
        connectorDescriptor.setName(element.getAttribute("name"));
        connectorDescriptor.setProvider(element.getAttribute("provider"));
        connectorDescriptor.setLicense(element.getAttribute("license"));
        connectorDescriptor.setDescription(element.getAttribute("description"));
        connectorDescriptor.setSiteUrl(element.getAttribute("siteUrl"));
        connectorDescriptor.setId(element.getAttribute("id"));
        connectorDescriptor.setCategoryId(element.getAttribute("categoryId"));
        connectorDescriptor.setCertificationId(element.getAttribute("certificationId"));
        connectorDescriptor.setPlatformFilter(element.getAttribute("platformFilter"));
        connectorDescriptor.setGroupId(element.getAttribute("groupId"));
        connectorDescriptor.setStatsUrl(element.getAttribute("statsUrl"));
        IConfigurationElement[] children = element.getChildren("iu");
        if (children.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = children;
            n = children.length;
            int n3 = 0;
            while (n3 < n) {
                child = iConfigurationElementArray[n3];
                connectorDescriptor.getInstallableUnits().add(this.getFeatureId(child.getAttribute("id")));
                ++n3;
            }
        } else {
            connectorDescriptor.getInstallableUnits().add(this.getFeatureId(connectorDescriptor.getId()));
        }
        IConfigurationElement[] iConfigurationElementArray = element.getChildren("attribute");
        n = iConfigurationElementArray.length;
        int n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            this.readAttribute(child, connectorDescriptor.getAttributes());
            ++n4;
        }
        iConfigurationElementArray = element.getChildren(FEATURE_FILTER);
        n = iConfigurationElementArray.length;
        n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            FeatureFilter featureFilterItem = this.readFeatureFilter(child);
            featureFilterItem.setConnectorDescriptor(connectorDescriptor);
            connectorDescriptor.getFeatureFilter().add(featureFilterItem);
            ++n4;
        }
        iConfigurationElementArray = element.getChildren(ICON);
        n = iConfigurationElementArray.length;
        n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            Icon iconItem = this.readIcon(child);
            if (connectorDescriptor.getIcon() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_icon);
            }
            connectorDescriptor.setIcon(iconItem);
            ++n4;
        }
        iConfigurationElementArray = element.getChildren(OVERVIEW);
        n = iConfigurationElementArray.length;
        n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            Overview overviewItem = this.readOverview(child);
            overviewItem.setConnectorDescriptor(connectorDescriptor);
            if (connectorDescriptor.getOverview() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_overview);
            }
            connectorDescriptor.setOverview(overviewItem);
            ++n4;
        }
        connectorDescriptor.validate();
        return (T)connectorDescriptor;
    }

    private void readAttribute(IConfigurationElement element, Map<String, String> attributes) {
        attributes.put(element.getAttribute("key"), element.getAttribute("value"));
    }

    private String getFeatureId(String id) {
        if (!id.endsWith(P2_FEATURE_GROUP_SUFFIX)) {
            return String.valueOf(id) + P2_FEATURE_GROUP_SUFFIX;
        }
        return id;
    }

    public ConnectorCategory readConnectorCategory(IConfigurationElement element) throws ValidationException {
        return this.readConnectorCategory(element, ConnectorCategory.class);
    }

    public <T extends ConnectorCategory> T readConnectorCategory(IConfigurationElement element, Class<T> clazz) throws ValidationException {
        IConfigurationElement child;
        ConnectorCategory connectorCategory;
        try {
            connectorCategory = (ConnectorCategory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        connectorCategory.setId(element.getAttribute("id"));
        connectorCategory.setName(element.getAttribute("name"));
        connectorCategory.setDescription(element.getAttribute("description"));
        connectorCategory.setRelevance(element.getAttribute("relevance"));
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ICON);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Icon iconItem = this.readIcon(child);
            if (connectorCategory.getIcon() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_icon);
            }
            connectorCategory.setIcon(iconItem);
            ++n2;
        }
        iConfigurationElementArray = element.getChildren(OVERVIEW);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Overview overviewItem = this.readOverview(child);
            overviewItem.setConnectorCategory(connectorCategory);
            if (connectorCategory.getOverview() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_overview);
            }
            connectorCategory.setOverview(overviewItem);
            ++n2;
        }
        iConfigurationElementArray = element.getChildren(GROUP);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Group groupItem = this.readGroup(child);
            groupItem.setConnectorCategory(connectorCategory);
            connectorCategory.getGroup().add(groupItem);
            ++n2;
        }
        connectorCategory.validate();
        return (T)connectorCategory;
    }

    public <T extends Certification> T readCertification(IConfigurationElement element, Class<T> clazz) throws ValidationException {
        IConfigurationElement child;
        Certification certification;
        try {
            certification = (Certification)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        certification.setId(element.getAttribute("id"));
        certification.setName(element.getAttribute("name"));
        certification.setUrl(element.getAttribute("url"));
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ICON);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Icon iconItem = this.readIcon(child);
            if (certification.getIcon() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_icon);
            }
            certification.setIcon(iconItem);
            ++n2;
        }
        iConfigurationElementArray = element.getChildren("description");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            certification.setDescription(child.getValue());
            ++n2;
        }
        certification.validate();
        return (T)certification;
    }

    public Icon readIcon(IConfigurationElement element) throws ValidationException {
        Icon icon = new Icon();
        icon.setImage16(element.getAttribute("image16"));
        icon.setImage32(element.getAttribute("image32"));
        icon.setImage48(element.getAttribute("image48"));
        icon.setImage64(element.getAttribute("image64"));
        icon.setImage128(element.getAttribute("image128"));
        icon.validate();
        return icon;
    }

    public Overview readOverview(IConfigurationElement element) throws ValidationException {
        Overview overview = new Overview();
        overview.setSummary(element.getAttribute("summary"));
        overview.setUrl(element.getAttribute("url"));
        overview.setScreenshot(element.getAttribute("screenshot"));
        overview.validate();
        return overview;
    }

    public FeatureFilter readFeatureFilter(IConfigurationElement element) throws ValidationException {
        FeatureFilter featureFilter = new FeatureFilter();
        featureFilter.setFeatureId(element.getAttribute("featureId"));
        featureFilter.setVersion(element.getAttribute("version"));
        featureFilter.validate();
        return featureFilter;
    }

    public Group readGroup(IConfigurationElement element) throws ValidationException {
        Group group = new Group();
        group.setId(element.getAttribute("id"));
        group.validate();
        return group;
    }
}

