/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.impl;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.concurrent.Batchable;
import scala.concurrent.BatchingExecutor;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.impl.ExecutionContextImpl;
import scala.concurrent.impl.Promise;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.runtime.Statics;

public final class ExecutionContextImpl$ {
    public static final ExecutionContextImpl$ MODULE$ = new ExecutionContextImpl$();

    public ExecutionContextExecutorService createDefaultExecutorService(Function1<Throwable, BoxedUnit> reporter) {
        int desiredParallelism = package$.MODULE$.min(package$.MODULE$.max(ExecutionContextImpl$.getInt$1("scala.concurrent.context.minThreads", "1"), ExecutionContextImpl$.getInt$1("scala.concurrent.context.numThreads", "x1")), ExecutionContextImpl$.getInt$1("scala.concurrent.context.maxThreads", "x1"));
        ExecutionContextImpl.DefaultThreadFactory threadFactory = new ExecutionContextImpl.DefaultThreadFactory(true, ExecutionContextImpl$.getInt$1("scala.concurrent.context.maxExtraThreads", "256"), "scala-execution-context-global", (thread, cause) -> reporter.apply(cause));
        return new ExecutionContextExecutorService(desiredParallelism, threadFactory){
            private ThreadLocal<Object> scala$concurrent$BatchingExecutor$$_tasksLocal;

            public final void submitAsyncBatched(Runnable runnable) {
                BatchingExecutor.submitAsyncBatched$(this, runnable);
            }

            public final void submitSyncBatched(Runnable runnable) {
                BatchingExecutor.submitSyncBatched$(this, runnable);
            }

            public ExecutionContext prepare() {
                return ExecutionContext.prepare$(this);
            }

            public final ThreadLocal<Object> scala$concurrent$BatchingExecutor$$_tasksLocal() {
                return this.scala$concurrent$BatchingExecutor$$_tasksLocal;
            }

            public final void scala$concurrent$BatchingExecutor$_setter_$scala$concurrent$BatchingExecutor$$_tasksLocal_$eq(ThreadLocal<Object> x$1) {
                this.scala$concurrent$BatchingExecutor$$_tasksLocal = x$1;
            }

            public final void submitForExecution(Runnable runnable) {
                super.execute(runnable);
            }

            public final void execute(Runnable runnable) {
                if ((!(runnable instanceof Promise.Transformation) || ((Promise.Transformation)runnable).benefitsFromBatching()) && runnable instanceof Batchable) {
                    this.submitAsyncBatched(runnable);
                } else {
                    this.submitForExecution(runnable);
                }
            }

            public final void reportFailure(Throwable cause) {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.getUncaughtExceptionHandler();
                if (uncaughtExceptionHandler == null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), cause);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                ExecutionContext.$init$(this);
                BatchingExecutor.$init$(this);
                Statics.releaseFence();
            }
        };
    }

    public ExecutionContextExecutor fromExecutor(Executor e, Function1<Throwable, BoxedUnit> reporter) {
        Executor executor = e;
        ExecutionContextExecutor executionContextExecutor = executor == null ? this.createDefaultExecutorService(reporter) : new ExecutionContextImpl(executor, reporter);
        return executionContextExecutor;
    }

    public Function1<Throwable, BoxedUnit> fromExecutor$default$2() {
        return ExecutionContext$.MODULE$.defaultReporter();
    }

    public ExecutionContextExecutorService fromExecutorService(ExecutorService es, Function1<Throwable, BoxedUnit> reporter) {
        ExecutorService executorService = es;
        ExecutionContextExecutorService executionContextExecutorService = executorService == null ? this.createDefaultExecutorService(reporter) : new ExecutionContextExecutorService(executorService, reporter){

            private final ExecutorService asExecutorService() {
                return (ExecutorService)this.executor();
            }

            public final void shutdown() {
                this.asExecutorService().shutdown();
            }

            public final List<Runnable> shutdownNow() {
                return this.asExecutorService().shutdownNow();
            }

            public final boolean isShutdown() {
                return this.asExecutorService().isShutdown();
            }

            public final boolean isTerminated() {
                return this.asExecutorService().isTerminated();
            }

            public final boolean awaitTermination(long l, TimeUnit timeUnit) {
                return this.asExecutorService().awaitTermination(l, timeUnit);
            }

            public final <T> Future<T> submit(Callable<T> callable) {
                return this.asExecutorService().submit(callable);
            }

            public final <T> Future<T> submit(Runnable runnable, T t) {
                return this.asExecutorService().submit(runnable, t);
            }

            public final Future<?> submit(Runnable runnable) {
                return this.asExecutorService().submit(runnable);
            }

            public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) {
                return this.asExecutorService().invokeAll(callables);
            }

            public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) {
                return this.asExecutorService().invokeAll(callables, l, timeUnit);
            }

            public final <T> T invokeAny(Collection<? extends Callable<T>> callables) {
                return this.asExecutorService().invokeAny(callables);
            }

            public final <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) {
                return this.asExecutorService().invokeAny(callables, l, timeUnit);
            }
        };
        return executionContextExecutorService;
    }

    public Function1<Throwable, BoxedUnit> fromExecutorService$default$2() {
        return ExecutionContext$.MODULE$.defaultReporter();
    }

    private static final int getInt$1(String name, String string) {
        String string2;
        String string3;
        try {
            string3 = System.getProperty(name, string);
        }
        catch (SecurityException e) {
            string3 = string2 = string;
        }
        int n = string2.charAt(0) == 'x' ? (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() * StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(string2.substring(1))))) : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string2));
        return n;
    }

    private ExecutionContextImpl$() {
    }
}

