/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceServiceImpl
extends PsiReferenceService {
    private static final Logger LOG = Logger.getInstance(PsiReferenceService.class);

    @NotNull
    public List<PsiReference> getReferences(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
        if (element == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(0);
        }
        if (hints == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(1);
        }
        List<PsiReference> references = PsiReferenceServiceImpl.doGetReferences(element, hints);
        PsiReferenceServiceImpl.assertReferencesHaveSameElement(element, references);
        List<PsiReference> list2 = references;
        if (list2 == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    private static List<PsiReference> doGetReferences(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
        if (element == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(3);
        }
        if (hints == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(4);
        }
        if (element instanceof ContributedReferenceHost) {
            List<PsiReference> list2 = Arrays.asList(ReferenceProvidersRegistry.getReferencesFromProviders(element, hints));
            if (list2 == null) {
                PsiReferenceServiceImpl.$$$reportNull$$$0(5);
            }
            return list2;
        }
        if (element instanceof HintedReferenceHost) {
            List<PsiReference> list3 = Arrays.asList(((HintedReferenceHost)element).getReferences(hints));
            if (list3 == null) {
                PsiReferenceServiceImpl.$$$reportNull$$$0(6);
            }
            return list3;
        }
        List<PsiReference> list4 = Arrays.asList(element.getReferences());
        if (list4 == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(7);
        }
        return list4;
    }

    private static void assertReferencesHaveSameElement(@NotNull PsiElement element, @NotNull List<PsiReference> references) {
        if (element == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(8);
        }
        if (references == null) {
            PsiReferenceServiceImpl.$$$reportNull$$$0(9);
        }
        for (PsiReference reference2 : references) {
            PsiElement referenceElement = reference2.getElement();
            if (referenceElement == element) continue;
            LOG.error("Reference element is not the same element for which references were queried", (Throwable)new RuntimeException("Element: " + element.getClass().getName() + "; reference: " + reference2.getClass().getName() + "; reference element: " + referenceElement.getClass().getName()), new Attachment[]{new Attachment("info.txt", "Element text: `" + element.getText() + "`\nReference range: " + reference2.getRangeInElement())});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiReferenceServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiReferenceServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetReferences";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertReferencesHaveSameElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

