/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.FeatureUsageDataKt;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.TimeoutCachedValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntProcedure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u001a$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002\u001a_\u0010\r\u001a\u00020\b\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u0002H\u000e2\u0006\u0010\u0013\u001a\u0002H\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u00060\u0015\u00a2\u0006\u0002\u0010\u0017\u001aM\u0010\r\u001a\u00020\b\"\u0004\b\u0000\u0010\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u0002H\u000e2\u0006\u0010\u0013\u001a\u0002H\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001a\u001a\"\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\u001f\u001a\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\u001a&\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(\u001a\u0018\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,H\u0007\u001a\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\u001a\u001c\u0010.\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00012\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00010!\u001a\u0016\u00100\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0001\u001a$\u00100\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00012\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00010!\u001a\u001e\u00101\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00062\f\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u000102H\u0007\u001a\u0012\u00103\u001a\u0002042\n\u00105\u001a\u0006\u0012\u0002\b\u000306\u001a\u000e\u00107\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&\u001a\u0010\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u0001H\u0002\u001a\u0010\u0010:\u001a\u00020,2\b\u0010;\u001a\u0004\u0018\u00010<\u001a\u0010\u0010=\u001a\u00020,2\b\u0010;\u001a\u0004\u0018\u00010\u0006\u001a\u0010\u0010>\u001a\u00020,2\b\u0010?\u001a\u0004\u0018\u00010\"\u001a(\u0010@\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u001a\u001a\u0010C\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"kilo", "", "mega", "safeToReportPluginIds", "Lcom/intellij/openapi/util/Getter;", "", "", "addAll", "", "result", "Lcom/intellij/util/containers/ObjectIntHashMap;", "usages", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "addIfDiffers", "T", "V", "set", "", "settingsBean", "defaultSettingsBean", "valueFunction", "Lkotlin/Function1;", "featureIdFunction", "(Ljava/util/Set;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "", "featureIdPrefix", "(Ljava/util/Set;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "addPluginInfoTo", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "data", "", "collectSafePluginDescriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "createData", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/internal/statistic/service/fus/collectors/FUSUsageContext;", "getBooleanUsage", "key", "value", "", "getBundledJetBrainsPluginDescriptors", "getCountingStepName", "steps", "getCountingUsage", "getEnumUsage", "", "getPluginType", "Lcom/intellij/internal/statistic/utils/PluginType;", "clazz", "Ljava/lang/Class;", "getProjectId", "humanize", "number", "isDevelopedByJetBrains", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "isSafeToReport", "isSafeToReportFrom", "descriptor", "merge", "first", "second", "toUsageDescriptors", "intellij.platform.ide.impl"})
public final class StatisticsUtilKt {
    private static final int kilo = 1000;
    private static final int mega = 1000000;
    private static final Getter<Set<String>> safeToReportPluginIds;

    @NotNull
    public static final String getProjectId(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return EventLogConfiguration.INSTANCE.anonymize(ProjectUtil.getProjectCacheFileName$default((Project)project, (boolean)false, null, null, (int)7, null));
    }

    @NotNull
    public static final Map<String, Object> createData(@Nullable Project project, @Nullable FUSUsageContext context) {
        return FeatureUsageDataKt.newData(project, context);
    }

    public static final void addPluginInfoTo(@NotNull PluginInfo info, @NotNull Map<String, Object> data) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        data.put("plugin_type", info.getType().name());
        if (info.getType().isSafeToReport() && info.getId() != null && StringUtil.isNotEmpty((String)info.getId())) {
            data.put("plugin", info.getId());
        }
    }

    public static final boolean isDevelopedByJetBrains(@Nullable PluginId pluginId) {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        return plugin == null || PluginManagerMain.isDevelopedByJetBrains(plugin.getVendor());
    }

    @Deprecated(message="Report enabled or disabled setting as MetricEvent")
    @NotNull
    public static final UsageDescriptor getBooleanUsage(@NotNull String key, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return new UsageDescriptor(key + (value ? ".enabled" : ".disabled"), 1);
    }

    @Deprecated(message="Report enum settings as MetricEvent")
    @NotNull
    public static final UsageDescriptor getEnumUsage(@NotNull String key, @Nullable Enum<?> value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        StringBuilder stringBuilder = new StringBuilder().append(key).append(".");
        Enum<?> enum_ = value;
        if (enum_ != null && (enum_ = enum_.name()) != null) {
            Enum<?> enum_2 = enum_;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            Enum<?> enum_3 = enum_2;
            if (enum_3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)((Object)enum_3)).toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
            String string3 = string2;
            stringBuilder = stringBuilder2;
            string = string3;
        } else {
            string = null;
        }
        int n = 1;
        String string4 = stringBuilder.append(string).toString();
        return new UsageDescriptor(string4, n);
    }

    @NotNull
    public static final UsageDescriptor getCountingUsage(@NotNull String key, int value, @NotNull List<Integer> steps) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(steps, (String)"steps");
        return new UsageDescriptor(key + '.' + StatisticsUtilKt.getCountingStepName(value, steps), 1);
    }

    @NotNull
    public static final String getCountingStepName(int value, @NotNull List<Integer> steps) {
        int stepIndex;
        Intrinsics.checkParameterIsNotNull(steps, (String)"steps");
        if (steps.isEmpty()) {
            return String.valueOf(value);
        }
        if (value < ((Number)steps.get(0)).intValue()) {
            return "<" + ((Number)steps.get(0)).intValue();
        }
        for (stepIndex = 0; stepIndex < steps.size() - 1 && value >= ((Number)steps.get(stepIndex + 1)).intValue(); ++stepIndex) {
        }
        int step = ((Number)steps.get(stepIndex)).intValue();
        boolean addPlus = stepIndex == steps.size() - 1 || ((Number)steps.get(stepIndex + 1)).intValue() != step + 1;
        return StatisticsUtilKt.humanize(step) + (addPlus ? "+" : "");
    }

    @NotNull
    public static final UsageDescriptor getCountingUsage(@NotNull String key, int value) {
        Object element$iv;
        block5: {
            List fixedSteps;
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            if (value > 0xCCCCCCC) {
                return new UsageDescriptor(key + ".MANY", 1);
            }
            if (value < 0) {
                return new UsageDescriptor(key + ".<0", 1);
            }
            if (value < 3) {
                return new UsageDescriptor(key + '.' + value, 1);
            }
            List $this$last$iv = fixedSteps = CollectionsKt.listOf((Object[])new Integer[]{3, 5, 10, 15, 30, 50});
            boolean $i$f$last = false;
            ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                element$iv = iterator$iv.previous();
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(it <= value)) continue;
                break block5;
            }
            throw (Throwable)new NoSuchElementException("List contains no element matching the predicate.");
        }
        int step = ((Number)element$iv).intValue();
        while (value >= step * 2 && value >= (step *= 2) * 5) {
            step *= 5;
        }
        String stepName = StatisticsUtilKt.humanize(step);
        return new UsageDescriptor(key + '.' + stepName + '+', 1);
    }

    private static final String humanize(int number) {
        if (number == 0) {
            return "0";
        }
        int m = number / mega;
        int k = number % mega / 1000;
        int r = number % 1000;
        String ms = m > 0 ? "" + m + 'M' : "";
        String ks = k > 0 ? "" + k + 'K' : "";
        String rs = r > 0 ? String.valueOf(r) : "";
        return ms + ks + rs;
    }

    public static final <T> void addIfDiffers(@NotNull Set<? super UsageDescriptor> set, T settingsBean, T defaultSettingsBean, @NotNull Function1<? super T, ? extends Object> valueFunction, @NotNull String featureIdPrefix) {
        Intrinsics.checkParameterIsNotNull(set, (String)"set");
        Intrinsics.checkParameterIsNotNull(valueFunction, (String)"valueFunction");
        Intrinsics.checkParameterIsNotNull((Object)featureIdPrefix, (String)"featureIdPrefix");
        StatisticsUtilKt.addIfDiffers(set, settingsBean, defaultSettingsBean, valueFunction, (Function1)new Function1<Object, String>(featureIdPrefix){
            final /* synthetic */ String $featureIdPrefix;

            @NotNull
            public final String invoke(@NotNull Object it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$featureIdPrefix + '.' + it;
            }
            {
                this.$featureIdPrefix = string;
                super(1);
            }
        });
    }

    public static final <T, V> void addIfDiffers(@NotNull Set<? super UsageDescriptor> set, T settingsBean, T defaultSettingsBean, @NotNull Function1<? super T, ? extends V> valueFunction, @NotNull Function1<? super V, String> featureIdFunction) {
        Intrinsics.checkParameterIsNotNull(set, (String)"set");
        Intrinsics.checkParameterIsNotNull(valueFunction, (String)"valueFunction");
        Intrinsics.checkParameterIsNotNull(featureIdFunction, (String)"featureIdFunction");
        Object value = valueFunction.invoke(settingsBean);
        Object defaultValue = valueFunction.invoke(defaultSettingsBean);
        if (!Comparing.equal((Object)value, (Object)defaultValue)) {
            set.add(new UsageDescriptor((String)featureIdFunction.invoke(value), 1));
        }
    }

    @NotNull
    public static final Set<UsageDescriptor> toUsageDescriptors(@NotNull ObjectIntHashMap<String> result2) {
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        if (result2.isEmpty()) {
            return SetsKt.emptySet();
        }
        THashSet descriptors = new THashSet(result2.size());
        result2.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(descriptors){
            final /* synthetic */ THashSet $descriptors;

            public final boolean execute(String key, int value) {
                this.$descriptors.add((Object)new UsageDescriptor(key, value));
                return true;
            }
            {
                this.$descriptors = tHashSet;
            }
        });
        return (Set)descriptors;
    }

    @NotNull
    public static final Set<UsageDescriptor> merge(@NotNull Set<UsageDescriptor> first, @NotNull Set<UsageDescriptor> second) {
        Intrinsics.checkParameterIsNotNull(first, (String)"first");
        Intrinsics.checkParameterIsNotNull(second, (String)"second");
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ObjectIntHashMap merged = new ObjectIntHashMap();
        StatisticsUtilKt.addAll((ObjectIntHashMap<String>)merged, first);
        StatisticsUtilKt.addAll((ObjectIntHashMap<String>)merged, second);
        return StatisticsUtilKt.toUsageDescriptors((ObjectIntHashMap<String>)merged);
    }

    private static final void addAll(ObjectIntHashMap<String> result2, Set<UsageDescriptor> usages) {
        for (UsageDescriptor usage : usages) {
            String key = usage.getKey();
            result2.put((Object)key, result2.get((Object)key, 0) + usage.getValue());
        }
    }

    private static final List<IdeaPluginDescriptor> collectSafePluginDescriptors() {
        if (ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository()) {
            try {
                List<IdeaPluginDescriptor> cached = RepositoryHelper.loadCachedPlugins();
                if (cached != null) {
                    ArrayList plugins2 = new ArrayList();
                    plugins2.addAll(cached);
                    plugins2.addAll(StatisticsUtilKt.getBundledJetBrainsPluginDescriptors());
                    return plugins2;
                }
                ApplicationManager.getApplication().executeOnPooledThread((Runnable)collectSafePluginDescriptors.1.INSTANCE);
                return CollectionsKt.emptyList();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return StatisticsUtilKt.getBundledJetBrainsPluginDescriptors();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IdeaPluginDescriptor> getBundledJetBrainsPluginDescriptors() {
        void var3_3;
        void $this$filterTo$iv$iv;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManager.getPlugins();
        Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptorArray, (String)"PluginManager.getPlugins()");
        IdeaPluginDescriptor[] $this$filter$iv = ideaPluginDescriptorArray;
        boolean $i$f$filter = false;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var5_5 = $this$filterTo$iv$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var5_5[i];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!(v1.isBundled() && PluginManagerMain.isDevelopedByJetBrains((IdeaPluginDescriptor)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)var3_3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSafeToReportFrom(@Nullable IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            return false;
        }
        if (StatisticsUtilKt.isDevelopedByJetBrains(descriptor2.getPluginId())) {
            return true;
        }
        if (descriptor2.isBundled()) return false;
        PluginId pluginId = descriptor2.getPluginId();
        if (!StatisticsUtilKt.isSafeToReport(pluginId != null ? pluginId.getIdString() : null)) return false;
        return true;
    }

    public static final boolean isSafeToReport(@Nullable String pluginId) {
        return pluginId != null && ((Set)safeToReportPluginIds.get()).contains(pluginId);
    }

    @NotNull
    public static final PluginType getPluginType(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        PluginId pluginId = PluginManagerCore.getPluginByClassName(clazz.getName());
        if (pluginId == null) {
            return PluginType.PLATFORM;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"PluginManagerCore.getPlu\u2026eturn PluginType.PLATFORM");
        PluginId pluginId2 = pluginId;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin(pluginId2);
        if (ideaPluginDescriptor == null) {
            return PluginType.UNKNOWN;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"PluginManager.getPlugin(\u2026return PluginType.UNKNOWN");
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        if (PluginManagerMain.isDevelopedByJetBrains(plugin)) {
            return plugin.isBundled() ? PluginType.JB_BUNDLED : PluginType.JB_NOT_BUNDLED;
        }
        boolean listed = !plugin.isBundled() && StatisticsUtilKt.isSafeToReport(pluginId2.getIdString());
        return listed ? PluginType.LISTED : PluginType.NOT_LISTED;
    }

    static {
        mega = 1000000;
        safeToReportPluginIds = (Getter)new TimeoutCachedValue(1L, TimeUnit.HOURS, (Supplier)safeToReportPluginIds.1.INSTANCE);
    }

    public static final /* synthetic */ List access$collectSafePluginDescriptors() {
        return StatisticsUtilKt.collectSafePluginDescriptors();
    }
}

