/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.groups;

import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Function;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunAnythingGroup {
    public static final Function<String, NameUtil.MatcherBuilder> RUN_ANYTHING_MATCHER_BUILDER = pattern -> NameUtil.buildMatcher((String)("*" + pattern));
    volatile int myMoreIndex = -1;
    private volatile int myTitleIndex = -1;

    @NotNull
    public abstract String getTitle();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    protected int getMaxInitialItems() {
        return 5;
    }

    protected int getMaxItemsToInsert() {
        return 5;
    }

    public abstract SearchResult getItems(@NotNull DataContext var1, @NotNull DefaultListModel var2, @NotNull String var3, boolean var4, @NotNull Runnable var5);

    public void resetMoreIndex() {
        this.myMoreIndex = -1;
    }

    private static void shiftMoreIndex(Collection<? extends RunAnythingGroup> groups, int baseIndex, int shift) {
        groups.stream().filter(runAnythingGroup -> runAnythingGroup.myMoreIndex >= baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myMoreIndex += shift);
    }

    @Nullable
    public static String getTitle(@NotNull Collection<? extends RunAnythingGroup> groups, int titleIndex) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(0);
        }
        return Optional.ofNullable(RunAnythingGroup.findGroup(groups, titleIndex)).map(RunAnythingGroup::getTitle).orElse(null);
    }

    @Nullable
    public static RunAnythingGroup findGroup(@NotNull Collection<? extends RunAnythingGroup> groups, int titleIndex) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(1);
        }
        return groups.stream().filter(runAnythingGroup -> titleIndex == runAnythingGroup.myTitleIndex).findFirst().orElse(null);
    }

    @Nullable
    public static RunAnythingGroup findItemGroup(@NotNull List<? extends RunAnythingGroup> groups, int itemIndex) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(2);
        }
        RunAnythingGroup runAnythingGroup = null;
        for (RunAnythingGroup runAnythingGroup2 : groups) {
            if (runAnythingGroup2.myTitleIndex == -1) continue;
            if (runAnythingGroup2.myTitleIndex > itemIndex) break;
            runAnythingGroup = runAnythingGroup2;
        }
        return runAnythingGroup;
    }

    private static void shiftTitleIndex(@NotNull Collection<? extends RunAnythingGroup> groups, int baseIndex, int shift) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(3);
        }
        groups.stream().filter(runAnythingGroup -> runAnythingGroup.myTitleIndex != -1 && runAnythingGroup.myTitleIndex > baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myTitleIndex += shift);
    }

    public static void clearMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(4);
        }
        groups.forEach(runAnythingGroup -> {
            runAnythingGroup.myMoreIndex = -1;
        });
    }

    private static void clearTitleIndex(@NotNull Collection<? extends RunAnythingGroup> groups) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(5);
        }
        groups.forEach(runAnythingGroup -> {
            runAnythingGroup.myTitleIndex = -1;
        });
    }

    public static int[] getAllIndexes(@NotNull Collection<? extends RunAnythingGroup> groups) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(6);
        }
        TIntArrayList list2 = new TIntArrayList();
        for (RunAnythingGroup runAnythingGroup : groups) {
            list2.add(runAnythingGroup.myTitleIndex);
        }
        for (RunAnythingGroup runAnythingGroup : groups) {
            list2.add(runAnythingGroup.myMoreIndex);
        }
        return list2.toNativeArray();
    }

    @Nullable
    public static RunAnythingGroup findGroupByMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups, int moreIndex) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(7);
        }
        return groups.stream().filter(runAnythingGroup -> moreIndex == runAnythingGroup.myMoreIndex).findFirst().orElse(null);
    }

    public static boolean isMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups, int index) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(8);
        }
        return groups.stream().anyMatch(runAnythingGroup -> runAnythingGroup.myMoreIndex == index);
    }

    public static void shiftIndexes(@NotNull Collection<? extends RunAnythingGroup> groups, int baseIndex, int shift) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(9);
        }
        RunAnythingGroup.shiftTitleIndex(groups, baseIndex, shift);
        RunAnythingGroup.shiftMoreIndex(groups, baseIndex, shift);
    }

    public static void clearIndexes(@NotNull Collection<? extends RunAnythingGroup> groups) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(10);
        }
        RunAnythingGroup.clearTitleIndex(groups);
        RunAnythingGroup.clearMoreIndex(groups);
    }

    public final synchronized void collectItems(@NotNull DataContext dataContext, @NotNull DefaultListModel model2, @NotNull String pattern, @NotNull Runnable cancellationChecker) {
        if (dataContext == null) {
            RunAnythingGroup.$$$reportNull$$$0(11);
        }
        if (model2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(12);
        }
        if (pattern == null) {
            RunAnythingGroup.$$$reportNull$$$0(13);
        }
        if (cancellationChecker == null) {
            RunAnythingGroup.$$$reportNull$$$0(14);
        }
        SearchResult result2 = this.getItems(dataContext, model2, pattern, false, cancellationChecker);
        cancellationChecker.run();
        if (!result2.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                cancellationChecker.run();
                this.myTitleIndex = model2.size();
                result2.forEach(model2::addElement);
                this.myMoreIndex = result2.myNeedMore ? model2.getSize() - 1 : -1;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationChecker";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/runAnything/groups/RunAnythingGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findItemGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shiftTitleIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearMoreIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clearTitleIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllIndexes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findGroupByMoreIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isMoreIndex";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "shiftIndexes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "clearIndexes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "collectItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SearchResult
    extends ArrayList<RunAnythingItem> {
        boolean myNeedMore;

        public boolean isNeedMore() {
            return this.myNeedMore;
        }

        public void setNeedMore(boolean needMore) {
            this.myNeedMore = needMore;
        }
    }
}

