/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownFileTypeDiffRequest
extends ComponentDiffRequest {
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myTitle;

    public UnknownFileTypeDiffRequest(@NotNull VirtualFile file2, @Nullable String title) {
        if (file2 == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(0);
        }
        this(file2.getName(), title);
    }

    public UnknownFileTypeDiffRequest(@NotNull String fileName2, @Nullable String title) {
        if (fileName2 == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(1);
        }
        boolean knownFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName2) != UnknownFileType.INSTANCE;
        this.myFileName = knownFileType ? null : fileName2;
        this.myTitle = title;
    }

    @NotNull
    public JComponent getComponent(@NotNull DiffContext context) {
        if (context == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(2);
        }
        SimpleColoredComponent label2 = new SimpleColoredComponent();
        label2.setTextAlign(0);
        label2.append("Can't show diff for unknown file type. ");
        if (this.myFileName != null) {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color linkColor = (Color)ObjectUtils.chooseNotNull((Object)scheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor(), (Object)JBUI.CurrentTheme.Link.linkColor());
            label2.append("Associate", new SimpleTextAttributes(0, linkColor), () -> {
                FileType type = FileTypeChooser.associateFileType(this.myFileName);
                if (type != null) {
                    this.onSuccess(context);
                }
            });
            LinkMouseListenerBase.installSingleTagOn(label2);
        }
        JPanel jPanel = DiffUtil.createMessagePanel((JComponent)label2);
        if (jPanel == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    protected void onSuccess(@NotNull DiffContext context) {
        if (context == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(4);
        }
        if (context instanceof DiffContextEx) {
            ((DiffContextEx)context).reloadDiffRequest();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/requests/UnknownFileTypeDiffRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/requests/UnknownFileTypeDiffRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

