/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.importProject.RootsDetectionStep;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.ImportFromSourcesProvider;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.ModuleDeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceImpl;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.importProject.CloudGitChooseAccountStepBase;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class CloudGitRemoteDetector
implements GitRepositoryChangeListener,
ProjectComponent {
    private final Project myProject;
    private final CloudNotifier myNotifier;
    private final List<CloudTypeDelegate> myDelegates;

    public CloudGitRemoteDetector(Project project) {
        this.myProject = project;
        this.myNotifier = new CloudNotifier("Git remotes detector");
        this.myDelegates = new ArrayList<CloudTypeDelegate>();
        for (CloudGitDeploymentDetector deploymentDetector : CloudGitDeploymentDetector.EP_NAME.getExtensionList()) {
            this.myDelegates.add(new CloudTypeDelegate(deploymentDetector));
        }
    }

    public void projectOpened() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                CloudGitRemoteDetector.this.onRunConfigurationAddedOrChanged(settings);
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                CloudGitRemoteDetector.this.onRunConfigurationAddedOrChanged(settings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/remoteServer/util/importProject/CloudGitRemoteDetector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onRunConfigurationAddedOrChanged(RunnerAndConfigurationSettings settings) {
        RunConfiguration runConfiguration = settings.getConfiguration();
        for (CloudTypeDelegate delegate : this.myDelegates) {
            delegate.onRunConfigurationAddedOrChanged(runConfiguration);
        }
    }

    public void repositoryChanged(@NotNull GitRepository repository) {
        if (repository == null) {
            CloudGitRemoteDetector.$$$reportNull$$$0(0);
        }
        for (CloudTypeDelegate delegate : this.myDelegates) {
            delegate.repositoryChanged(repository);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/remoteServer/util/importProject/CloudGitRemoteDetector", "repositoryChanged"));
    }

    private class RepositoryNotifier {
        private final CloudGitDeploymentDetector myDeploymentDetector;
        private final VirtualFile myRepositoryRoot;
        private final Notification myNotification;
        private final String myCloudName;
        private String myApplicationName;

        RepositoryNotifier(CloudGitDeploymentDetector deploymentDetector, GitRepository repository) {
            this.myDeploymentDetector = deploymentDetector;
            this.myRepositoryRoot = repository.getRoot();
            this.myCloudName = deploymentDetector.getCloudType().getPresentableName();
            String path = FileUtil.toSystemDependentName((String)this.myRepositoryRoot.getPath());
            this.myNotification = CloudGitRemoteDetector.this.myNotifier.showMessage(CloudBundle.getText((String)"git.cloud.app.detected", (Object[])new Object[]{this.myCloudName, path}), MessageType.INFO, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    RepositoryNotifier.this.setupRunConfiguration();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/remoteServer/util/importProject/CloudGitRemoteDetector$RepositoryNotifier$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public void setApplicationName(String applicationName) {
            this.myApplicationName = applicationName;
        }

        public void expire() {
            this.myNotification.expire();
        }

        public void setupRunConfiguration() {
            Module targetModule = null;
            for (Module module : ModuleManager.getInstance((Project)CloudGitRemoteDetector.this.myProject).getModules()) {
                if (!this.myRepositoryRoot.equals(ModuleDeploymentSourceImpl.getContentRoot((Module)module))) continue;
                targetModule = module;
                break;
            }
            if (targetModule == null) {
                AddModuleWizard wizard = new AddModuleWizard(CloudGitRemoteDetector.this.myProject, this.myRepositoryRoot.getPath(), new ProjectImportProvider[]{new ImportFromSourcesProvider()});
                wizard.navigateToStep(step -> step instanceof RootsDetectionStep);
                if (wizard.getStepCount() > 0 && !wizard.showAndGet()) {
                    return;
                }
                ImportModuleAction.createFromWizard((Project)CloudGitRemoteDetector.this.myProject, (AbstractProjectWizard)wizard);
            } else {
                final Ref chooseAccountStepRef = new Ref();
                if (!new AbstractProjectWizard(CloudBundle.getText((String)"choose.account.wizzard.title", (Object[])new Object[]{this.myCloudName}), CloudGitRemoteDetector.this.myProject, null){
                    final StepSequence myStepSequence;
                    {
                        super(x0, x1, x2);
                        CloudGitChooseAccountStepBase chooseAccountStep = new CloudGitChooseAccountStepBase(RepositoryNotifier.this.myDeploymentDetector, this.myWizardContext);
                        chooseAccountStepRef.set((Object)chooseAccountStep);
                        this.myStepSequence = new StepSequence(new ModuleWizardStep[]{chooseAccountStep});
                        this.addStep((Step)chooseAccountStep);
                        this.init();
                    }

                    public StepSequence getSequence() {
                        return this.myStepSequence;
                    }
                }.showAndGet()) {
                    return;
                }
                ((CloudGitChooseAccountStepBase)((Object)chooseAccountStepRef.get())).createRunConfiguration(targetModule, this.myApplicationName);
            }
        }
    }

    private class CloudTypeDelegate {
        private final CloudGitDeploymentDetector myDeploymentDetector;
        private final Map<GitRepository, RepositoryNotifier> myRepositoryToNotifier = new HashMap();

        CloudTypeDelegate(CloudGitDeploymentDetector deploymentDetector) {
            this.myDeploymentDetector = deploymentDetector;
        }

        private ServerType getCloudType() {
            return this.myDeploymentDetector.getCloudType();
        }

        public void repositoryChanged(@NotNull GitRepository repository) {
            String applicationName;
            if (repository == null) {
                CloudTypeDelegate.$$$reportNull$$$0(0);
            }
            if ((applicationName = this.myDeploymentDetector.getFirstApplicationName(repository)) == null) {
                this.forget(repository);
            } else {
                RepositoryNotifier notifier = this.myRepositoryToNotifier.get(repository);
                if (notifier == null && !this.hasRunConfig4Repository(repository)) {
                    notifier = new RepositoryNotifier(this.myDeploymentDetector, repository);
                    this.myRepositoryToNotifier.put(repository, notifier);
                }
                if (notifier != null) {
                    notifier.setApplicationName(applicationName);
                }
            }
        }

        private boolean hasRunConfig4Repository(GitRepository repository) {
            List runConfigurations = RunManager.getInstance((Project)CloudGitRemoteDetector.this.myProject).getConfigurationsList((ConfigurationType)DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType((ServerType)this.getCloudType()));
            VirtualFile repositoryRoot = repository.getRoot();
            for (RunConfiguration runConfiguration : runConfigurations) {
                if (!repositoryRoot.equals(this.getContentRoot(runConfiguration))) continue;
                return true;
            }
            return false;
        }

        private VirtualFile getContentRoot(RunConfiguration runConfiguration) {
            if (!(runConfiguration instanceof DeployToServerRunConfiguration)) {
                return null;
            }
            DeployToServerRunConfiguration deployRunConfiguration = (DeployToServerRunConfiguration)runConfiguration;
            if (deployRunConfiguration.getServerType() != this.getCloudType()) {
                return null;
            }
            DeploymentSource deploymentSource = deployRunConfiguration.getDeploymentSource();
            if (!(deploymentSource instanceof ModuleDeploymentSource)) {
                return null;
            }
            return ((ModuleDeploymentSource)deploymentSource).getContentRoot();
        }

        public void onRunConfigurationAddedOrChanged(RunConfiguration runConfiguration) {
            VirtualFile contentRoot = this.getContentRoot(runConfiguration);
            if (contentRoot == null) {
                return;
            }
            GitRepository repository = (GitRepository)GitRepositoryManager.getInstance((Project)CloudGitRemoteDetector.this.myProject).getRepositoryForRoot(contentRoot);
            if (repository == null) {
                return;
            }
            this.forget(repository);
        }

        private void forget(GitRepository repository) {
            RepositoryNotifier notifier = this.myRepositoryToNotifier.remove(repository);
            if (notifier != null) {
                notifier.expire();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/remoteServer/util/importProject/CloudGitRemoteDetector$CloudTypeDelegate", "repositoryChanged"));
        }
    }
}

