/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.completion.PyCompletionUtilsKt;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PointInImport;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyModuleMembersProvider;
import com.jetbrains.python.psi.types.PyOverridingModuleMembersProvider;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyModuleType
implements PyType {
    @NotNull
    private final PyFile myModule;
    public static final ImmutableSet<String> MODULE_MEMBERS = ImmutableSet.of((Object)"__name__", (Object)"__file__", (Object)"__path__", (Object)"__doc__", (Object)"__dict__", (Object)"__package__", (Object[])new String[0]);

    public PyModuleType(@NotNull PyFile source) {
        if (source == null) {
            PyModuleType.$$$reportNull$$$0(0);
        }
        this.myModule = source;
    }

    @NotNull
    public PyFile getModule() {
        PyFile pyFile = this.myModule;
        if (pyFile == null) {
            PyModuleType.$$$reportNull$$$0(1);
        }
        return pyFile;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(2);
        }
        if (direction == null) {
            PyModuleType.$$$reportNull$$$0(3);
        }
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(4);
        }
        return PyModuleType.resolveMemberInPackageOrModule(null, (PsiFileSystemItem)this.myModule, name, location, resolveContext);
    }

    @Nullable
    public static List<? extends RatedResolveResult> resolveMemberInPackageOrModule(@Nullable PyImportedModule importedModule, @NotNull PsiFileSystemItem anchor, @NotNull String name, @Nullable PyExpression location, @NotNull PyResolveContext resolveContext) {
        PsiElement member;
        PyFile module2;
        if (anchor == null) {
            PyModuleType.$$$reportNull$$$0(5);
        }
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(6);
        }
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(7);
        }
        if ((module2 = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)anchor), PyFile.class)) != null) {
            PsiElement overridingMember = PyModuleType.resolveByOverridingMembersProviders(module2, name, resolveContext);
            if (overridingMember != null) {
                return ResolveResultList.to(overridingMember);
            }
            List<RatedResolveResult> attributes = module2.multiResolveName(name);
            if (!attributes.isEmpty()) {
                return attributes;
            }
        }
        if (PyUtil.isPackage(anchor, (PsiElement)location)) {
            ResolveResultList implicitMembers = new ResolveResultList();
            PyModuleType.processImplicitPackageMembers(anchor, (PsiElement)location, importedModule, n -> name.endsWith((String)n), (Processor<List<? extends RatedResolveResult>>)((Processor)results -> {
                implicitMembers.addAll(PyModuleType.convertDirsToInit(results));
                return implicitMembers.isEmpty();
            }));
            if (!implicitMembers.isEmpty()) {
                return implicitMembers;
            }
        }
        if (module2 != null && (member = PyModuleType.resolveByMembersProviders(module2, name, resolveContext)) != null) {
            return ResolveResultList.to(member);
        }
        return null;
    }

    private static void processImplicitPackageMembers(@NotNull PsiFileSystemItem anchor, @Nullable PsiElement location, @Nullable PyImportedModule importedModule, @NotNull Predicate<String> filter, @NotNull Processor<List<? extends RatedResolveResult>> resultProcessor) {
        PyImportElement origImportElement;
        PyFile footHold;
        if (anchor == null) {
            PyModuleType.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            PyModuleType.$$$reportNull$$$0(9);
        }
        if (resultProcessor == null) {
            PyModuleType.$$$reportNull$$$0(10);
        }
        ArrayList<PyImportElement> importElements = new ArrayList<PyImportElement>();
        PyFile module2 = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)anchor), PyFile.class);
        if (anchor.getVirtualFile() == null) {
            return;
        }
        PyFile pyFile = footHold = location != null ? location.getContainingFile() : module2;
        if (footHold == null) {
            return;
        }
        PyImportElement pyImportElement = origImportElement = importedModule != null ? importedModule.getImportElement() : null;
        if (!(importedModule == null || location != null && PyUtil.inSameFile(location, (PsiElement)importedModule))) {
            if (origImportElement != null) {
                importElements.add(origImportElement);
            }
        } else if (location != null) {
            ScopeOwner owner = ScopeUtil.getScopeOwner(location);
            if (owner != null) {
                importElements.addAll(PyModuleType.getVisibleImports(owner));
            }
            if (module2 != null) {
                if (!PyUtil.inSameFile(location, (PsiElement)module2)) {
                    importElements.addAll(module2.getImportTargets());
                }
                List<PyFromImportStatement> imports = module2.getFromImports();
                for (PyFromImportStatement anImport : imports) {
                    Collections.addAll(importElements, anImport.getImportElements());
                }
            }
        }
        if (importElements.isEmpty()) {
            return;
        }
        HashSet seen = Sets.newHashSet();
        if (!PyModuleType.processImplicitlyImportedByImportElements(anchor, (PsiElement)footHold, importElements, name -> filter.test((String)name) && seen.add(name), resultProcessor)) {
            return;
        }
        if (location != null) {
            PyModuleType.processImplicitlyImportedByLocation(anchor, location, name -> filter.test((String)name) && seen.add(name), resultProcessor);
        }
    }

    private static boolean processImplicitlyImportedByImportElements(@NotNull PsiFileSystemItem anchor, @NotNull PsiElement footHold, @NotNull List<PyImportElement> importElements, @NotNull Predicate<String> filter, @NotNull Processor<List<? extends RatedResolveResult>> resultProcessor) {
        if (anchor == null) {
            PyModuleType.$$$reportNull$$$0(11);
        }
        if (footHold == null) {
            PyModuleType.$$$reportNull$$$0(12);
        }
        if (importElements == null) {
            PyModuleType.$$$reportNull$$$0(13);
        }
        if (filter == null) {
            PyModuleType.$$$reportNull$$$0(14);
        }
        if (resultProcessor == null) {
            PyModuleType.$$$reportNull$$$0(15);
        }
        PyFile module2 = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)anchor), PyFile.class);
        List<QualifiedName> packageQNames = QualifiedNameFinder.findImportableQNames(footHold, anchor.getVirtualFile());
        for (PyImportElement importElement : importElements) {
            for (QualifiedName packageQName : packageQNames) {
                for (QualifiedName importedQName : PyModuleType.getImportedQNames(importElement)) {
                    List<RatedResolveResult> results;
                    String directChild = PyModuleType.findFirstComponentAfterPrefix(importedQName, packageQName);
                    if (directChild == null || !filter.test(directChild) || resultProcessor.process(ResolveResultList.asImportedResults(results = ResolveImportUtil.resolveChildren((PsiElement)anchor, directChild, module2, true, true, false, false), importElement))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void processImplicitlyImportedByLocation(@NotNull PsiFileSystemItem anchor, @NotNull PsiElement location, @NotNull Predicate<String> filter, @NotNull Processor<List<? extends RatedResolveResult>> resultProcessor) {
        if (anchor == null) {
            PyModuleType.$$$reportNull$$$0(16);
        }
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(17);
        }
        if (filter == null) {
            PyModuleType.$$$reportNull$$$0(18);
        }
        if (resultProcessor == null) {
            PyModuleType.$$$reportNull$$$0(19);
        }
        if (location.getContainingFile().getVirtualFile() == null) {
            return;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner(location);
        if (owner == null) {
            return;
        }
        List<PyImportElement> visibleImports = PyModuleType.getVisibleImports(owner);
        PyFile module2 = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)anchor), PyFile.class);
        List<QualifiedName> packageQNames = QualifiedNameFinder.findImportableQNames((PsiElement)location.getContainingFile(), anchor.getVirtualFile());
        List<QualifiedName> locationQNames = QualifiedNameFinder.findImportableQNames(location, location.getContainingFile().getVirtualFile());
        for (QualifiedName locationQName : locationQNames) {
            for (QualifiedName packageQName : packageQNames) {
                List<RatedResolveResult> results;
                String directChild = PyModuleType.findFirstComponentAfterPrefix(locationQName, packageQName);
                if (directChild == null || !filter.test(directChild)) continue;
                QualifiedName mainPackage = QualifiedName.fromComponents((String[])new String[]{locationQName.getFirstComponent()});
                PyImportElement packageImportElement = visibleImports.stream().filter(el -> PyModuleType.getImportedQNames(el).stream().anyMatch(qName -> qName.matchesPrefix(mainPackage))).findFirst().orElse(null);
                if (packageImportElement == null || resultProcessor.process(ResolveResultList.asImportedResults(results = ResolveImportUtil.resolveChildren((PsiElement)anchor, directChild, module2, true, true, false, false), packageImportElement))) continue;
                return;
            }
        }
    }

    @Nullable
    private static String findFirstComponentAfterPrefix(@NotNull QualifiedName qualifiedName, @NotNull QualifiedName prefix) {
        if (qualifiedName == null) {
            PyModuleType.$$$reportNull$$$0(20);
        }
        if (prefix == null) {
            PyModuleType.$$$reportNull$$$0(21);
        }
        if (qualifiedName.matchesPrefix(prefix) && qualifiedName.getComponentCount() > prefix.getComponentCount()) {
            return qualifiedName.removeHead(prefix.getComponentCount()).getFirstComponent();
        }
        return null;
    }

    @NotNull
    private static List<? extends RatedResolveResult> convertDirsToInit(@NotNull List<? extends RatedResolveResult> ratedResolveList) {
        if (ratedResolveList == null) {
            PyModuleType.$$$reportNull$$$0(22);
        }
        List list = ContainerUtil.map(ratedResolveList, result -> {
            PsiElement element = result.getElement();
            if (element instanceof PsiDirectory) {
                PsiElement pkgInit = PyUtil.turnDirIntoInit(element);
                return pkgInit != null ? result.replace(pkgInit) : result;
            }
            return result;
        });
        if (list == null) {
            PyModuleType.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Nullable
    private static PsiElement resolveByMembersProviders(PyFile module2, String name, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(24);
        }
        for (PyModuleMembersProvider provider : PyModuleMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement element;
            if (provider instanceof PyOverridingModuleMembersProvider || (element = provider.resolveMember(module2, name, resolveContext)) == null) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingMembersProviders(@NotNull PyFile module2, @NotNull String name, @NotNull PyResolveContext resolveContext) {
        if (module2 == null) {
            PyModuleType.$$$reportNull$$$0(25);
        }
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(26);
        }
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(27);
        }
        for (PyModuleMembersProvider provider : PyModuleMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement element;
            if (!(provider instanceof PyOverridingModuleMembersProvider) || (element = provider.resolveMember(module2, name, resolveContext)) == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    private static List<QualifiedName> getImportedQNames(@NotNull PyImportElement element) {
        QualifiedName importedQName;
        if (element == null) {
            PyModuleType.$$$reportNull$$$0(28);
        }
        ArrayList<QualifiedName> importedQNames = new ArrayList<QualifiedName>();
        PyStatement stmt = element.getContainingImportStatement();
        PyFromImportStatement fromImportStatement = (PyFromImportStatement)ObjectUtils.tryCast((Object)stmt, PyFromImportStatement.class);
        if (fromImportStatement != null) {
            importedQName = fromImportStatement.getImportSourceQName();
            String visibleName = element.getVisibleName();
            if (importedQName != null) {
                importedQNames.add(importedQName);
                if (visibleName != null) {
                    importedQNames.add(importedQName.append(visibleName));
                }
            } else {
                List<PsiElement> elements = ResolveImportUtil.resolveFromImportStatementSource(fromImportStatement, element.getImportedQName());
                for (PsiElement psiElement : elements) {
                    VirtualFile virtualFile;
                    QualifiedName qName;
                    if (!(psiElement instanceof PsiFile) || (qName = QualifiedNameFinder.findShortestImportableQName((PsiElement)element, virtualFile = ((PsiFile)psiElement).getVirtualFile())) == null) continue;
                    importedQNames.add(qName);
                }
            }
        } else if (stmt instanceof PyImportStatement && (importedQName = element.getImportedQName()) != null) {
            importedQNames.add(importedQName);
        }
        if (!ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)element) || fromImportStatement != null && fromImportStatement.getRelativeLevel() == 1) {
            PsiFile file = element.getContainingFile();
            if (file != null) {
                file = file.getOriginalFile();
            }
            QualifiedName absoluteQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)file);
            if (file != null && absoluteQName != null) {
                QualifiedName prefixQName;
                QualifiedName qualifiedName = prefixQName = PyUtil.isPackage(file) ? absoluteQName : absoluteQName.removeLastComponent();
                if (prefixQName.getComponentCount() > 0) {
                    ArrayList<QualifiedName> results = new ArrayList<QualifiedName>(importedQNames);
                    for (QualifiedName qName : importedQNames) {
                        ArrayList components = new ArrayList();
                        components.addAll(prefixQName.getComponents());
                        components.addAll(qName.getComponents());
                        results.add(QualifiedName.fromComponents(components));
                    }
                    ArrayList<QualifiedName> arrayList = results;
                    if (arrayList == null) {
                        PyModuleType.$$$reportNull$$$0(29);
                    }
                    return arrayList;
                }
            }
        }
        ArrayList<QualifiedName> arrayList = importedQNames;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyImportElement> getVisibleImports(@NotNull ScopeOwner owner) {
        if (owner == null) {
            PyModuleType.$$$reportNull$$$0(31);
        }
        final ArrayList<PyImportElement> visibleImports = new ArrayList<PyImportElement>();
        PyResolveUtil.scopeCrawlUp(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof PyImportElement) {
                    visibleImports.add((PyImportElement)element);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/types/PyModuleType$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, owner, null, null);
        ArrayList<PyImportElement> arrayList = visibleImports;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiFileSystemItem> getSubmodulesList(@Nullable PsiDirectory directory2, @Nullable PsiElement anchor) {
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        if (directory2 != null) {
            for (PsiFile psiFile : directory2.getFiles()) {
                String filename = psiFile.getName();
                if ((PyModuleType.isExcluded((PsiFileSystemItem)psiFile) || !(psiFile instanceof PyFile) || filename.equals("__init__.py")) && !PyModuleType.isBinaryModule(filename)) continue;
                result.add((PsiFileSystemItem)psiFile);
            }
            for (PsiFile psiFile : directory2.getSubdirectories()) {
                if (PyModuleType.isExcluded((PsiFileSystemItem)psiFile) || !PyUtil.isPackage((PsiDirectory)psiFile, anchor)) continue;
                result.add((PsiFileSystemItem)psiFile);
            }
        }
        ArrayList<PsiFileSystemItem> arrayList = result;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    private static boolean isExcluded(@NotNull PsiFileSystemItem file) {
        if (file == null) {
            PyModuleType.$$$reportNull$$$0(34);
        }
        return FileIndexFacade.getInstance((Project)file.getProject()).isExcludedFile(file.getVirtualFile());
    }

    private static boolean isBinaryModule(String filename) {
        String ext = FileUtilRt.getExtension((String)filename);
        if (SystemInfo.isWindows) {
            return "pyd".equalsIgnoreCase(ext);
        }
        return "so".equals(ext);
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(location.getProject(), location.getContainingFile());
        List<LookupElement> result = this.getCompletionVariantsAsLookupElements(location, context, false, false, typeEvalContext);
        return result.toArray();
    }

    @NotNull
    public List<LookupElement> getCompletionVariantsAsLookupElements(@NotNull PsiElement location, @NotNull ProcessingContext context, boolean wantAllSubmodules, boolean suppressParentheses, @NotNull TypeEvalContext typeEvalContext) {
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(35);
        }
        if (context == null) {
            PyModuleType.$$$reportNull$$$0(36);
        }
        if (typeEvalContext == null) {
            PyModuleType.$$$reportNull$$$0(37);
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        Set namesAlready = (Set)context.get(CTX_NAMES);
        PointInImport point = ResolveImportUtil.getPointInImport(location);
        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(typeEvalContext);
        for (PyModuleMembersProvider provider : PyModuleMembersProvider.EP_NAME.getExtensionList()) {
            for (PyCustomMember member : provider.getMembers(this.myModule, point, typeEvalContext)) {
                String name = member.getName();
                if (namesAlready != null) {
                    namesAlready.add(name);
                }
                if (PyUtil.isClassPrivateName(name)) continue;
                CompletionVariantsProcessor processor2 = PyModuleType.createCompletionVariantsProcessor(location, suppressParentheses, point);
                PsiElement resolved = member.resolve(location, resolveContext);
                if (resolved != null) {
                    LookupElement element;
                    processor2.execute(resolved, ResolveState.initial());
                    List<LookupElement> lookupList = processor2.getResultList();
                    if (!lookupList.isEmpty() && name.equals((element = lookupList.get(0)).getLookupString())) {
                        result.add(element);
                        continue;
                    }
                }
                result.add((LookupElement)LookupElementBuilder.create((String)name).withIcon(member.getIcon()).withTypeText(member.getShortType()));
            }
        }
        if (point == PointInImport.NONE || point == PointInImport.AS_NAME) {
            CompletionVariantsProcessor processor3 = PyModuleType.createCompletionVariantsProcessor(location, suppressParentheses, point);
            this.myModule.processDeclarations(processor3, ResolveState.initial(), null, location);
            if (namesAlready != null) {
                for (LookupElement le : processor3.getResultList()) {
                    String name = le.getLookupString();
                    if (namesAlready.contains(name)) continue;
                    result.add(le);
                    namesAlready.add(name);
                }
            } else {
                result.addAll(processor3.getResultList());
            }
        }
        if (PyUtil.isPackage(this.myModule)) {
            if (point == PointInImport.AS_MODULE || point == PointInImport.AS_NAME || wantAllSubmodules) {
                result.addAll(PyModuleType.getSubModuleVariants(this.myModule.getContainingDirectory(), location, namesAlready));
            } else {
                result.addAll(PyModuleType.collectImportedSubmodulesAsLookupElements((PsiFileSystemItem)this.myModule, location, namesAlready));
            }
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    private static CompletionVariantsProcessor createCompletionVariantsProcessor(PsiElement location, boolean suppressParentheses, PointInImport point) {
        Condition nodeFilter = psiElement -> !(psiElement instanceof PyImportElement) || PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyImportStatementBase.class) instanceof PyFromImportStatement;
        CompletionVariantsProcessor completionVariantsProcessor = new CompletionVariantsProcessor(location, (Condition<PsiElement>)nodeFilter, null, point == PointInImport.AS_NAME, suppressParentheses);
        if (completionVariantsProcessor == null) {
            PyModuleType.$$$reportNull$$$0(39);
        }
        return completionVariantsProcessor;
    }

    @NotNull
    public static List<LookupElement> collectImportedSubmodulesAsLookupElements(@NotNull PsiFileSystemItem pyPackage, @NotNull PsiElement location, @Nullable Set<? super String> existingNames) {
        if (pyPackage == null) {
            PyModuleType.$$$reportNull$$$0(40);
        }
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(41);
        }
        ArrayList elements = new ArrayList();
        PyModuleType.processImplicitPackageMembers(pyPackage, location, null, any -> true, (Processor<List<? extends RatedResolveResult>>)((Processor)results -> {
            elements.addAll(ResolveResultList.getElements(results));
            return true;
        }));
        List list = ContainerUtil.mapNotNull(elements, element -> {
            if (element instanceof PsiFileSystemItem) {
                return PyModuleType.buildFileLookupElement(location.getContainingFile(), (PsiFileSystemItem)element, existingNames);
            }
            if (element instanceof PsiNamedElement) {
                return LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)element));
            }
            return null;
        });
        if (list == null) {
            PyModuleType.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    public static List<LookupElement> getSubModuleVariants(@Nullable PsiDirectory directory2, @NotNull PsiElement location, @Nullable Set<? super String> namesAlready) {
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(43);
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        for (PsiFileSystemItem item : PyModuleType.getSubmodulesList(directory2, location)) {
            LookupElementBuilder lookupElement;
            if (item == location.getContainingFile().getOriginalFile() || (lookupElement = PyModuleType.buildFileLookupElement(location.getContainingFile(), item, namesAlready)) == null) continue;
            result.add((LookupElement)lookupElement);
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    @Nullable
    public static LookupElementBuilder buildFileLookupElement(PsiFile file, PsiFileSystemItem item, @Nullable Set<? super String> existingNames) {
        String s = FileUtilRt.getNameWithoutExtension((String)item.getName());
        if (!PyNames.isIdentifier(s)) {
            return null;
        }
        if (existingNames != null) {
            if (existingNames.contains(s)) {
                return null;
            }
            existingNames.add(s);
        }
        return PyCompletionUtilsKt.createLookupElementBuilder(file, item);
    }

    @Override
    public String getName() {
        return this.myModule.getName();
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Override
    public void assertValid(String message) {
        if (!this.myModule.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this.myModule, this.myModule.getClass().toString() + ": " + message);
        }
    }

    @NotNull
    public static Set<String> getPossibleInstanceMembers() {
        ImmutableSet<String> immutableSet = MODULE_MEMBERS;
        if (immutableSet == null) {
            PyModuleType.$$$reportNull$$$0(45);
        }
        return immutableSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 23: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 23: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 23: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyModuleType";
                break;
            }
            case 2: 
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 4: 
            case 7: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultProcessor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "footHold";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importElements";
                break;
            }
            case 17: 
            case 35: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ratedResolveList";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyModuleType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDirsToInit";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedQNames";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleImports";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubmodulesList";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariantsAsLookupElements";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionVariantsProcessor";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImportedSubmodulesAsLookupElements";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubModuleVariants";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleInstanceMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 23: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberInPackageOrModule";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitPackageMembers";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitlyImportedByImportElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitlyImportedByLocation";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findFirstComponentAfterPrefix";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertDirsToInit";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveByMembersProviders";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveByOverridingMembersProviders";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getImportedQNames";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleImports";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariantsAsLookupElements";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collectImportedSubmodulesAsLookupElements";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSubModuleVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 23: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

