# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class Xdmf3Reader(DataObjectAlgorithm):
    """
    Xdmf3Reader - Reads e_xtensible Data Model and Formatfiles
    
    Superclass: DataObjectAlgorithm
    
    Xdmf3Reader reads XDMF data files so that they can be visualized
    using VTK. The output data produced by this reader depends on the
    number of grids in the data file. If the data file has a single
    domain with a single grid, then the output type is a DataSet
    subclass of the appropriate type, otherwise it's a
    MultiBlockDataSet.
    
    @warning
    Uses the XDMF API (http://www.xdmf.org)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXdmf3Reader, obj, update, **traits)
    
    def get_cell_array_status(self, *args):
        """
        V.get_cell_array_status(string) -> int
        C++: int GetCellArrayStatus(const char *name)
        Get information about cell-based arrays.  As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
        ret = self._wrap_call(self._vtk_obj.GetCellArrayStatus, *args)
        return ret

    def set_cell_array_status(self, *args):
        """
        V.set_cell_array_status(string, int)
        C++: void SetCellArrayStatus(const char *name, int status)
        Get information about cell-based arrays.  As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
        ret = self._wrap_call(self._vtk_obj.SetCellArrayStatus, *args)
        return ret

    def get_field_array_status(self, *args):
        """
        V.get_field_array_status(string) -> int
        C++: int GetFieldArrayStatus(const char *name)
        Get information about unaligned arrays.  As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
        ret = self._wrap_call(self._vtk_obj.GetFieldArrayStatus, *args)
        return ret

    def set_field_array_status(self, *args):
        """
        V.set_field_array_status(string, int)
        C++: void SetFieldArrayStatus(const char *name, int status)
        Get information about unaligned arrays.  As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
        ret = self._wrap_call(self._vtk_obj.SetFieldArrayStatus, *args)
        return ret

    file_series_as_time = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        """
        When true (the default) the reader treats a series of files as a
        temporal collection. When false it treats it as a spatial
        partition and uses an optimized top level partitioning strategy.
        """
    )

    def _file_series_as_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileSeriesAsTime,
                        self.file_series_as_time)

    def get_grid_status(self, *args):
        """
        V.get_grid_status(string) -> int
        C++: int GetGridStatus(const char *gridname)
        Get/Set information about grids. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called.
        """
        ret = self._wrap_call(self._vtk_obj.GetGridStatus, *args)
        return ret

    def set_grid_status(self, *args):
        """
        V.set_grid_status(string, int)
        C++: void SetGridStatus(const char *gridname, int status)
        Get/Set information about grids. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called.
        """
        ret = self._wrap_call(self._vtk_obj.SetGridStatus, *args)
        return ret

    def get_point_array_status(self, *args):
        """
        V.get_point_array_status(string) -> int
        C++: int GetPointArrayStatus(const char *name)
        Get/Set the point array status.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointArrayStatus, *args)
        return ret

    def set_point_array_status(self, *args):
        """
        V.set_point_array_status(string, int)
        C++: void SetPointArrayStatus(const char *name, int status)
        Get/Set the point array status.
        """
        ret = self._wrap_call(self._vtk_obj.SetPointArrayStatus, *args)
        return ret

    def get_set_status(self, *args):
        """
        V.get_set_status(string) -> int
        C++: int GetSetStatus(const char *gridname)
        Get/Set information about sets. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called. Note that sets with non-zero
        Ghost value are not treated as sets that the user can select
        using this API.
        """
        ret = self._wrap_call(self._vtk_obj.GetSetStatus, *args)
        return ret

    def set_set_status(self, *args):
        """
        V.set_set_status(string, int)
        C++: void SetSetStatus(const char *gridname, int status)
        Get/Set information about sets. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called. Note that sets with non-zero
        Ghost value are not treated as sets that the user can select
        using this API.
        """
        ret = self._wrap_call(self._vtk_obj.SetSetStatus, *args)
        return ret

    def get_cell_array_name(self, *args):
        """
        V.get_cell_array_name(int) -> string
        C++: const char *GetCellArrayName(int index)
        Get information about cell-based arrays.  As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
        ret = self._wrap_call(self._vtk_obj.GetCellArrayName, *args)
        return ret

    def get_field_array_name(self, *args):
        """
        V.get_field_array_name(int) -> string
        C++: const char *GetFieldArrayName(int index)
        Get information about unaligned arrays.  As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
        ret = self._wrap_call(self._vtk_obj.GetFieldArrayName, *args)
        return ret

    def get_grid_name(self, *args):
        """
        V.get_grid_name(int) -> string
        C++: const char *GetGridName(int index)
        Get/Set information about grids. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called.
        """
        ret = self._wrap_call(self._vtk_obj.GetGridName, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_cell_arrays(self):
        return self._vtk_obj.GetNumberOfCellArrays()
    number_of_cell_arrays = traits.Property(_get_number_of_cell_arrays, desc=\
        """
        Get information about cell-based arrays.  As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
    )

    def _get_number_of_field_arrays(self):
        return self._vtk_obj.GetNumberOfFieldArrays()
    number_of_field_arrays = traits.Property(_get_number_of_field_arrays, desc=\
        """
        Get information about unaligned arrays.  As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
    )

    def _get_number_of_grids(self):
        return self._vtk_obj.GetNumberOfGrids()
    number_of_grids = traits.Property(_get_number_of_grids, desc=\
        """
        Get/Set information about grids. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called.
        """
    )

    def _get_number_of_point_arrays(self):
        return self._vtk_obj.GetNumberOfPointArrays()
    number_of_point_arrays = traits.Property(_get_number_of_point_arrays, desc=\
        """
        Get information about point-based arrays. As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
    )

    def _get_number_of_set_arrays(self):
        return self._vtk_obj.GetNumberOfSetArrays()
    number_of_set_arrays = traits.Property(_get_number_of_set_arrays, desc=\
        """
        These methods are provided to make it easier to use the Sets in
        para_view.
        """
    )

    def _get_number_of_sets(self):
        return self._vtk_obj.GetNumberOfSets()
    number_of_sets = traits.Property(_get_number_of_sets, desc=\
        """
        Get/Set information about sets. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called. Note that sets with non-zero
        Ghost value are not treated as sets that the user can select
        using this API.
        """
    )

    def get_point_array_name(self, *args):
        """
        V.get_point_array_name(int) -> string
        C++: const char *GetPointArrayName(int index)
        Returns the name of point array at the give index. Returns
        nullptr if index is invalid.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointArrayName, *args)
        return ret

    def _get_sil(self):
        return wrap_vtk(self._vtk_obj.GetSIL())
    sil = traits.Property(_get_sil, desc=\
        """
        SIL describes organization of/relationships between
        classifications eg. blocks/materials/hierarchies.
        """
    )

    def _get_sil_update_stamp(self):
        return self._vtk_obj.GetSILUpdateStamp()
    sil_update_stamp = traits.Property(_get_sil_update_stamp, desc=\
        """
        Every time the SIL is updated a this will return a different
        value.
        """
    )

    def get_set_array_name(self, *args):
        """
        V.get_set_array_name(int) -> string
        C++: const char *GetSetArrayName(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetSetArrayName, *args)
        return ret

    def get_set_array_status(self, *args):
        """
        V.get_set_array_status(string) -> int
        C++: int GetSetArrayStatus(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetSetArrayStatus, *args)
        return ret

    def get_set_name(self, *args):
        """
        V.get_set_name(int) -> string
        C++: const char *GetSetName(int index)
        Get/Set information about sets. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called. Note that sets with non-zero
        Ghost value are not treated as sets that the user can select
        using this API.
        """
        ret = self._wrap_call(self._vtk_obj.GetSetName, *args)
        return ret

    def add_file_name(self, *args):
        """
        V.add_file_name(string)
        C++: virtual void AddFileName(const char *filename)
        Add and remove give the reader a list of top level xml files to
        read. Whether the set is treated as a spatial or temporal
        collection depends on file_seriest_as_time.
        """
        ret = self._wrap_call(self._vtk_obj.AddFileName, *args)
        return ret

    def can_read_file(self, *args):
        """
        V.can_read_file(string) -> int
        C++: virtual int CanReadFile(const char *filename)
        Determine if the file can be read with this reader.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def remove_all_file_names(self):
        """
        V.remove_all_file_names()
        C++: virtual void RemoveAllFileNames()
        Add and remove give the reader a list of top level xml files to
        read. Whether the set is treated as a spatial or temporal
        collection depends on file_seriest_as_time.
        """
        ret = self._vtk_obj.RemoveAllFileNames()
        return ret
        

    def set_file_name(self, *args):
        """
        V.set_file_name(string)
        C++: void SetFileName(const char *filename)
        Set tells the reader the name of a single top level xml file to
        read.
        """
        ret = self._wrap_call(self._vtk_obj.SetFileName, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('file_series_as_time', 'GetFileSeriesAsTime'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'file_series_as_time', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Xdmf3Reader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Xdmf3Reader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_series_as_time']),
            title='Edit Xdmf3Reader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Xdmf3Reader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

