/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.JsAnnotations;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\u0002\u00a8\u0006\r"}, d2={"getJsModule", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "getJsName", "getJsNameOrKotlinName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getJsQualifier", "getSingleConstStringArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "isJsExport", "", "isJsNonModule", "backend.js"})
public final class AnnotationUtilsKt {
    @NotNull
    public static final String getSingleConstStringArgument(@NotNull IrConstructorCall $this$getSingleConstStringArgument) {
        Intrinsics.checkParameterIsNotNull($this$getSingleConstStringArgument, "$this$getSingleConstStringArgument");
        IrExpression irExpression = $this$getSingleConstStringArgument.getValueArgument(0);
        if (irExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<kotlin.String>");
        }
        return (String)((IrConst)irExpression).getValue();
    }

    @Nullable
    public static final String getJsModule(@NotNull IrAnnotationContainer $this$getJsModule) {
        Intrinsics.checkParameterIsNotNull($this$getJsModule, "$this$getJsModule");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsModule, JsAnnotations.INSTANCE.getJsModuleFqn());
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    public static final boolean isJsNonModule(@NotNull IrAnnotationContainer $this$isJsNonModule) {
        Intrinsics.checkParameterIsNotNull($this$isJsNonModule, "$this$isJsNonModule");
        return IrUtilsKt.hasAnnotation($this$isJsNonModule, JsAnnotations.INSTANCE.getJsNonModuleFqn());
    }

    @Nullable
    public static final String getJsQualifier(@NotNull IrAnnotationContainer $this$getJsQualifier) {
        Intrinsics.checkParameterIsNotNull($this$getJsQualifier, "$this$getJsQualifier");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsQualifier, JsAnnotations.INSTANCE.getJsQualifierFqn());
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    @Nullable
    public static final String getJsName(@NotNull IrAnnotationContainer $this$getJsName) {
        Intrinsics.checkParameterIsNotNull($this$getJsName, "$this$getJsName");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsName, JsAnnotations.INSTANCE.getJsNameFqn());
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    public static final boolean isJsExport(@NotNull IrAnnotationContainer $this$isJsExport) {
        Intrinsics.checkParameterIsNotNull($this$isJsExport, "$this$isJsExport");
        return IrUtilsKt.hasAnnotation($this$isJsExport, JsAnnotations.INSTANCE.getJsExportFqn());
    }

    @NotNull
    public static final Name getJsNameOrKotlinName(@NotNull IrDeclarationWithName $this$getJsNameOrKotlinName) {
        Name name;
        Intrinsics.checkParameterIsNotNull($this$getJsNameOrKotlinName, "$this$getJsNameOrKotlinName");
        String jsName = AnnotationUtilsKt.getJsName($this$getJsNameOrKotlinName);
        if (jsName == null) {
            name = $this$getJsNameOrKotlinName.getName();
        } else {
            Name name2 = Name.identifier(jsName);
            name = name2;
            Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(jsName)");
        }
        return name;
    }
}

