/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.util.ReverseCharSequence;

public class PatternSearchMatcher
extends SearchMatcher {
    private int flags;
    private Pattern re;
    private final String pattern;

    public PatternSearchMatcher(String string, boolean bl) {
        this.pattern = string;
        this.flags = PatternSearchMatcher.getFlag(bl);
    }

    public PatternSearchMatcher(Pattern pattern, boolean bl, boolean bl2) {
        this(pattern.pattern(), bl);
        this.re = pattern;
        this.wholeWord = bl2;
    }

    public PatternSearchMatcher(Pattern pattern, boolean bl) {
        this(pattern, bl, false);
    }

    @Override
    public SearchMatcher.Match nextMatch(CharSequence charSequence, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        Object object;
        Matcher matcher;
        if (charSequence instanceof ReverseCharSequence) {
            charSequence = ((ReverseCharSequence)charSequence).baseSequence();
        }
        if (this.re == null) {
            this.re = Pattern.compile(this.pattern, this.flags);
        }
        int n2 = 0;
        if (!bl && this.re.pattern().charAt(0) == '^') {
            matcher = Pattern.compile("^", this.flags).matcher(charSequence);
            matcher.find();
            if (!matcher.find()) {
                return null;
            }
            n2 = matcher.start();
        }
        if (!(matcher = this.re.matcher(charSequence)).find(n2) && !(matcher = ((Pattern)(object = PatternSearchMatcher.removeNonCapturingGroups(this.re, this.flags))).matcher(charSequence)).matches()) {
            return null;
        }
        if (!(bl4 || bl3 || matcher.start() != 0 || matcher.end() != 0 || matcher.find())) {
            return null;
        }
        object = null;
        while (true) {
            if (!(bl2 && charSequence.charAt(charSequence.length() - 1) != '\n' || matcher.end() != charSequence.length() || this.pattern.charAt(this.pattern.length() - 1) != '$')) {
                if (object != null) {
                    this.returnValue.start = ((SearchMatcher.Match)object).start;
                    this.returnValue.end = ((SearchMatcher.Match)object).end;
                    this.returnValue.substitutions = ((SearchMatcher.Match)object).substitutions;
                    break;
                }
                return null;
            }
            this.returnValue.substitutions = new String[matcher.groupCount() + 1];
            for (n = 0; n < this.returnValue.substitutions.length; ++n) {
                this.returnValue.substitutions[n] = matcher.group(n);
            }
            n = matcher.start();
            int n3 = matcher.end();
            this.returnValue.start = n;
            this.returnValue.end = n3;
            if (this.wholeWord && !this.isWholeWord(charSequence, n, n3)) {
                if (matcher.find()) continue;
                return null;
            }
            if (!bl4 || !matcher.find()) {
                if (!bl4 || bl3 || this.returnValue.start != charSequence.length() || this.returnValue.end != charSequence.length()) break;
                if (object != null) {
                    this.returnValue.start = ((SearchMatcher.Match)object).start;
                    this.returnValue.end = ((SearchMatcher.Match)object).end;
                    this.returnValue.substitutions = ((SearchMatcher.Match)object).substitutions;
                    break;
                }
                return null;
            }
            if (object == null) {
                object = new SearchMatcher.Match();
            }
            ((SearchMatcher.Match)object).start = this.returnValue.start;
            ((SearchMatcher.Match)object).end = this.returnValue.end;
            ((SearchMatcher.Match)object).substitutions = this.returnValue.substitutions;
        }
        if (bl4) {
            n = this.returnValue.end - this.returnValue.start;
            this.returnValue.start = charSequence.length() - this.returnValue.end;
            this.returnValue.end = this.returnValue.start + n;
        }
        return this.returnValue;
    }

    public static Pattern removeNonCapturingGroups(Pattern pattern, int n) {
        String string = pattern.pattern();
        String string2 = "[(][?].+?[)]";
        Pattern pattern2 = Pattern.compile(string2, n);
        Matcher matcher = pattern2.matcher(string);
        if (matcher.find()) {
            int n2 = matcher.start();
            int n3 = 0;
            for (int i = n2; i < string.length(); ++i) {
                if (string.charAt(i) == '(' && (i == 0 || string.charAt(i - 1) != '\\')) {
                    ++n3;
                }
                if (string.charAt(i) == ')' && (i == 0 || string.charAt(i - 1) != '\\')) {
                    --n3;
                }
                if (n3 != 0 || i >= string.length() - 1) continue;
                int n4 = i + 1;
                char c = string.charAt(n4);
                if (c == '{') {
                    while (c != '}' && n4 < string.length() - 1) {
                        c = string.charAt(++n4);
                    }
                    ++n4;
                }
                if (((c = string.charAt(n4)) == '?' || c == '+' || c == '*') && n4 < string.length() - 1) {
                    ++n4;
                }
                if (((c = string.charAt(n4)) == '?' || c == '+') && n4 < string.length() - 1) {
                    ++n4;
                }
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.delete(n2, n4);
                return PatternSearchMatcher.removeNonCapturingGroups(Pattern.compile(stringBuilder.toString(), n), n);
            }
        }
        return pattern;
    }

    public String toString() {
        boolean bl = (this.flags & 2) != 0;
        return "PatternSearchMatcher[" + this.pattern + ',' + bl + ']';
    }

    static int getFlag(boolean bl) {
        int n = 8;
        if (bl) {
            n |= 2;
        }
        return n;
    }
}

