/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gjt.sp.jedit.datatransfer.JEditTransferable;
import org.gjt.sp.jedit.datatransfer.JEditTransferableService;
import org.gjt.sp.jedit.textarea.TextArea;

public class TransferHandler {
    private static final TransferHandler instance = new TransferHandler();
    private final List<JEditTransferableService> services = new ArrayList<JEditTransferableService>();

    private TransferHandler() {
    }

    public static TransferHandler getInstance() {
        return instance;
    }

    public void registerTransferableService(JEditTransferableService jEditTransferableService) {
        if (!this.services.contains(jEditTransferableService)) {
            this.services.add(jEditTransferableService);
        }
    }

    public Transferable getTransferable(TextArea textArea, String string) {
        HashMap<DataFlavor, Transferable> hashMap = new HashMap<DataFlavor, Transferable>();
        for (JEditTransferableService jEditTransferableService : this.services) {
            DataFlavor[] dataFlavorArray;
            if (!jEditTransferableService.accept(textArea, string)) continue;
            Transferable transferable = jEditTransferableService.getTransferable(textArea, string);
            for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
                hashMap.put(dataFlavor, transferable);
            }
        }
        JEditTransferable jEditTransferable = new JEditTransferable(hashMap);
        return jEditTransferable;
    }
}

