/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.apache.sshd.common.util.ValidateUtils;

public final class GenericUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Object NULL = new Object();
    public static final Comparator<String> CASE_SENSITIVE_ORDER = (s1, s2) -> {
        if (s1 == s2) {
            return 0;
        }
        return s1.compareTo((String)s2);
    };
    public static final String QUOTES = "\"'";
    private static final Supplier CASE_INSENSITIVE_MAP_FACTORY = () -> new TreeMap(String.CASE_INSENSITIVE_ORDER);

    private GenericUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String trimToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static String replaceWhitespaceAndTrim(String s) {
        if (s != null) {
            s = s.replace('\t', ' ');
        }
        return GenericUtils.trimToEmpty(s);
    }

    public static int hashCode(String s) {
        return GenericUtils.hashCode(s, null);
    }

    public static int hashCode(String s, Boolean useUppercase) {
        if (GenericUtils.isEmpty(s)) {
            return 0;
        }
        if (useUppercase == null) {
            return s.hashCode();
        }
        if (useUppercase.booleanValue()) {
            return s.toUpperCase().hashCode();
        }
        return s.toLowerCase().hashCode();
    }

    public static int safeCompare(String s1, String s2, boolean caseSensitive) {
        if (GenericUtils.isSameReference(s1, s2)) {
            return 0;
        }
        if (s1 == null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        if (caseSensitive) {
            return s1.compareTo(s2);
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static <T> boolean isSameReference(T o1, T o2) {
        return o1 == o2;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isEmpty(CharSequence cs) {
        return GenericUtils.length(cs) <= 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !GenericUtils.isEmpty(cs);
    }

    public static int indexOf(CharSequence cs, char c) {
        int len = GenericUtils.length(cs);
        for (int pos = 0; pos < len; ++pos) {
            char ch = cs.charAt(pos);
            if (ch != c) continue;
            return pos;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence cs, char c) {
        int len = GenericUtils.length(cs);
        for (int pos = len - 1; pos >= 0; --pos) {
            char ch = cs.charAt(pos);
            if (ch != c) continue;
            return pos;
        }
        return -1;
    }

    public static String[] split(String s, char ch) {
        String v;
        if (GenericUtils.isEmpty(s)) {
            return EMPTY_STRING_ARRAY;
        }
        int lastPos = 0;
        int curPos = s.indexOf(ch);
        if (curPos < 0) {
            return new String[]{s};
        }
        LinkedList<String> values = new LinkedList<String>();
        do {
            v = s.substring(lastPos, curPos);
            values.add(v);
            lastPos = curPos + 1;
        } while (lastPos < s.length() && (curPos = s.indexOf(ch, lastPos)) >= lastPos && curPos < s.length());
        if (lastPos < s.length()) {
            v = s.substring(lastPos);
            values.add(v);
        }
        return values.toArray(new String[values.size()]);
    }

    public static <T> String join(T[] values, char ch) {
        return GenericUtils.join(GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values), ch);
    }

    public static String join(Iterable<?> iter, char ch) {
        return GenericUtils.join(iter == null ? null : iter.iterator(), ch);
    }

    public static String join(Iterator<?> iter, char ch) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        do {
            Object o = iter.next();
            if (sb.length() > 0) {
                sb.append(ch);
            }
            sb.append(Objects.toString(o));
        } while (iter.hasNext());
        return sb.toString();
    }

    public static <T> String join(T[] values, CharSequence sep) {
        return GenericUtils.join(GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values), sep);
    }

    public static String join(Iterable<?> iter, CharSequence sep) {
        return GenericUtils.join(iter == null ? null : iter.iterator(), sep);
    }

    public static String join(Iterator<?> iter, CharSequence sep) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        do {
            Object o = iter.next();
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(Objects.toString(o));
        } while (iter.hasNext());
        return sb.toString();
    }

    public static int size(Collection<?> c) {
        return c == null ? 0 : c.size();
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> c) {
        return !GenericUtils.isEmpty(c);
    }

    public static int size(Map<?, ?> m) {
        return m == null ? 0 : m.size();
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> m) {
        return !GenericUtils.isEmpty(m);
    }

    @SafeVarargs
    public static <T> int length(T ... a) {
        return a == null ? 0 : a.length;
    }

    public static <T> boolean isEmpty(Iterable<? extends T> iter) {
        if (iter == null) {
            return true;
        }
        if (iter instanceof Collection) {
            return GenericUtils.isEmpty((Collection)iter);
        }
        return GenericUtils.isEmpty(iter.iterator());
    }

    public static <T> boolean isNotEmpty(Iterable<? extends T> iter) {
        return !GenericUtils.isEmpty(iter);
    }

    public static <T> boolean isEmpty(Iterator<? extends T> iter) {
        return iter == null || !iter.hasNext();
    }

    public static <T> boolean isNotEmpty(Iterator<? extends T> iter) {
        return !GenericUtils.isEmpty(iter);
    }

    @SafeVarargs
    public static <T> boolean isEmpty(T ... a) {
        return GenericUtils.length(a) <= 0;
    }

    public static int length(char[] chars) {
        return chars == null ? 0 : chars.length;
    }

    public static boolean isEmpty(char[] chars) {
        return GenericUtils.length(chars) <= 0;
    }

    public static int compare(char[] c1, char[] c2) {
        int l1 = GenericUtils.length(c1);
        int l2 = GenericUtils.length(c2);
        int cmpLen = Math.min(l1, l2);
        for (int index = 0; index < cmpLen; ++index) {
            char c11 = c1[index];
            char c22 = c2[index];
            int nRes = Character.compare(c11, c22);
            if (nRes == 0) continue;
            return nRes;
        }
        int nRes = Integer.compare(l1, l2);
        if (nRes != 0) {
            return nRes;
        }
        return 0;
    }

    @SafeVarargs
    public static <E extends Enum<E>> Set<E> of(E ... values) {
        return GenericUtils.of(GenericUtils.isEmpty(values) ? Collections.emptySet() : Arrays.asList(values));
    }

    public static <E extends Enum<E>> Set<E> of(Collection<? extends E> values) {
        if (GenericUtils.isEmpty(values)) {
            return Collections.emptySet();
        }
        EnumSet<Enum> result = null;
        for (Enum v : values) {
            if (result == null) {
                result = EnumSet.of(v);
                continue;
            }
            result.add(v);
        }
        return result;
    }

    public static <T> boolean containsAny(Collection<? extends T> coll, Iterable<? extends T> values) {
        if (GenericUtils.isEmpty(coll)) {
            return false;
        }
        for (T v : values) {
            if (!coll.contains(v)) continue;
            return true;
        }
        return false;
    }

    public static <T> void forEach(Iterable<T> values, Consumer<T> consumer) {
        if (GenericUtils.isNotEmpty(values)) {
            values.forEach(consumer);
        }
    }

    public static <T, U> List<U> map(Collection<T> values, Function<? super T, ? extends U> mapper) {
        return GenericUtils.stream(values).map(mapper).collect(Collectors.toList());
    }

    public static <T, U> NavigableSet<U> mapSort(Collection<T> values, Function<? super T, ? extends U> mapper, Comparator<U> comparator) {
        return GenericUtils.stream(values).map(mapper).collect(GenericUtils.toSortedSet(comparator));
    }

    public static <T, K, U> NavigableMap<K, U> toSortedMap(Iterable<T> values, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Comparator<K> comparator) {
        return GenericUtils.stream(values).collect(GenericUtils.toSortedMap(keyMapper, valueMapper, comparator));
    }

    public static <T, K, U> Collector<T, ?, NavigableMap<K, U>> toSortedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Comparator<K> comparator) {
        return Collectors.toMap(keyMapper, valueMapper, GenericUtils.throwingMerger(), () -> new TreeMap(comparator));
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static <T> Collector<T, ?, NavigableSet<T>> toSortedSet(Comparator<T> comparator) {
        return Collectors.toCollection(() -> new TreeSet(comparator));
    }

    public static <T> Stream<T> stream(Iterable<T> values) {
        if (GenericUtils.isEmpty(values)) {
            return Stream.empty();
        }
        if (values instanceof Collection) {
            return ((Collection)values).stream();
        }
        return StreamSupport.stream(values.spliterator(), false);
    }

    @SafeVarargs
    public static <T> List<T> unmodifiableList(T ... values) {
        return GenericUtils.unmodifiableList(GenericUtils.asList(values));
    }

    public static <T> List<T> unmodifiableList(Collection<? extends T> values) {
        if (GenericUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(values));
    }

    public static <T> List<T> unmodifiableList(Stream<T> values) {
        return GenericUtils.unmodifiableList(values.collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... values) {
        return GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values);
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... values) {
        return new HashSet<T>(GenericUtils.asList(values));
    }

    @SafeVarargs
    public static <V extends Comparable<V>> NavigableSet<V> asSortedSet(V ... values) {
        return GenericUtils.asSortedSet(Comparator.naturalOrder(), values);
    }

    public static <V extends Comparable<V>> NavigableSet<V> asSortedSet(Collection<? extends V> values) {
        return GenericUtils.asSortedSet(Comparator.naturalOrder(), values);
    }

    @SafeVarargs
    public static <V> NavigableSet<V> asSortedSet(Comparator<? super V> comp, V ... values) {
        return GenericUtils.asSortedSet(comp, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <V> NavigableSet<V> asSortedSet(Comparator<? super V> comp, Collection<? extends V> values) {
        TreeSet<V> set = new TreeSet<V>(Objects.requireNonNull(comp, "No comparator"));
        if (GenericUtils.size(values) > 0) {
            set.addAll(values);
        }
        return set;
    }

    public static <V> Supplier<NavigableMap<String, V>> caseInsensitiveMap() {
        return CASE_INSENSITIVE_MAP_FACTORY;
    }

    public static <K, V, M extends Map<V, K>> M flipMap(Map<? extends K, ? extends V> map, Supplier<? extends M> mapCreator, boolean allowDuplicates) {
        Map result = (Map)Objects.requireNonNull(mapCreator.get(), "No map created");
        map.forEach((key, value) -> {
            Object prev = result.put(value, key);
            if (prev != null && !allowDuplicates) {
                ValidateUtils.throwIllegalArgumentException("Multiple values for key=%s: current=%s, previous=%s", value, key, prev);
            }
        });
        return (M)result;
    }

    @SafeVarargs
    public static <K, V, M extends Map<K, V>> M mapValues(Function<? super V, ? extends K> keyMapper, Supplier<? extends M> mapCreator, V ... values) {
        return GenericUtils.mapValues(keyMapper, mapCreator, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <K, V, M extends Map<K, V>> M mapValues(Function<? super V, ? extends K> keyMapper, Supplier<? extends M> mapCreator, Collection<? extends V> values) {
        Map map = (Map)mapCreator.get();
        for (V v : values) {
            K k = keyMapper.apply(v);
            if (k == null) continue;
            map.put(k, v);
        }
        return (M)map;
    }

    @SafeVarargs
    public static <T> T findFirstMatchingMember(Predicate<? super T> acceptor, T ... values) {
        return GenericUtils.findFirstMatchingMember(acceptor, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <T> T findFirstMatchingMember(Predicate<? super T> acceptor, Collection<? extends T> values) {
        List<? extends T> matches = GenericUtils.selectMatchingMembers(acceptor, values);
        return GenericUtils.isEmpty(matches) ? null : (T)matches.get(0);
    }

    @SafeVarargs
    public static <T> List<T> selectMatchingMembers(Predicate<? super T> acceptor, T ... values) {
        return GenericUtils.selectMatchingMembers(acceptor, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <T> List<T> selectMatchingMembers(Predicate<? super T> acceptor, Collection<? extends T> values) {
        return GenericUtils.stream(values).filter(acceptor).collect(Collectors.toList());
    }

    public static CharSequence stripQuotes(CharSequence s) {
        if (GenericUtils.isEmpty(s)) {
            return s;
        }
        for (int index = 0; index < QUOTES.length(); ++index) {
            char delim = QUOTES.charAt(index);
            CharSequence v = GenericUtils.stripDelimiters(s, delim);
            if (v == s) continue;
            return v;
        }
        return s;
    }

    public static CharSequence stripDelimiters(CharSequence s, char delim) {
        if (GenericUtils.isEmpty(s) || s.length() < 2) {
            return s;
        }
        int lastPos = s.length() - 1;
        if (s.charAt(0) != delim || s.charAt(lastPos) != delim) {
            return s;
        }
        return s.subSequence(1, lastPos);
    }

    public static RuntimeException toRuntimeException(Throwable t) {
        return GenericUtils.toRuntimeException(t, true);
    }

    public static RuntimeException toRuntimeException(Throwable t, boolean peelThrowable) {
        Throwable e;
        Throwable throwable = e = peelThrowable ? GenericUtils.peelException(t) : t;
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static Throwable peelException(Throwable t) {
        Exception target;
        if (t == null) {
            return t;
        }
        if (t instanceof UndeclaredThrowableException) {
            Throwable wrapped = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
            if (wrapped != null) {
                return GenericUtils.peelException(wrapped);
            }
            wrapped = t.getCause();
            if (wrapped != t) {
                return GenericUtils.peelException(wrapped);
            }
        } else if (t instanceof InvocationTargetException) {
            Throwable target2 = ((InvocationTargetException)t).getTargetException();
            if (target2 != null) {
                return GenericUtils.peelException(target2);
            }
        } else if (t instanceof ReflectionException) {
            Exception target3 = ((ReflectionException)t).getTargetException();
            if (target3 != null) {
                return GenericUtils.peelException(target3);
            }
        } else if (t instanceof ExecutionException) {
            Throwable wrapped = GenericUtils.resolveExceptionCause(t);
            if (wrapped != null) {
                return GenericUtils.peelException(wrapped);
            }
        } else if (t instanceof MBeanException && (target = ((MBeanException)t).getTargetException()) != null) {
            return GenericUtils.peelException(target);
        }
        return t;
    }

    public static Throwable resolveExceptionCause(Throwable t) {
        if (t == null) {
            return t;
        }
        Throwable c = t.getCause();
        if (c == null) {
            return t;
        }
        return c;
    }

    public static <T extends Throwable> T accumulateException(T current, T extra) {
        if (current == null) {
            return extra;
        }
        if (extra == null || extra == current) {
            return current;
        }
        current.addSuppressed(extra);
        return current;
    }

    public static IOException toIOException(Throwable e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    public static <T> Supplier<T> supplierOf(T value) {
        return () -> value;
    }

    public static <T> Iterator<T> iteratorOf(Iterable<T> iterable) {
        return GenericUtils.iteratorOf(iterable == null ? null : iterable.iterator());
    }

    public static <B, D extends B> Function<D, B> downcast() {
        return t -> t;
    }

    public static <T> T head(Iterable<? extends T> it) {
        if (it == null) {
            return null;
        }
        if (it instanceof Deque) {
            Deque l = (Deque)it;
            return l.size() > 0 ? (T)l.getFirst() : null;
        }
        if (it instanceof List) {
            List l = (List)it;
            return l.size() > 0 ? (T)l.get(0) : null;
        }
        if (it instanceof SortedSet) {
            SortedSet s = (SortedSet)it;
            return s.size() > 0 ? (T)s.first() : null;
        }
        Iterator<T> iter = it.iterator();
        return iter == null || !iter.hasNext() ? null : (T)iter.next();
    }

    public static <T> Iterator<T> iteratorOf(Iterator<T> iter) {
        return iter == null ? Collections.emptyIterator() : iter;
    }

    public static <U, V> Iterable<V> wrapIterable(Iterable<? extends U> iter, Function<? super U, ? extends V> mapper) {
        return () -> GenericUtils.wrapIterator(iter, mapper);
    }

    public static <U, V> Iterator<V> wrapIterator(Iterable<? extends U> iter, Function<? super U, ? extends V> mapper) {
        return GenericUtils.stream(iter).map(mapper).iterator();
    }

    public static <U, V> Iterator<V> wrapIterator(Iterator<? extends U> iter, final Function<? super U, ? extends V> mapper) {
        final Iterator<? extends U> iterator = GenericUtils.iteratorOf(iter);
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public V next() {
                Object value = iterator.next();
                return mapper.apply(value);
            }
        };
    }

    public static <T> T selectNextMatchingValue(Iterator<?> values, Class<T> type) {
        Objects.requireNonNull(type, "No type selector specified");
        if (values == null) {
            return null;
        }
        while (values.hasNext()) {
            Class<?> t;
            Object o = values.next();
            if (o == null || !type.isAssignableFrom(t = o.getClass())) continue;
            return type.cast(o);
        }
        return null;
    }

    public static <T> Iterable<T> multiIterableSuppliers(Iterable<? extends Supplier<? extends Iterable<? extends T>>> providers) {
        return () -> GenericUtils.stream(providers).flatMap(s -> GenericUtils.stream((Iterable)s.get())).map(Function.identity()).iterator();
    }
}

