/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import sun.nio.fs.AbstractWatchService;

abstract class AbstractWatchKey
implements WatchKey {
    static final int MAX_EVENT_LIST_SIZE = 512;
    static final Event<Object> OVERFLOW_EVENT = new Event<Object>(StandardWatchEventKinds.OVERFLOW, null);
    private final AbstractWatchService watcher;
    private final Path dir;
    private State state;
    private List<WatchEvent<?>> events;
    private Map<Object, WatchEvent<?>> lastModifyEvents;

    protected AbstractWatchKey(Path dir, AbstractWatchService watcher) {
        this.watcher = watcher;
        this.dir = dir;
        this.state = State.READY;
        this.events = new ArrayList();
        this.lastModifyEvents = new HashMap();
    }

    final AbstractWatchService watcher() {
        return this.watcher;
    }

    @Override
    public Path watchable() {
        return this.dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void signal() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            if (this.state == State.READY) {
                this.state = State.SIGNALLED;
                this.watcher.enqueueKey(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void signalEvent(WatchEvent.Kind<?> kind, Object context) {
        boolean isModify = kind == StandardWatchEventKinds.ENTRY_MODIFY;
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            int size = this.events.size();
            if (size > 0) {
                WatchEvent<?> prev = this.events.get(size - 1);
                if (prev.kind() == StandardWatchEventKinds.OVERFLOW || kind == prev.kind() && Objects.equals(context, prev.context())) {
                    ((Event)prev).increment();
                    return;
                }
                if (!this.lastModifyEvents.isEmpty()) {
                    if (isModify) {
                        WatchEvent<?> ev = this.lastModifyEvents.get(context);
                        if (ev != null) {
                            assert (ev.kind() == StandardWatchEventKinds.ENTRY_MODIFY);
                            ((Event)ev).increment();
                            return;
                        }
                    } else {
                        this.lastModifyEvents.remove(context);
                    }
                }
                if (size >= 512) {
                    kind = StandardWatchEventKinds.OVERFLOW;
                    isModify = false;
                    context = null;
                }
            }
            Event<Object> ev = new Event<Object>(kind, context);
            if (isModify) {
                this.lastModifyEvents.put(context, ev);
            } else if (kind == StandardWatchEventKinds.OVERFLOW) {
                this.events.clear();
                this.lastModifyEvents.clear();
            }
            this.events.add(ev);
            this.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<WatchEvent<?>> pollEvents() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            List<WatchEvent<?>> result = this.events;
            this.events = new ArrayList();
            this.lastModifyEvents.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean reset() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            if (this.state == State.SIGNALLED && this.isValid()) {
                if (this.events.isEmpty()) {
                    this.state = State.READY;
                } else {
                    this.watcher.enqueueKey(this);
                }
            }
            return this.isValid();
        }
    }

    private static class Event<T>
    implements WatchEvent<T> {
        private final WatchEvent.Kind<T> kind;
        private final T context;
        private int count;

        Event(WatchEvent.Kind<T> type, T context) {
            this.kind = type;
            this.context = context;
            this.count = 1;
        }

        @Override
        public WatchEvent.Kind<T> kind() {
            return this.kind;
        }

        @Override
        public T context() {
            return this.context;
        }

        @Override
        public int count() {
            return this.count;
        }

        void increment() {
            ++this.count;
        }
    }

    private static enum State {
        READY,
        SIGNALLED;

    }
}

